/*
 * Decompiled with CFR 0.152.
 */
package alma.acsplugins.alarmsystem.gui.toolbar;

import alma.acsplugins.alarmsystem.gui.sound.AlarmSound;
import alma.acsplugins.alarmsystem.gui.sound.AlarmSoundListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class SoundWidget
extends JToggleButton
implements ActionListener,
AlarmSoundListener {
    private final AlarmSound alarmSound;
    private static final ImageIcon soundSelIcon = new ImageIcon(SoundWidget.class.getResource("/alma/acsplugins/alarmsystem/gui/resources/sound.png"));
    private static final ImageIcon soundUnselIcon = new ImageIcon(SoundWidget.class.getResource("/alma/acsplugins/alarmsystem/gui/resources/sound_mute.png"));
    private static final ImageIcon soundPlayIcon = new ImageIcon(SoundWidget.class.getResource("/alma/acsplugins/alarmsystem/gui/resources/sound_playing.png"));

    public SoundWidget(AlarmSound alarmSound) {
        super(soundSelIcon, false);
        if (alarmSound == null) {
            throw new IllegalArgumentException("The AlarmSound can't be null");
        }
        this.alarmSound = alarmSound;
        this.alarmSound.addSoundListener(this);
        this.addActionListener(this);
        this.setSelected(true);
        this.setEnabled(false);
        this.toggleSoundButton();
    }

    @Override
    public void played() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SoundWidget.this.toggleSoundButton();
            }
        });
    }

    @Override
    public void playing(int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SoundWidget.this.setIcon(soundPlayIcon);
                SoundWidget.this.setToolTipText("Playing...");
                SoundWidget.this.setEnabled(false);
            }
        });
    }

    @Override
    public void reset() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SoundWidget.this.setSelected(false);
                SoundWidget.this.toggleSoundButton();
            }
        });
    }

    private void toggleSoundButton() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SoundWidget.this.setToolTipText("Enable/disable audibles");
                if (SoundWidget.this.isSelected()) {
                    SoundWidget.this.alarmSound.inhibit(1);
                    SoundWidget.this.setIcon(soundUnselIcon);
                } else {
                    SoundWidget.this.alarmSound.inhibit(3);
                    SoundWidget.this.setIcon(soundSelIcon);
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this) {
            this.toggleSoundButton();
        } else {
            System.err.println("Unknown source of events " + actionEvent.getSource());
        }
    }
}

