/*
 * Decompiled with CFR 0.152.
 */
package alma.acsplugins.alarmsystem.gui.table;

import alma.acsplugins.alarmsystem.gui.table.AlarmGUIType;
import cern.laser.client.data.Alarm;
import cern.laser.client.data.Location;
import cern.laser.client.data.ResponsiblePerson;
import cern.laser.client.data.Source;
import cern.laser.client.data.Status;
import cern.laser.client.data.Triplet;
import java.net.URL;
import java.util.Collection;
import java.util.Properties;

public class AlarmTableEntry
implements Alarm {
    private static final String baciLevelPropName = "BACI_Level";
    private static final String baciDescPropName = "BACI_Description";
    private static final String baciValuePropName = "BACI_Value";
    private static final String baciPropName = "BACI_Property";
    private volatile boolean isNew;
    private Alarm alarm;
    private AlarmGUIType alarmType;

    public AlarmTableEntry(Alarm alarm) {
        if (alarm == null) {
            throw new IllegalArgumentException("The alarm can't be null");
        }
        this.alarm = alarm instanceof AlarmTableEntry ? ((AlarmTableEntry)alarm).getEncapsulatedAlarm() : alarm;
        this.isNew = true;
        this.alarmType = AlarmGUIType.fromAlarm(this);
    }

    public void updateAlarm(AlarmTableEntry alarmTableEntry) {
        if (alarmTableEntry == null) {
            throw new IllegalArgumentException("The alarm can't be null");
        }
        if (!alarmTableEntry.getAlarmId().equals(this.alarm.getAlarmId())) {
            throw new IllegalArgumentException("The ID of the new alarm is not equals to the old one");
        }
        this.alarm = alarmTableEntry.getEncapsulatedAlarm();
        this.alarmType = AlarmGUIType.fromAlarm(this);
        if (alarmTableEntry.getStatus().isActive()) {
            this.isNew = true;
        }
    }

    public Alarm getEncapsulatedAlarm() {
        return this.alarm;
    }

    public AlarmGUIType getAlarmType() {
        return this.alarmType;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void alarmSeen() {
        this.isNew = false;
    }

    public boolean isReduced() {
        return this.alarm.getStatus().isReduced();
    }

    public boolean isChild() {
        return this.alarm.isNodeChild() || this.alarm.isMultiplicityChild();
    }

    public boolean isParent() {
        return this.alarm.isNodeParent() || this.alarm.isMultiplicityParent();
    }

    public Object clone() throws CloneNotSupportedException {
        return this.alarm.clone();
    }

    public String getAction() {
        return this.alarm.getAction();
    }

    public String getAlarmId() {
        return this.alarm.getAlarmId();
    }

    public Collection getCategories() {
        return this.alarm.getCategories();
    }

    public String getCause() {
        return this.alarm.getCause();
    }

    public String getConsequence() {
        return this.alarm.getConsequence();
    }

    public URL getHelpURL() {
        return this.alarm.getHelpURL();
    }

    public String getIdentifier() {
        return this.alarm.getIdentifier();
    }

    public Location getLocation() {
        return this.alarm.getLocation();
    }

    public String getPiquetEmail() {
        return this.alarm.getPiquetEmail();
    }

    public String getPiquetGSM() {
        return this.alarm.getPiquetGSM();
    }

    public Integer getPriority() {
        Properties properties = this.alarm.getStatus().getUserProperties();
        if (properties == null || properties.isEmpty()) {
            return this.alarm.getPriority();
        }
        String string = properties.getProperty(baciLevelPropName);
        if (string == null || string.isEmpty()) {
            return this.alarm.getPriority();
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            System.err.println("Error parsing the integer of property BACI_Level=" + string);
            return this.alarm.getPriority();
        }
    }

    public synchronized String getProblemDescription() {
        String string;
        String string2;
        Properties properties = this.alarm.getStatus().getUserProperties();
        if (properties == null || properties.isEmpty()) {
            return this.alarm.getProblemDescription();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.alarm.getProblemDescription() != null) {
            stringBuilder.append(this.alarm.getProblemDescription().trim());
        }
        if ((string2 = properties.getProperty(baciValuePropName)) != null && !string2.isEmpty()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("Value=");
            stringBuilder.append(string2.trim());
        }
        if ((string = properties.getProperty(baciDescPropName)) != null && !string.isEmpty()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("Property desc.=");
            stringBuilder.append(string.trim());
        }
        return stringBuilder.toString();
    }

    public ResponsiblePerson getResponsiblePerson() {
        return this.alarm.getResponsiblePerson();
    }

    public Source getSource() {
        return this.alarm.getSource();
    }

    public Status getStatus() {
        return this.alarm.getStatus();
    }

    public String getSystemName() {
        return this.alarm.getSystemName();
    }

    public Triplet getTriplet() {
        return this.alarm.getTriplet();
    }

    public boolean isInstant() {
        return this.alarm.isInstant();
    }

    public boolean isMultiplicityChild() {
        return this.alarm.isMultiplicityChild();
    }

    public boolean isMultiplicityParent() {
        return this.alarm.isMultiplicityParent();
    }

    public boolean isNodeChild() {
        return this.alarm.isNodeChild();
    }

    public boolean isNodeParent() {
        return this.alarm.isNodeParent();
    }
}

