/*
 * Decompiled with CFR 0.152.
 */
package alma.acsplugins.alarmsystem.gui.table;

import alma.acs.util.IsoDateFormat;
import alma.acsplugins.alarmsystem.gui.CernSysPanel;
import alma.acsplugins.alarmsystem.gui.reduced.ReducedChainDlg;
import alma.acsplugins.alarmsystem.gui.table.AlarmGUIType;
import alma.acsplugins.alarmsystem.gui.table.AlarmTableEntry;
import alma.acsplugins.alarmsystem.gui.table.AlarmTableModel;
import alma.acsplugins.alarmsystem.gui.table.ClipboardHelper;
import alma.acsplugins.alarmsystem.gui.table.SearchEngine;
import alma.alarmsystem.clients.CategoryClient;
import cern.laser.client.data.Alarm;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class AlarmTable
extends JTable
implements ActionListener {
    private final AlarmTableModel model;
    private final CernSysPanel panel;
    private TableRowSorter<AlarmTableModel> sorter;
    private DefaultListSelectionModel selectionModel;
    private TableColumn[] columns;
    private AlarmTableMouseAdapter mouseAdapter = new AlarmTableMouseAdapter();
    private final AlarmTableFilter filter = new AlarmTableFilter();
    private ClipboardHelper clipboard = new ClipboardHelper();
    private JPopupMenu popupM = new JPopupMenu("Alarm");
    private JMenuItem ackMI = new JMenuItem("Acknowledge");
    private JMenuItem saveMI = new JMenuItem("Save...");
    private JMenuItem clipMI = new JMenuItem("To clipboard");
    private JMenuItem showReducedMI = new JMenuItem("Show reduction chain");
    private JLabel emptyLbl = new JLabel();
    private ReducedChainDlg reducedDlg = null;
    private final SearchEngine searchEngine;
    private String selectedAlarmId = null;
    public static final JLabel reductionRenderer = new JLabel(new ImageIcon(AlarmGUIType.class.getResource("/alma/acsplugins/alarmsystem/gui/resources/arrow_in.png")), 0);
    public static final JLabel hasReducedNodesRenderer = new JLabel(new ImageIcon(AlarmGUIType.class.getResource("/alma/acsplugins/alarmsystem/gui/resources/add.png")), 0);

    public AlarmTable(AlarmTableModel alarmTableModel, CernSysPanel cernSysPanel) {
        super(alarmTableModel);
        if (alarmTableModel == null) {
            throw new IllegalArgumentException("Invalid null model in constructor");
        }
        this.model = alarmTableModel;
        if (cernSysPanel == null) {
            throw new IllegalArgumentException("Invalid null panel in constructor");
        }
        this.panel = cernSysPanel;
        this.initialize();
        this.searchEngine = new SearchEngine(this, alarmTableModel);
    }

    private void initialize() {
        this.setShowHorizontalLines(true);
        this.selectionModel = new DefaultListSelectionModel();
        this.selectionModel.setSelectionMode(2);
        this.setSelectionModel(this.selectionModel);
        this.setOpaque(false);
        this.sorter = new TableRowSorter<AlarmTableModel>(this.model);
        this.setRowSorter(this.sorter);
        this.sorter.setMaxSortKeys(2);
        this.sorter.setSortsOnUpdates(true);
        ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
        arrayList.add(new RowSorter.SortKey(AlarmTableModel.AlarmTableColumn.PRIORITY.ordinal(), SortOrder.ASCENDING));
        arrayList.add(new RowSorter.SortKey(AlarmTableModel.AlarmTableColumn.TIME.ordinal(), SortOrder.DESCENDING));
        this.sorter.setSortKeys(arrayList);
        TableColumnModel tableColumnModel = this.getColumnModel();
        this.columns = new TableColumn[tableColumnModel.getColumnCount()];
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i] = tableColumnModel.getColumn(i);
            this.columns[i].setIdentifier((Object)AlarmTableModel.AlarmTableColumn.values()[i]);
            if (this.columns[i].getIdentifier() == AlarmTableModel.AlarmTableColumn.ICON || this.columns[i].getIdentifier() == AlarmTableModel.AlarmTableColumn.REDUCED || this.columns[i].getIdentifier() == AlarmTableModel.AlarmTableColumn.HIDES_CHILDREN) {
                this.columns[i].setWidth(20);
                this.columns[i].setResizable(false);
                this.columns[i].setPreferredWidth(20);
                this.columns[i].setMaxWidth(20);
                this.columns[i].setMinWidth(20);
                continue;
            }
            if (this.columns[i].getIdentifier() != AlarmTableModel.AlarmTableColumn.PRIORITY) continue;
            BufferedImage bufferedImage = new BufferedImage(100, 100, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            FontMetrics object = graphics2D.getFontMetrics();
            int n = object.stringWidth(AlarmTableModel.PriorityLabel.VERY_HIGH.description);
            this.columns[i].setPreferredWidth(n + 6);
            this.columns[i].setMaxWidth(n + 8);
        }
        for (AlarmTableModel.AlarmTableColumn alarmTableColumn : AlarmTableModel.AlarmTableColumn.values()) {
            if (alarmTableColumn.visibleAtStartup) continue;
            tableColumnModel.removeColumn(this.columns[alarmTableColumn.ordinal()]);
        }
        this.buildPopupMenu();
        this.addMouseListener(this.mouseAdapter);
        this.getTableHeader().addMouseListener(new AlarmHeaderMouseAdapter());
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setDismissDelay(Integer.MAX_VALUE);
        toolTipManager.setLightWeightPopupEnabled(true);
    }

    private void buildPopupMenu() {
        this.popupM.add(this.ackMI);
        this.popupM.add(this.showReducedMI);
        this.popupM.add(new JSeparator());
        this.popupM.add(this.saveMI);
        this.popupM.add(this.clipMI);
        this.popupM.pack();
        this.ackMI.addActionListener(this);
        this.saveMI.addActionListener(this);
        this.clipMI.addActionListener(this);
        this.showReducedMI.addActionListener(this);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Serializable serializable;
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        AlarmTableEntry alarmTableEntry = null;
        try {
            alarmTableEntry = this.model.getRowEntry(this.sorter.convertRowIndexToModel(n));
        }
        catch (Throwable throwable) {
            alarmTableEntry = null;
        }
        if (alarmTableEntry == null) {
            return this.emptyLbl;
        }
        if (tableColumn.getIdentifier().equals((Object)AlarmTableModel.AlarmTableColumn.ICON)) {
            if (this.model.isRowAlarmNew(this.sorter.convertRowIndexToModel(n))) {
                return AlarmGUIType.fromAlarm((AlarmTableEntry)alarmTableEntry).flagRenderer;
            }
            return this.emptyLbl;
        }
        if (tableColumn.getIdentifier().equals((Object)AlarmTableModel.AlarmTableColumn.REDUCED)) {
            if (alarmTableEntry.isReduced()) {
                return reductionRenderer;
            }
            return this.emptyLbl;
        }
        if (tableColumn.getIdentifier().equals((Object)AlarmTableModel.AlarmTableColumn.HIDES_CHILDREN)) {
            if (alarmTableEntry.isParent()) {
                return hasReducedNodesRenderer;
            }
            return this.emptyLbl;
        }
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        if (alarmTableEntry.getAlarmId().equals(this.selectedAlarmId)) {
            serializable = component.getFont();
            Font font = ((Font)serializable).deriveFont(1);
            component.setFont(font);
        }
        this.colorizeCell(component, alarmTableEntry);
        if (component instanceof JComponent) {
            serializable = (JComponent)component;
            if (this.model.getCellContent(this.sorter.convertRowIndexToModel(n), this.convertColumnIndexToModel(n2)) == null) {
                ((JComponent)serializable).setToolTipText(null);
            } else {
                ((JComponent)serializable).setToolTipText("<HTML>" + this.model.getCellContent(this.sorter.convertRowIndexToModel(n), this.convertColumnIndexToModel(n2)));
            }
        }
        return component;
    }

    private void colorizeCell(Component component, AlarmTableEntry alarmTableEntry) {
        AlarmGUIType alarmGUIType = AlarmGUIType.fromAlarm(alarmTableEntry);
        component.setForeground(alarmGUIType.foreg);
        component.setBackground(alarmGUIType.backg);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.saveMI) {
            this.saveAlarm(this.mouseAdapter.selectedAlarm);
        } else if (actionEvent.getSource() == this.clipMI) {
            this.clipboard.setClipboardContents(this.mouseAdapter.selectedAlarm.toString());
        } else if (actionEvent.getSource() == this.ackMI) {
            this.model.acknowledge(this.mouseAdapter.selectedAlarm);
        } else if (actionEvent.getSource() == this.showReducedMI) {
            this.showReductionChain(this.mouseAdapter.selectedAlarm);
        }
    }

    public void saveAlarm(Alarm alarm) {
        JFileChooser jFileChooser = new JFileChooser();
        if (jFileChooser.showSaveDialog(this) != 0) {
            return;
        }
        IsoDateFormat isoDateFormat = new IsoDateFormat();
        StringBuilder stringBuilder = new StringBuilder(alarm.toString());
        stringBuilder.append("\n\n");
        stringBuilder.append("Saved at ");
        stringBuilder.append(isoDateFormat.format(new Date(System.currentTimeMillis())));
        stringBuilder.append("\n\n");
        File file = jFileChooser.getSelectedFile();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file, false);
            fileOutputStream.write(stringBuilder.toString().getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            JOptionPane.showInternalMessageDialog(this, exception.getMessage(), "Error saving", 0);
        }
    }

    public void close() {
        if (this.reducedDlg != null) {
            this.reducedDlg.close();
        }
    }

    private void showReductionChain(AlarmTableEntry alarmTableEntry) {
        if (alarmTableEntry == null) {
            throw new IllegalArgumentException("The alarm can't be null");
        }
        CategoryClient categoryClient = this.model.getCategoryClient();
        if (this.reducedDlg == null) {
            this.reducedDlg = new ReducedChainDlg(categoryClient, alarmTableEntry, this.panel);
        } else {
            this.reducedDlg.setRootAlarm(alarmTableEntry);
            this.reducedDlg.setVisible(true);
        }
    }

    public void showColumns(AlarmTableModel.AlarmTableColumn[] alarmTableColumnArray) {
        if (alarmTableColumnArray == null || alarmTableColumnArray.length == 0) {
            throw new IllegalArgumentException("Invalid columns array");
        }
        class AddRemoveCol
        extends Thread {
            public AlarmTableModel.AlarmTableColumn[] aTCs;

            AddRemoveCol() {
            }

            @Override
            public void run() {
                TableColumnModel tableColumnModel = AlarmTable.this.getColumnModel();
                for (TableColumn tableColumn : AlarmTable.this.columns) {
                    tableColumnModel.removeColumn(tableColumn);
                }
                block1: for (AlarmTableModel.AlarmTableColumn alarmTableColumn : this.aTCs) {
                    for (int i = 0; i < AlarmTable.this.columns.length; ++i) {
                        if (AlarmTable.this.columns[i].getIdentifier() != alarmTableColumn) continue;
                        tableColumnModel.addColumn(AlarmTable.this.columns[i]);
                        continue block1;
                    }
                }
            }
        }
        AddRemoveCol addRemoveCol = new AddRemoveCol();
        addRemoveCol.aTCs = alarmTableColumnArray;
        SwingUtilities.invokeLater(addRemoveCol);
    }

    public void addRemoveColumn(AlarmTableModel.AlarmTableColumn alarmTableColumn, boolean bl) {
        if (alarmTableColumn == null) {
            throw new IllegalArgumentException("The column to add/remove can't be null");
        }
        class AddRemoveCol
        extends Thread {
            public TableColumn col;
            public boolean toAdd;

            AddRemoveCol() {
            }

            @Override
            public void run() {
                TableColumnModel tableColumnModel = AlarmTable.this.getColumnModel();
                if (this.toAdd) {
                    tableColumnModel.addColumn(this.col);
                } else {
                    tableColumnModel.removeColumn(this.col);
                }
            }
        }
        AddRemoveCol addRemoveCol = new AddRemoveCol();
        addRemoveCol.col = this.columns[alarmTableColumn.ordinal()];
        addRemoveCol.toAdd = bl;
        SwingUtilities.invokeLater(addRemoveCol);
    }

    public boolean search(String string, boolean bl) {
        int n = this.searchEngine.search(string, bl);
        if (n != -1) {
            this.changeSelection(n, 1, false, false);
            this.panel.showMessage("Entry found at " + n, false);
        } else {
            this.panel.showMessage("No alarm found", true);
        }
        return n != -1;
    }

    @Override
    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        super.changeSelection(n, n2, bl, bl2);
        int n3 = this.sorter.convertRowIndexToModel(n);
        this.panel.showAlarmDetails(this.model.getAlarmAt(n3));
        this.selectedAlarmId = this.model.getAlarmAt(n3).getAlarmId();
    }

    public void filter(String string, boolean bl) {
        if (string == null || string.isEmpty()) {
            this.sorter.setRowFilter(null);
        } else {
            this.filter.setFilter(string, bl);
            this.sorter.setRowFilter(this.filter);
        }
    }

    private String getSelectedAlarmId() {
        return this.selectedAlarmId;
    }

    private class AlarmTableFilter
    extends RowFilter<AlarmTableModel, Integer> {
        private boolean applyAsNot = false;
        private String filterString;

        private AlarmTableFilter() {
        }

        public void setFilter(String string, boolean bl) {
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException("The string for filtering can't be null nor empty");
            }
            this.applyAsNot = bl;
            this.filterString = string;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends AlarmTableModel, ? extends Integer> entry) {
            boolean bl = false;
            TableColumnModel tableColumnModel = AlarmTable.this.getColumnModel();
            int n = entry.getIdentifier();
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                int n2 = tableColumn.getModelIndex();
                Object object = AlarmTable.this.model.getValueAt(n, n2);
                if (!(object instanceof String) || !object.toString().contains(this.filterString)) continue;
                bl = true;
            }
            if (this.applyAsNot) {
                return !bl;
            }
            return bl;
        }
    }

    private class AlarmHeaderMouseAdapter
    extends MouseAdapter
    implements ActionListener {
        private JPopupMenu headerPopup = new JPopupMenu("Header");
        private JCheckBoxMenuItem[] menuItems = new JCheckBoxMenuItem[AlarmTableModel.AlarmTableColumn.values().length];

        public AlarmHeaderMouseAdapter() {
            int n = 0;
            for (AlarmTableModel.AlarmTableColumn alarmTableColumn : AlarmTableModel.AlarmTableColumn.values()) {
                this.menuItems[n] = new JCheckBoxMenuItem(alarmTableColumn.popupTitle);
                this.menuItems[n].addActionListener(this);
                this.headerPopup.add(this.menuItems[n++]);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            class ShowHeaderPopup
            extends Thread {
                MouseEvent e;

                public ShowHeaderPopup(MouseEvent mouseEvent) {
                    this.e = mouseEvent;
                }

                @Override
                public void run() {
                    AlarmHeaderMouseAdapter.this.ratioMenu();
                    AlarmHeaderMouseAdapter.this.headerPopup.show(this.e.getComponent(), this.e.getX(), this.e.getY());
                }
            }
            SwingUtilities.invokeLater(new ShowHeaderPopup(mouseEvent));
        }

        private void ratioMenu() {
            TableColumnModel tableColumnModel = AlarmTable.this.getColumnModel();
            int n = 0;
            for (AlarmTableModel.AlarmTableColumn alarmTableColumn : AlarmTableModel.AlarmTableColumn.values()) {
                try {
                    tableColumnModel.getColumnIndex((Object)alarmTableColumn);
                    this.menuItems[n].setSelected(true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.menuItems[n].setSelected(false);
                }
                ++n;
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = null;
            int n = -1;
            for (int i = 0; i < this.menuItems.length; ++i) {
                if (actionEvent.getSource() != this.menuItems[i]) continue;
                abstractButton = this.menuItems[i];
                n = i;
                break;
            }
            if (abstractButton == null) {
                System.out.println("Unknown source of event: " + actionEvent.getSource());
                return;
            }
            AlarmTable.this.addRemoveColumn(AlarmTableModel.AlarmTableColumn.values()[n], abstractButton.isSelected());
        }
    }

    private class AlarmTableMouseAdapter
    extends MouseAdapter {
        public AlarmTableEntry selectedAlarm;

        private AlarmTableMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.alarmSelected(mouseEvent);
            this.showPopup(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.alarmSelected(mouseEvent);
            this.showPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.alarmSelected(mouseEvent);
            this.showPopup(mouseEvent);
        }

        private void alarmSelected(MouseEvent mouseEvent) {
            int n = AlarmTable.this.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            AlarmTable.this.model.alarmSelected(AlarmTable.this.getRowSorter().convertRowIndexToModel(n));
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            int n = AlarmTable.this.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            this.selectedAlarm = AlarmTable.this.model.getRowAlarm(AlarmTable.this.getRowSorter().convertRowIndexToModel(n));
            class ShowPopup
            extends Thread {
                MouseEvent e;

                public ShowPopup(MouseEvent mouseEvent) {
                    this.e = mouseEvent;
                }

                @Override
                public void run() {
                    AlarmTable.this.ackMI.setEnabled(!AlarmTableMouseAdapter.this.selectedAlarm.getStatus().isActive());
                    AlarmTable.this.showReducedMI.setEnabled(AlarmTableMouseAdapter.this.selectedAlarm != null && (AlarmTableMouseAdapter.this.selectedAlarm.isNodeParent() || AlarmTableMouseAdapter.this.selectedAlarm.isMultiplicityParent()));
                    AlarmTable.this.popupM.show(this.e.getComponent(), this.e.getX(), this.e.getY());
                    AlarmTable.this.popupM.setVisible(true);
                }
            }
            SwingUtilities.invokeLater(new ShowPopup(mouseEvent));
        }
    }
}

