/*
 * Decompiled with CFR 0.152.
 */
package alma.acsplugins.alarmsystem.gui.sound;

import alma.acsplugins.alarmsystem.gui.sound.AlarmSoundListener;
import alma.acsplugins.alarmsystem.gui.table.AlarmTableModel;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AlarmSound
extends TimerTask {
    private final AlarmTableModel tableModel;
    private final int EXTERNAL_BUFFER_SIZE = 524288;
    private static final int TIME_INTERVAL = 60;
    private static final int INHIBIT_TIME = 15;
    private int soundLevel = 3;
    private int inhibitCounter = 0;
    private final Timer timer = new Timer("AlarmSound", true);
    private boolean closed = false;
    private volatile AlarmSoundListener listener = null;
    private static final URL[] soundURLs = new URL[]{AlarmSound.class.getResource("/alma/acsplugins/alarmsystem/gui/sound/resources/level0.wav"), AlarmSound.class.getResource("/alma/acsplugins/alarmsystem/gui/sound/resources/level1.wav"), AlarmSound.class.getResource("/alma/acsplugins/alarmsystem/gui/sound/resources/level2.wav"), AlarmSound.class.getResource("/alma/acsplugins/alarmsystem/gui/sound/resources/level3.wav")};

    public AlarmSound(AlarmTableModel alarmTableModel) {
        if (alarmTableModel == null) {
            throw new IllegalArgumentException("The AlarmTableModel can't be null");
        }
        this.tableModel = alarmTableModel;
        this.timer.schedule((TimerTask)this, 60000L, 60000L);
        this.dumpAudioInformation();
    }

    private void play(int n) throws Exception {
        if (n < 0 || n > 3) {
            throw new IllegalStateException("Invalid alarm priority " + n);
        }
        System.out.println("Emitting sound for priority " + n);
        URL uRL = soundURLs[n];
        AudioInputStream audioInputStream = null;
        try {
            audioInputStream = AudioSystem.getAudioInputStream(uRL);
            System.out.println("Audio stream obtained from AudioSystem");
        }
        catch (Throwable throwable) {
            System.err.println(throwable.getMessage());
            throwable.printStackTrace();
            return;
        }
        AudioFormat audioFormat = audioInputStream.getFormat();
        SourceDataLine sourceDataLine = null;
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length && sourceDataLine == null; ++i) {
            Mixer.Info info2 = infoArray[i];
            System.out.println("Trying mixer " + info2.getDescription());
            try {
                Mixer mixer = AudioSystem.getMixer(info2);
                sourceDataLine = (SourceDataLine)mixer.getLine(info);
                System.out.println("Line obtained");
            }
            catch (LineUnavailableException lineUnavailableException) {
                System.out.println("Line unavailable " + lineUnavailableException.getMessage());
                sourceDataLine = null;
                continue;
            }
            catch (Throwable throwable) {
                System.out.println("Exception getting the line " + throwable.getMessage());
                sourceDataLine = null;
                continue;
            }
            System.out.println("Availbale bytes " + sourceDataLine.available());
            try {
                sourceDataLine.open(audioFormat, 524288);
                System.out.println("Line opened");
            }
            catch (Throwable throwable) {
                System.err.println("Error opeining the line: " + throwable.getMessage());
                sourceDataLine = null;
                continue;
            }
            try {
                sourceDataLine.start();
                System.out.println("Line started");
            }
            catch (Throwable throwable) {
                System.err.println("Error starting the line: " + throwable.getMessage());
                sourceDataLine = null;
                continue;
            }
            try {
                this.playOnLine(sourceDataLine, audioInputStream);
            }
            catch (Throwable throwable) {
                System.err.println("Error playing: " + throwable.getMessage());
                sourceDataLine = null;
                continue;
            }
            sourceDataLine.drain();
            System.out.println("Line drain");
            sourceDataLine.close();
            System.out.println("Line closed");
        }
    }

    private void playOnLine(SourceDataLine sourceDataLine, AudioInputStream audioInputStream) {
        if (sourceDataLine == null) {
            return;
        }
        int n = 0;
        byte[] byArray = new byte[524288];
        try {
            while (n != -1) {
                n = audioInputStream.read(byArray, 0, byArray.length);
                System.out.println("\t" + n + " bytes read");
                if (n < 0) continue;
                int n2 = sourceDataLine.write(byArray, 0, n);
                System.out.println("\t" + n2 + " bytes sent");
            }
            System.out.println("Bytes sent.");
        }
        catch (IOException iOException) {
            System.err.println("Exception caught: " + iOException.getMessage());
        }
    }

    public void inhibit(int n) {
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("Level " + n + " not in [1,3]");
        }
        this.soundLevel = n;
        this.inhibitCounter = 0;
    }

    public int getSoundLevel() {
        return this.soundLevel;
    }

    public void close() {
        this.listener = null;
        this.closed = true;
        this.timer.cancel();
    }

    @Override
    public void run() {
        int n;
        System.out.println("Timer task");
        if (++this.inhibitCounter >= 15) {
            this.inhibitCounter = 0;
            this.soundLevel = 3;
            System.out.println("Sound reset to " + this.soundLevel);
            if (this.listener != null) {
                // empty if block
            }
        }
        if ((n = this.tableModel.hasNotAckAlarms()) > 1) {
            return;
        }
        if (n < 0 || n > this.soundLevel) {
            System.out.println("No sound to play (priority=" + n + ", soundLevel=" + this.soundLevel + ")");
            return;
        }
        if (this.listener != null) {
            this.listener.playing(n);
        }
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AlarmSound.this.play(n);
                }
                catch (Throwable throwable) {
                    System.err.println("Error emitting sound for priority " + n);
                    throwable.printStackTrace(System.err);
                }
                finally {
                    if (AlarmSound.this.listener != null) {
                        AlarmSound.this.listener.played();
                    }
                }
            }
        }, "SoundPlayer");
        thread.setDaemon(true);
        thread.start();
    }

    public void addSoundListener(AlarmSoundListener alarmSoundListener) {
        this.listener = alarmSoundListener;
    }

    private void dumpAudioInformation() {
        AudioFileFormat.Type[] typeArray = AudioSystem.getAudioFileTypes();
        if (typeArray == null || typeArray.length == 0) {
            System.out.println("No audio file types supported.");
        } else {
            for (AudioFileFormat.Type type : typeArray) {
                System.out.println(type.toString() + ", extension " + type.getExtension());
            }
        }
        Object[] objectArray = AudioSystem.getMixerInfo();
        System.out.println("Mixers found: " + objectArray.length);
        for (Object object : objectArray) {
            System.out.println("\tMixer " + ((Mixer.Info)object).getName() + ": " + ((Mixer.Info)object).getVendor() + ", " + ((Mixer.Info)object).getDescription());
        }
        for (URL uRL : soundURLs) {
            AudioFileFormat audioFileFormat = null;
            try {
                audioFileFormat = AudioSystem.getAudioFileFormat(uRL);
            }
            catch (IOException iOException) {
                System.out.println("Error " + iOException.getMessage() + " accessing URL " + uRL.toString());
                continue;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                System.out.println("Unsupported audio format for " + uRL + " (" + unsupportedAudioFileException.getMessage() + ")");
            }
            System.out.println("Properties of " + uRL);
            System.out.println("\tAudio file type " + audioFileFormat.getType().toString());
            System.out.println("\tIs file type supported: " + AudioSystem.isFileTypeSupported(audioFileFormat.getType()));
            System.out.println("\tLength in byes " + audioFileFormat.getByteLength());
            Map<String, Object> unsupportedAudioFileException = audioFileFormat.properties();
            Set<String> set = unsupportedAudioFileException.keySet();
            for (String string : set) {
                System.out.println("\t[" + string + ", " + unsupportedAudioFileException.get(string).toString() + "]");
            }
            AudioFormat audioFormat = audioFileFormat.getFormat();
            System.out.println("\tEncoding " + audioFormat.getEncoding().toString());
            System.out.print("\tByte order ");
            if (audioFormat.isBigEndian()) {
                System.out.println("big endian");
            } else {
                System.out.println("little endian");
            }
            System.out.println("\tSample rate: " + audioFormat.getSampleRate());
            System.out.println("\tNum. of bits of a sample: " + audioFormat.getSampleSizeInBits());
            System.out.println("\tNum. of channels: " + audioFormat.getChannels());
        }
    }
}

