/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.common.base.Function;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCache<Key, Value> {
    private final WeakHashMap<Key, Value> content;
    private final Function<Key, Value> f;

    public SimpleCache(Function<Key, Value> f) {
        if (f == null) {
            throw new IllegalArgumentException("function may not be null");
        }
        this.f = f;
        this.content = new WeakHashMap();
    }

    public synchronized Value get(Key k) {
        Object result = this.content.get(k);
        if (result == null && !this.content.containsKey(k)) {
            result = this.f.apply(k);
            this.content.put(k, result);
        }
        return result;
    }

    public synchronized void clear() {
        this.content.clear();
    }

    public synchronized void discard(Key k) {
        this.content.remove(k);
    }

    public synchronized boolean hasCachedValue(Key key) {
        return this.content.containsKey(key);
    }

    public synchronized int getSize() {
        return this.content.size();
    }

    public synchronized boolean isEmpty() {
        return this.content.isEmpty();
    }
}

