/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.implementation;

import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import org.prevayler.Command;
import org.prevayler.PrevalentSystem;
import org.prevayler.Prevayler;
import org.prevayler.implementation.ClockRecoveryCommand;
import org.prevayler.implementation.CommandInputStream;
import org.prevayler.implementation.CommandOutputStream;
import org.prevayler.implementation.SystemClock;

public class SnapshotPrevayler
implements Prevayler {
    private final PrevalentSystem system;
    private final SystemClock clock;
    private final CommandOutputStream output;

    public SnapshotPrevayler(PrevalentSystem prevalentSystem) throws IOException, ClassNotFoundException {
        this(prevalentSystem, "PrevalenceBase");
    }

    public SnapshotPrevayler(PrevalentSystem prevalentSystem, String string) throws IOException, ClassNotFoundException {
        prevalentSystem.clock(new SystemClock());
        CommandInputStream commandInputStream = new CommandInputStream(string);
        PrevalentSystem prevalentSystem2 = commandInputStream.readLastSnapshot();
        this.system = prevalentSystem2 == null ? prevalentSystem : prevalentSystem2;
        this.recoverCommands(commandInputStream);
        this.output = commandInputStream.commandOutputStream();
        this.clock = (SystemClock)this.system.clock();
        this.clock.resume();
    }

    public PrevalentSystem system() {
        return this.system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Serializable executeCommand(Command command) throws Exception {
        this.clock.pause();
        try {
            this.output.writeCommand(new ClockRecoveryCommand(command, this.clock.time()));
            Serializable serializable = command.execute(this.system);
            Object var4_3 = null;
            this.clock.resume();
            return serializable;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.clock.resume();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void takeSnapshot() throws IOException {
        this.clock.pause();
        try {
            this.output.writeSnapshot(this.system);
            Object var2_1 = null;
            this.clock.resume();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.clock.resume();
            throw throwable;
        }
    }

    private void recoverCommands(CommandInputStream commandInputStream) throws IOException, ClassNotFoundException {
        while (true) {
            Command command;
            try {
                command = commandInputStream.readCommand();
            }
            catch (EOFException eOFException) {
                break;
            }
            try {
                command.execute(this.system);
            }
            catch (Exception exception) {}
        }
    }
}

