/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.implementation;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;

class NumberFileCreator {
    public static final String SNAPSHOT_SUFFIX = "snapshot";
    public static final DecimalFormat SNAPSHOT_FORMAT = new DecimalFormat("000000000000000000000'.'snapshot");
    public static final DecimalFormat LOG_FORMAT = new DecimalFormat("000000000000000000000'.'commandLog");
    private File directory;
    private long nextFileNumber;

    public NumberFileCreator(File file, long l) {
        this.directory = file;
        this.nextFileNumber = l;
    }

    File newLog() throws IOException {
        File file = new File(this.directory, LOG_FORMAT.format(this.nextFileNumber));
        if (!file.createNewFile()) {
            throw new IOException("Attempt to create command log file that already existed: " + file);
        }
        ++this.nextFileNumber;
        return file;
    }

    File newSnapshot() throws IOException {
        File file = new File(this.directory, SNAPSHOT_FORMAT.format(this.nextFileNumber - 1L));
        file.delete();
        return file;
    }

    File newTempSnapshot() throws IOException {
        return File.createTempFile("temp", "generatingSnapshot", this.directory);
    }
}

