/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.check;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.issues.IssuesImpl;
import org.eclipse.emf.mwe.core.issues.MWEDiagnostic;
import org.eclipse.xtend.check.CheckFacade;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtext.validation.AbstractInjectableValidator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.CheckType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCheckValidator
extends AbstractInjectableValidator {
    private ExecutionContext ctx = null;
    private final EnumMap<CheckType, Set<String>> checkFiles = new EnumMap(CheckType.class);

    @Inject
    public void setExecutionContext(ExecutionContext ctx) {
        this.ctx = ctx;
    }

    public void addCheckFile(String checkFile, CheckType checkType) {
        Set<String> checks = this.checkFiles.get(checkType);
        if (checks == null) {
            checks = new LinkedHashSet<String>();
            this.checkFiles.put(checkType, checks);
        }
        checks.add(checkFile);
    }

    public void addCheckFile(String checkFile) {
        this.addCheckFile(checkFile, CheckType.FAST);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        CheckMode mode = CheckMode.getCheckMode(context);
        IssuesImpl issues = new IssuesImpl();
        for (CheckType type : this.checkFiles.keySet()) {
            if (!mode.shouldCheck(type)) continue;
            Set<String> list = this.checkFiles.get(type);
            for (String string : list) {
                CheckFacade.checkAll((String)string, Collections.singleton(eObject), (ExecutionContext)this.ctx, (Issues)issues);
            }
        }
        MWEDiagnostic[] mWEDiagnosticArray = issues.getIssues();
        int n = mWEDiagnosticArray.length;
        int n2 = 0;
        while (n2 < n) {
            MWEDiagnostic diag = mWEDiagnosticArray[n2];
            diagnostics.add((Diagnostic)diag);
            ++n2;
        }
        return !issues.hasErrors();
    }
}

