/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.bulkstore;

import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.acs.component.ComponentImplBase;
import alma.acs.container.ContainerServicesBase;
import alma.acs.exceptions.AcsJException;
import alma.acs.nc.SimpleSupplier;
import alma.archive.ArchiveBulkReceiverPackage.BulkDataStoreNotificationEvent;
import alma.archive.ArchiveBulkReceiverPackage.resultType;
import alma.archive.database.helpers.DBConfiguration;
import alma.archive.database.helpers.DatabaseHelper;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.access.PermissionDeniedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.EntityExistsException;
import alma.archive.exceptions.general.UnknownSchemaException;
import alma.archive.exceptions.syntax.MalformedPermissionsException;
import alma.archive.exceptions.syntax.MalformedURIException;
import alma.archive.exceptions.syntax.MalformedXMLException;
import alma.archive.exceptions.user.UserDoesNotExistException;
import alma.archive.wrappers.ArchiveTimeStamp;
import alma.archive.wrappers.Permissions;
import alma.bulkdata.BulkStoreOperations;
import alma.bulkdata.BulkStorePackage.BulkStoreException;
import alma.entities.commonentity.EntityT;
import alma.ngas.client.JClient;
import alma.ngas.client.Status;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.buni.panto.BodyHeader;
import org.buni.panto.ContentHandler;
import org.buni.panto.IOUtil;
import org.buni.panto.MimeParser;
import org.omg.CORBA.portable.IDLEntity;

public class BulkStoreImpl
extends ComponentImplBase
implements BulkStoreOperations {
    boolean storeInNgas;
    protected String server;
    protected String port;
    protected String testDir;
    protected String m_schema;
    InternalIF m_operArchiveComp;
    protected static String user = "bulkstore";
    protected static String owner = "bulkstore";
    protected String contentType = "multialma/related";
    JClient ngasJClient;
    DBConfiguration config;
    SimpleSupplier bulkNotifyChannel;
    Logger m_logger = Logger.getAnonymousLogger();
    boolean standalone = false;
    boolean initPhase = false;

    public void init() throws BulkStoreException {
        try {
            this.config = DBConfiguration.instance((Logger)this.m_logger);
        }
        catch (DatabaseException databaseException) {
            this.m_logger.severe("Could not read configuration info!");
            throw new BulkStoreException(databaseException.toString());
        }
        boolean bl = this.storeInNgas = this.config.get("archive.ngast.storeInNgast").equalsIgnoreCase("true") || this.config.get("archive.ngast.storeInNgast").equalsIgnoreCase("delayed");
        if (this.storeInNgas) {
            this.server = this.config.get("archive.ngast.servers");
            if (this.server.indexOf(44) != -1) {
                this.server = this.server.substring(0, this.server.indexOf(44));
            }
            if (this.server == null || this.server.equals("")) {
                throw new BulkStoreException("Porperty archive.ngast.servers not defined in archiveConfig. Aborting...");
            }
            if (this.server.indexOf(44) != -1) {
                this.server = this.server.substring(0, this.server.indexOf(44));
            }
            this.port = this.server.substring(this.server.indexOf(58) + 1, this.server.length());
            this.server = this.server.substring(0, this.server.indexOf(58));
        }
        this.testDir = this.config.get("archive.ngast.testDir");
        this.m_schema = this.config.get("archive.bulkstore.schema");
        if (this.m_operArchiveComp == null) {
            try {
                this.m_operArchiveComp = InternalIFFactory.getInternalIF((Logger)this.m_logger);
            }
            catch (DatabaseException databaseException) {
                throw new BulkStoreException(databaseException.toString());
            }
            catch (ModuleCriticalException moduleCriticalException) {
                throw new BulkStoreException(moduleCriticalException.getCause().toString());
            }
        }
        if (!this.standalone && this.bulkNotifyChannel == null) {
            try {
                this.bulkNotifyChannel = new SimpleSupplier("bulkstore", (ContainerServicesBase)this.m_containerServices);
            }
            catch (AcsJException acsJException) {
                throw new BulkStoreException("Could not initialize Notification channel bulkstore");
            }
        }
        try {
            URI uRI = this.m_operArchiveComp.getSchemaManager(user).getSchemaURI(this.m_schema);
        }
        catch (DatabaseException databaseException) {
            this.m_logger.severe("Could not retrieve UID for schema " + this.m_schema);
            throw new BulkStoreException(databaseException.toString());
        }
        catch (UnknownSchemaException unknownSchemaException) {
            this.m_logger.severe("Could find bulkstore schema " + this.m_schema);
            throw new BulkStoreException(unknownSchemaException.toString());
        }
        catch (PermissionDeniedException permissionDeniedException) {
            this.m_logger.severe("No sufficient permissions for reading schema " + this.m_schema);
            throw new BulkStoreException(permissionDeniedException.toString());
        }
        catch (UserDoesNotExistException userDoesNotExistException) {
            this.m_logger.severe("Bulkstore uses unknown user " + user);
            throw new BulkStoreException(userDoesNotExistException.toString());
        }
        catch (ModuleCriticalException moduleCriticalException) {
            this.m_logger.severe("Severe problems in initializing BulkStoreImpl (while retrieving internal IF) " + moduleCriticalException.toString());
            throw new BulkStoreException(moduleCriticalException.getCause().toString());
        }
        catch (ArchiveException archiveException) {
            this.m_logger.severe("Severe problems in initializing BulkStoreImpl (while retrieving internal IF) " + archiveException.toString());
            throw new BulkStoreException(archiveException.toString());
        }
        if (this.storeInNgas) {
            byte[] byArray;
            this.m_logger.info("NGAMS mode: connecting to " + this.server + ":" + this.port);
            Vector<InetSocketAddress> vector = new Vector<InetSocketAddress>();
            vector.add(new InetSocketAddress(this.server, Integer.parseInt(this.port)));
            this.ngasJClient = new JClient(vector, 0, "", null, this.m_logger);
            EntityT entityT = new EntityT();
            try {
                this.m_containerServices.assignUniqueEntityId(entityT);
            }
            catch (AcsJContainerServicesEx acsJContainerServicesEx) {
                throw new BulkStoreException(acsJContainerServicesEx.toString());
            }
            ClassLoader classLoader = DBConfiguration.class.getClassLoader();
            URL uRL = classLoader.getResource("bulkTestData.mime");
            if (uRL == null) {
                throw new BulkStoreException("Could not find BulkStore test data file in bulkstoreImpl.jar. Initialization aborted.");
            }
            try {
                InputStream inputStream = uRL.openStream();
                byArray = new byte[inputStream.available()];
                inputStream.read(byArray);
            }
            catch (IOException iOException) {
                throw new BulkStoreException("Could not read BulkStore test data file in bulkstoreImpl.jar. Initialization aborted.");
            }
            this.initPhase = true;
            this.storeData(entityT.getEntityId(), "ASDMBinaryTable", byArray.length, byArray);
            this.initPhase = false;
        } else {
            if (this.testDir == null || !new File(this.testDir).exists()) {
                this.m_logger.severe("Property archive.ngast.testDir either not specified or pointing to non-existing directory. Aborting");
                throw new BulkStoreException("Porpoerty archive.ngast.testDir either not specified or pointing to non-existing directory. Aborting");
            }
            this.m_logger.info("Local mode: Storing and retrieving files using local disk: " + this.testDir);
        }
    }

    public void close() throws BulkStoreException {
        if (this.bulkNotifyChannel != null) {
            this.bulkNotifyChannel.disconnect();
            this.bulkNotifyChannel = null;
        }
    }

    private void parseMime(String string, URI uRI, String string2, InputStream inputStream) throws BulkStoreException {
        ThreadedMimeParser threadedMimeParser = new ThreadedMimeParser(inputStream, new BulkStoreContentHandler(uRI, string2));
        new Thread(threadedMimeParser).start();
    }

    private void storeStream(String string, String string2, int n, InputStream inputStream) throws BulkStoreException {
        URI uRI;
        try {
            uRI = this.m_operArchiveComp.getSchemaManager(user).getSchemaURI(string2);
        }
        catch (DatabaseException databaseException) {
            this.m_logger.severe("Could not retrieve UID for schema " + string2);
            throw new BulkStoreException(databaseException.toString());
        }
        catch (UnknownSchemaException unknownSchemaException) {
            this.m_logger.severe("Could find bulkstore schema " + string2);
            throw new BulkStoreException(unknownSchemaException.toString());
        }
        catch (PermissionDeniedException permissionDeniedException) {
            this.m_logger.severe("No sufficient permissions for reading schema " + string2);
            throw new BulkStoreException(permissionDeniedException.toString());
        }
        catch (UserDoesNotExistException userDoesNotExistException) {
            this.m_logger.severe("Bulkstore uses unknown user " + user);
            throw new BulkStoreException(userDoesNotExistException.toString());
        }
        catch (ModuleCriticalException moduleCriticalException) {
            this.m_logger.severe("Severe problems in initializing BulkStoreImpl (while retrieving internal IF) " + moduleCriticalException.toString());
            throw new BulkStoreException(moduleCriticalException.getCause().toString());
        }
        catch (ArchiveException archiveException) {
            this.m_logger.severe("Severe problems in initializing BulkStoreImpl (while retrieving internal IF) " + archiveException.toString());
            throw new BulkStoreException(archiveException.toString());
        }
        MultipleInputStream multipleInputStream = null;
        try {
            multipleInputStream = new MultipleInputStream(inputStream);
        }
        catch (IOException iOException) {
            throw new BulkStoreException(iOException.getCause().toString());
        }
        InputStream inputStream2 = multipleInputStream.getParasiteInputStream();
        this.parseMime(string, uRI, string2, multipleInputStream);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("OUTPUT");
            int n2 = inputStream2.read();
            while (n2 != -1) {
                fileOutputStream.write(n2);
                n2 = inputStream2.read();
            }
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("======================================================================================AFTER");
    }

    public static void main(String[] stringArray) throws Exception {
        BulkStoreImpl bulkStoreImpl = new BulkStoreImpl();
        bulkStoreImpl.standalone = true;
        bulkStoreImpl.init();
        bulkStoreImpl.storeStream("uid://ab/ab/ab", stringArray[0], Integer.parseInt(stringArray[1]), new FileInputStream(stringArray[2]));
    }

    public void storeFromFile(String string, String string2, String string3) throws BulkStoreException {
        File file = new File(string2);
        int n = (int)file.length();
        Pattern pattern = DatabaseHelper.basicUidPattern;
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new BulkStoreException("Invalid UID: " + string);
        }
        if (this.storeInNgas) {
            FileInputStream fileInputStream;
            this.m_logger.info("Handling storeFromFile request of " + string + " to NGAS: " + string2);
            String string4 = string.substring(6);
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new BulkStoreException("File Not Found: " + string2);
            }
            Status status = this.ngasJClient.archiveStream((InputStream)fileInputStream, string3, string4);
            if (!status.getOK()) {
                this.m_logger.severe("Error when sending data to NGAS: " + status.getMessage() + "\nData " + string + " not stored!");
                this.m_logger.info("Configuration used: server: " + this.server + ", port: " + this.port);
                throw new BulkStoreException("Error when sending file " + string + " to NGAS: " + status.getMessage());
            }
            this.m_logger.info("Succesfully sent file " + string + " to NGAS");
        } else {
            this.m_logger.info("Storing incoming stream in local file system under " + this.uid2filename(string));
            String string5 = "cp " + string2 + " " + this.uid2filename(string);
            this.m_logger.finer("Executing command: " + string5);
            try {
                Process process = Runtime.getRuntime().exec(string5);
                if (process.waitFor() != 0) {
                    this.m_logger.warning("Could not store file in NGAS.");
                    throw new BulkStoreException("Could not store file in NGAS.");
                }
            }
            catch (Exception exception) {
                throw new BulkStoreException(exception.toString());
            }
        }
        this.m_logger.info("Stored dataset with UID " + string);
    }

    public void retrieveToFile(String string, String string2) throws BulkStoreException {
        if (new File(string2).isDirectory()) {
            string2 = string2 + "/" + string.replace('/', '_');
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            if (this.storeInNgas) {
                this.m_logger.info("Retrieving file " + string + " from NGAS to disk location: " + string2);
                Status status = this.ngasJClient.retrieveStream(string.substring(6), (OutputStream)fileOutputStream);
                fileOutputStream.close();
                if (!status.getOK()) {
                    this.m_logger.warning("NGAS returned to retrieve message: " + status.getRequestStatus());
                    this.m_logger.warning(status.getMessage());
                    throw new BulkStoreException(status.getMessage());
                }
            } else {
                this.m_logger.info("Retrieving file " + this.uid2filename(string) + " from disk and writing to disk location: " + string2);
                String string3 = "cp " + this.uid2filename(string) + " " + string2;
                this.m_logger.finer("Executing command: " + string3);
                Process process = Runtime.getRuntime().exec(string3);
                if (process.waitFor() != 0) {
                    this.m_logger.warning("Could not retrieve file from disk.");
                    throw new BulkStoreException("Unable to retrieve file from disk.");
                }
            }
        }
        catch (Exception exception) {
            throw new BulkStoreException(exception.toString());
        }
    }

    public void store(String string, int n, byte[] byArray) throws BulkStoreException {
        this.storeData(string, this.m_schema, n, byArray);
    }

    public void storeData(String string, String string2, int n, byte[] byArray) throws BulkStoreException {
        URI uRI;
        try {
            uRI = this.m_operArchiveComp.getSchemaManager(user).getSchemaURI(string2);
        }
        catch (DatabaseException databaseException) {
            this.m_logger.severe("Could not retrieve UID for schema " + string2);
            throw new BulkStoreException(databaseException.toString());
        }
        catch (UnknownSchemaException unknownSchemaException) {
            this.m_logger.severe("Could not find bulkstore schema " + string2);
            throw new BulkStoreException(unknownSchemaException.toString());
        }
        catch (PermissionDeniedException permissionDeniedException) {
            this.m_logger.severe("No sufficient permissions for reading schema " + string2);
            throw new BulkStoreException(permissionDeniedException.toString());
        }
        catch (UserDoesNotExistException userDoesNotExistException) {
            this.m_logger.severe("Bulkstore uses unknown user " + user);
            throw new BulkStoreException(userDoesNotExistException.toString());
        }
        catch (ModuleCriticalException moduleCriticalException) {
            this.m_logger.severe("Severe problems in Archive (while retrieving internal IF/reading schema) " + moduleCriticalException.toString());
            throw new BulkStoreException(moduleCriticalException.getCause().toString());
        }
        catch (ArchiveException archiveException) {
            this.m_logger.severe("Severe problems in Archive (while retrieving internal IF/reading schema) " + archiveException.toString());
            throw new BulkStoreException(archiveException.toString());
        }
        byte[] byArray2 = ("<" + string2).getBytes();
        byte[] byArray3 = ("</" + string2 + ">").getBytes();
        int n2 = this.findOccurrence(byArray, byArray2);
        int n3 = this.findOccurrence(byArray, byArray3) + byArray3.length;
        if (n2 < 0 || n3 < 0) {
            this.m_logger.severe("Could not find XML header " + string2 + " in MIME document " + string + ". Data not stored!");
            try {
                this.bulkNotifyChannel.publishEvent((IDLEntity)new BulkDataStoreNotificationEvent(new ArchiveTimeStamp().toISOString(), string, resultType.FAILURE_INVALID_FORMAT));
            }
            catch (AcsJException acsJException) {
                this.m_logger.warning("Could not publish on NC bulkstore.");
            }
            throw new BulkStoreException("Could not find XML header " + string2 + " in MIME document " + string);
        }
        String string3 = new String(byArray, n2, n3 - n2);
        try {
            if (!this.initPhase) {
                this.m_operArchiveComp.store(new URI(string), string3, uRI, string2, owner, new Permissions(), user, true);
            }
        }
        catch (DatabaseException databaseException) {
            this.m_logger.severe("Problem in Archive: " + databaseException.toString() + "\nData " + string + " not stored!");
            try {
                this.bulkNotifyChannel.publishEvent((IDLEntity)new BulkDataStoreNotificationEvent(new ArchiveTimeStamp().toISOString(), string, resultType.FAILURE_XMLSTORE));
            }
            catch (AcsJException acsJException) {
                this.m_logger.warning("Could not publish on NC bulkstore.");
            }
            throw new BulkStoreException(databaseException.toString());
        }
        catch (ArchiveException archiveException) {
            this.m_logger.severe("Problem in Archive: " + archiveException.toString() + "\nData " + string + " not stored!");
            try {
                this.bulkNotifyChannel.publishEvent((IDLEntity)new BulkDataStoreNotificationEvent(new ArchiveTimeStamp().toISOString(), string, resultType.FAILURE_XMLSTORE));
            }
            catch (AcsJException acsJException) {
                this.m_logger.warning("Could not publish on NC bulkstore.");
            }
            throw new BulkStoreException(archiveException.toString());
        }
        catch (ModuleCriticalException moduleCriticalException) {
            this.m_logger.severe("Severe problem in Archive: " + moduleCriticalException.getCause().toString() + "\nData " + string + " not stored!");
            try {
                this.bulkNotifyChannel.publishEvent((IDLEntity)new BulkDataStoreNotificationEvent(new ArchiveTimeStamp().toISOString(), string, resultType.FAILURE_XMLSTORE));
            }
            catch (AcsJException acsJException) {
                this.m_logger.warning("Could not publish on NC bulkstore.");
            }
            throw new BulkStoreException(moduleCriticalException.getCause().toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            this.m_logger.warning("Invalid URI, please check: " + string + "\nData " + string + " not stored!");
            try {
                this.bulkNotifyChannel.publishEvent((IDLEntity)new BulkDataStoreNotificationEvent(new ArchiveTimeStamp().toISOString(), string, resultType.FAILURE_WRONG_UID));
            }
            catch (AcsJException acsJException) {
                this.m_logger.warning("Could not publish on NC bulkstore.");
            }
            throw new BulkStoreException(uRISyntaxException.toString());
        }
        if (this.storeInNgas) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            String string4 = string.substring(6);
            Status status = this.ngasJClient.archiveStream((InputStream)byteArrayInputStream, this.contentType, string4);
            if (!status.getOK()) {
                this.m_logger.severe("Error when sending data to NGAS: " + status.getMessage() + "\nData " + string + " not stored!");
                this.m_logger.info("Configuration used: server: " + this.server + ", port: " + this.port);
                try {
                    this.bulkNotifyChannel.publishEvent((IDLEntity)new BulkDataStoreNotificationEvent(new ArchiveTimeStamp().toISOString(), string, resultType.FAILURE_NGAS));
                }
                catch (AcsJException acsJException) {
                    this.m_logger.warning("Could not publish on NC bulkstore.");
                }
                throw new BulkStoreException("Error when sending file " + string + " to NGAS: " + status.getMessage());
            }
            this.m_logger.info("Succesfully sent file " + string + " to NGAS");
            try {
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {
                try {
                    this.bulkNotifyChannel.publishEvent((IDLEntity)new BulkDataStoreNotificationEvent(new ArchiveTimeStamp().toISOString(), string, resultType.FAILURE_NGAS));
                }
                catch (AcsJException acsJException) {
                    this.m_logger.warning("Could not publish on NC bulkstore.");
                }
                throw new BulkStoreException("Unable to close incoming data stream: " + iOException.toString() + "\nCheck data " + string + " in NGAS!");
            }
        }
        String string5 = string.replace('/', '_');
        this.m_logger.info("Storing incoming stream in local file system under " + this.testDir + "/" + string5);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.testDir + "/" + string5);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            this.m_logger.warning("Could not write to file: " + this.testDir + "/" + string5);
            this.m_logger.severe("Data " + string + " not stored!");
            this.m_logger.warning(iOException.toString());
            try {
                this.bulkNotifyChannel.publishEvent((IDLEntity)new BulkDataStoreNotificationEvent(new ArchiveTimeStamp().toISOString(), string, resultType.FAILURE_DISK));
            }
            catch (AcsJException acsJException) {
                this.m_logger.warning("Could not publish on NC bulkstore.");
            }
            throw new BulkStoreException(iOException.toString());
        }
        this.m_logger.info("Stored dataset with UID " + string);
        try {
            this.bulkNotifyChannel.publishEvent((IDLEntity)new BulkDataStoreNotificationEvent(new ArchiveTimeStamp().toISOString(), string, resultType.SUCCESS));
        }
        catch (AcsJException acsJException) {
            this.m_logger.warning("Could not publish on NC bulkstore.");
        }
    }

    private int findOccurrence(byte[] byArray, byte[] byArray2) {
        int n;
        int n2 = 0;
        boolean bl = false;
        for (n = 0; !bl && n < byArray.length; ++n) {
            if (byArray[n] == byArray2[n2]) {
                if (n2 == byArray2.length - 1) {
                    bl = true;
                    break;
                }
                ++n2;
                continue;
            }
            n -= n2;
            n2 = 0;
        }
        if (n == byArray.length) {
            n = -1;
        }
        return n - n2;
    }

    public byte[] retrieve(String string) throws BulkStoreException {
        byte[] byArray;
        try {
            if (this.storeInNgas) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Status status = this.ngasJClient.retrieveStream(string.substring(6), (OutputStream)byteArrayOutputStream);
                if (!status.getOK()) {
                    this.m_logger.warning(status.getRequestStatus());
                    this.m_logger.fine(status.getMessage());
                    throw new BulkStoreException("NGAS or file unavailable, message: " + status.getMessage());
                }
                byArray = byteArrayOutputStream.toByteArray();
            } else {
                FileInputStream fileInputStream = new FileInputStream(this.uid2filename(string));
                this.m_logger.finest("Retrieving file: " + this.uid2filename(string));
                byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
            }
        }
        catch (Exception exception) {
            throw new BulkStoreException(exception.toString());
        }
        return byArray;
    }

    protected String uid2filename(String string) {
        String string2 = this.config.get("archive.ngast.testDir");
        return (string2 == null ? this.testDir : string2) + "/" + string.replace('/', '_');
    }

    class ThreadedMimeParser
    extends MimeParser
    implements Runnable {
        InputStream input;
        BulkStoreContentHandler handler;

        @Override
        public void run() {
            this.setContentHandler(this.handler);
            try {
                this.parse(this.input);
            }
            catch (IOException iOException) {
                BulkStoreImpl.this.m_logger.severe("Problen in parsing incoming MIME message: " + iOException.getCause().toString());
            }
        }

        public ThreadedMimeParser(InputStream inputStream, BulkStoreContentHandler bulkStoreContentHandler) {
            this.input = inputStream;
            this.handler = bulkStoreContentHandler;
        }
    }

    public class MultipleInputStream
    extends InputStream {
        InputStream input;
        PipedOutputStream buffer;
        PipedInputStream parasiteOut;
        int count = 0;

        public MultipleInputStream(InputStream inputStream) throws IOException {
            this.input = inputStream;
            this.buffer = new PipedOutputStream();
            this.parasiteOut = new PipedInputStream(this.buffer);
        }

        @Override
        public int available() throws IOException {
            return this.input.available();
        }

        @Override
        public int read() throws IOException {
            int n = this.input.read();
            if (n == -1) {
                System.out.println("CLOSING");
                this.buffer.close();
            } else {
                this.buffer.write(n);
            }
            return n;
        }

        public InputStream getParasiteInputStream() {
            return this.parasiteOut;
        }

        public int bufferAvailable() throws IOException {
            return 0;
        }

        public int bufferRead() throws IOException {
            return 0;
        }
    }

    private class BulkStoreContentHandler
    implements ContentHandler {
        private String uid = null;
        URI schemaUid;
        String schemaName;

        public BulkStoreContentHandler(URI uRI, String string) {
            this.schemaUid = uRI;
            this.schemaName = string;
        }

        public void body(BodyHeader bodyHeader, InputStream inputStream) throws IOException {
            if (this.uid != null) {
                System.out.println("UID FOUND: " + this.uid);
            }
            System.out.println("TYPE: " + bodyHeader.getContentType().getType());
            System.out.println("SUBTYPE: " + bodyHeader.getContentType().getSubType());
            System.out.println("DISP: " + bodyHeader.getContentDisposition());
            if (this.uid != null && bodyHeader.getContentType().getType().equals("text") && bodyHeader.getContentType().getSubType().equals("xml")) {
                String string = IOUtil.toString((InputStream)inputStream, (String)"US-ASCII");
                System.out.println("STORING with " + this.uid + ": " + string);
                try {
                    BulkStoreImpl.this.m_operArchiveComp.store(new URI(this.uid), string, this.schemaUid, this.schemaName, owner, new Permissions(), user, true);
                }
                catch (DatabaseException databaseException) {
                    throw new IOException(databaseException);
                }
                catch (MalformedURIException malformedURIException) {
                    throw new IOException(malformedURIException);
                }
                catch (MalformedXMLException malformedXMLException) {
                    throw new IOException(malformedXMLException);
                }
                catch (EntityExistsException entityExistsException) {
                    throw new IOException(entityExistsException);
                }
                catch (UnknownSchemaException unknownSchemaException) {
                    throw new IOException(unknownSchemaException);
                }
                catch (UserDoesNotExistException userDoesNotExistException) {
                    throw new IOException(userDoesNotExistException);
                }
                catch (MalformedPermissionsException malformedPermissionsException) {
                    throw new IOException(malformedPermissionsException);
                }
                catch (ModuleCriticalException moduleCriticalException) {
                    throw new IOException(moduleCriticalException);
                }
                catch (ArchiveException archiveException) {
                    throw new IOException(archiveException);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IOException(uRISyntaxException);
                }
            } else {
                System.out.println("IGNORING:");
            }
            inputStream.skip(inputStream.available());
            this.uid = null;
        }

        public void endBodyPart() {
        }

        public void endHeader() {
        }

        public void endMessage() {
        }

        public void endMultipart() {
        }

        public void epilogue(InputStream inputStream) throws IOException {
            inputStream.skip(inputStream.available());
        }

        public void preamble(InputStream inputStream) throws IOException {
            inputStream.skip(inputStream.available());
        }

        public void field(String string) {
            if (string.startsWith("alma-uid: ")) {
                this.uid = string.substring(10);
            }
        }

        public void startBodyPart() {
        }

        public void startHeader() {
        }

        public void startMessage() {
        }

        public void startMultipart(BodyHeader bodyHeader) {
            if (this.uid != null) {
                System.out.println("UID FOUND: " + this.uid);
            }
            System.out.println("TYPE: " + bodyHeader.getContentType().getType());
            System.out.println("SUBTYPE: " + bodyHeader.getContentType().getSubType());
            System.out.println("DISP: " + bodyHeader.getContentDisposition());
            this.uid = null;
        }
    }
}

