/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.AWTError;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.plaf.InternalFrameUI;
import org.netbeans.core.windows.frames.DesktopFrameTypeImpl;
import org.netbeans.core.windows.frames.FrameType;
import org.netbeans.core.windows.frames.InternalFrameTypeImpl;
import org.netbeans.core.windows.frames.LayoutResourceManager;
import org.netbeans.core.windows.frames.NbInternalFrameUI;
import org.netbeans.core.windows.frames.PerimeterLayout;

public class PerimeterPane
extends JComponent
implements Accessible,
LayoutResourceManager {
    private PerimeterLayout layout = new PerimeterLayout();
    private Map components = new HashMap(5);
    private PerimeterGapListener pgl = new PerimeterGapListener();
    private AWTListener listener = new AWTListener();
    private boolean drag;
    private Rectangle horiz;
    private Rectangle vert;
    private Point newLoc;
    private int deltaX;
    private int deltaY;
    private int orientation;
    private static Border containerBorder = null;
    private static boolean noContainerBorder = false;

    public PerimeterPane() {
        Color c;
        this.setLayout(this.layout);
        Border b = UIManager.getBorder("nb.PerimiterPane.border");
        if (b != null) {
            this.setBorder(b);
        }
        if ((c = UIManager.getColor("nb.PerimeterPane.background")) != null) {
            this.setBackground(c);
            this.setOpaque(true);
        }
        PerimeterGapListener pgl = new PerimeterGapListener();
        this.addMouseMotionListener(pgl);
        this.addMouseListener(pgl);
        Toolkit.getDefaultToolkit().addAWTEventListener(this.listener, 32L);
    }

    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private void setDragging(boolean drag) {
        this.drag = drag;
        if (!drag) {
            this.horiz = null;
            this.vert = null;
            this.newLoc = null;
            this.deltaX = 0;
            this.deltaY = 0;
            this.orientation = 0;
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.drag) {
            Rectangle h = this.horiz;
            Rectangle v = this.vert;
            Point newPoint = this.newLoc;
            if (!this.getBounds().contains(newPoint)) {
                return;
            }
            Color old = g.getColor();
            g.setColor(Color.darkGray);
            if (h != null && newPoint != null) {
                h.setLocation(h.x, newPoint.y + this.deltaY);
                if (this.orientation == 3) {
                    h.setBounds(h.x, h.y, newPoint.x + this.deltaX - h.x, h.height);
                } else if (this.orientation == 4) {
                    h.setBounds(newPoint.x + this.deltaX, h.y, h.width - (newPoint.x + this.deltaX - h.x), h.height);
                }
                g.fillRect(h.x, h.y, h.width, h.height);
            }
            if (v != null && newPoint != null) {
                v.setLocation(newPoint.x + this.deltaX, v.y);
                if (this.orientation == 1) {
                    v.setBounds(v.x, v.y, v.width, newPoint.y + this.deltaY - v.y);
                } else if (this.orientation == 2) {
                    v.setBounds(v.x, newPoint.y + this.deltaY, v.width, v.height - (newPoint.y + this.deltaY - v.y));
                }
                g.fillRect(v.x, v.y, v.width, v.height);
            }
            g.setColor(old);
        }
    }

    public void destroy() {
        this.removeMouseMotionListener(this.pgl);
        this.removeMouseListener(this.pgl);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.listener);
    }

    private static final Border getContainerBorder() {
        if (noContainerBorder) {
            return null;
        }
        if (containerBorder == null) {
            UIDefaults defs = UIManager.getDefaults();
            Color highlight = defs.getColor("controlHighlight");
            Color shadow = defs.getColor("controlShadow");
            Border outer = defs.getBorder("nb.splitChildBorder");
            if (outer instanceof EtchedBorder) {
                outer = BorderFactory.createEtchedBorder(((EtchedBorder)outer).getEtchType(), highlight, shadow);
            }
            if (outer != null) {
                Insets ins = UIManager.getInsets("nb.SplitChildInsets");
                if (ins == null) {
                    ins = new Insets(0, 0, 0, 0);
                }
                Border inner = BorderFactory.createEmptyBorder(ins.top, ins.left, ins.bottom, ins.right);
                containerBorder = BorderFactory.createCompoundBorder(outer, inner);
            } else {
                return BorderFactory.createEtchedBorder(1);
            }
        }
        return containerBorder;
    }

    private static final void installBorder(JComponent jc, Border b) {
        if (jc.getClientProperty("ManagesBorder") != null) {
            return;
        }
        Border orig = jc.getBorder();
        jc.putClientProperty("OrigBorder", orig);
        jc.setBorder(b);
    }

    private static final void restoreBorder(JComponent jc) {
        if (jc.getClientProperty("ManagesBorder") != null) {
            return;
        }
        Border orig = (Border)jc.getClientProperty("OrigBorder");
        jc.putClientProperty("OrigBorder", null);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        if (UIManager.get("nb.useBorderPolicy") != null) {
            JComponent jc;
            if (comp instanceof JComponent && (jc = (JComponent)comp).getClientProperty("ManagesBorder") == null) {
                if (jc instanceof FrameType) {
                    if (jc instanceof DesktopFrameTypeImpl) {
                        PerimeterPane.installBorder(jc, new TopOnlyEtchedBorder());
                    } else if (jc instanceof InternalFrameTypeImpl && ((InternalFrameTypeImpl)jc).isMaximum()) {
                        PerimeterPane.installBorder(jc, BorderFactory.createEmptyBorder());
                    }
                } else {
                    Border b = PerimeterPane.getContainerBorder();
                    PerimeterPane.installBorder(jc, b);
                }
            }
        } else if (comp instanceof JComponent) {
            ((JComponent)comp).setBorder(BorderFactory.createEtchedBorder(1));
        }
        this.components.put(constraints, comp);
    }

    public void remove(Component comp) {
        super.remove(comp);
        if (comp != null && comp instanceof JComponent && !(comp instanceof FrameType)) {
            PerimeterPane.restoreBorder((JComponent)comp);
        }
        if (this.components != null && comp != null) {
            Iterator it = this.components.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!comp.equals(entry.getValue())) continue;
                it.remove();
            }
        }
    }

    public void setLayout(LayoutManager mgr) {
        if (!(mgr instanceof PerimeterLayout)) {
            throw new AWTError("PerimeterPanel can only use PerimeterLayout");
        }
        super.setLayout(mgr);
    }

    public Component getComponentAt(String side) {
        return (Component)this.components.get(side);
    }

    public void moveToFront(Component comp) {
        this.layout.setDominant(comp);
        comp.requestFocus();
    }

    public void moveToFront(String sideName) {
        Component comp = (Component)this.components.get(sideName);
        if (comp != null) {
            comp.requestFocus();
        }
        this.layout.setDominant(sideName);
    }

    public void setDominant(Component comp) {
        this.layout.setDominant(comp);
        this.revalidate();
    }

    public void setDominant(String sideName) {
        this.layout.setDominant(sideName);
        this.revalidate();
    }

    public void relayout(int width, int height) {
        this.layout.relayout(width, height);
    }

    public static class TopOnlyEtchedBorder
    extends EtchedBorder {
        static int titleheight = -1;

        public TopOnlyEtchedBorder() {
            super(1, UIManager.getColor("controlHighlight"), UIManager.getColor("controlShadow"));
        }

        private final void calcTitleHeight(Component c) {
            FontMetrics fm = c.getFontMetrics(c.getFont());
            InternalFrameUI ui = ((JInternalFrame)c).getUI();
            titleheight = ui instanceof NbInternalFrameUI ? ((NbInternalFrameUI)ui).getTitlePane().getHeight() : Math.max(fm.getHeight(), 16) + 7;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (titleheight == -1) {
                this.calcTitleHeight(c);
            }
            int w = width - 2;
            int h = titleheight + 3;
            g.translate(x, y);
            g.setColor(this.etchType == 1 ? this.getShadowColor(c) : this.getHighlightColor(c));
            g.drawLine(0, 0, w - 2, 0);
            g.drawLine(0, 0, 0, h - 2);
            g.drawLine(w - 2, 0, w - 2, h - 2);
            g.setColor(this.etchType == 1 ? this.getHighlightColor(c) : this.getShadowColor(c));
            g.drawLine(1, h - 3, 1, 1);
            g.drawLine(1, 1, w - 3, 1);
            g.drawLine(w - 1, h - 1, w - 1, 0);
            g.translate(-x, -y);
        }
    }

    private class PerimeterGapListener
    extends MouseAdapter
    implements MouseMotionListener {
        private static final int CHANGE = 3;
        private static final int NORTHSIDE = 0;
        private static final int SOUTHSIDE = 1;
        private static final int EASTSIDE = 2;
        private static final int WESTSIDE = 3;
        private static final int MIDDLE = 4;
        private int[] outcodes = new int[5];
        private PerimeterPane pPane = PerimeterPane.this;
        private boolean resizing = false;
        private boolean dragging = false;
        private Point mouseLocation;
        int oldCursorType = this.pPane.getCursor().getType();
        private Rectangle horizontal;
        private Rectangle vertical;
        boolean sizingCursorSet = false;

        public void mousePressed(MouseEvent me) {
            if ((me.getModifiers() & 0x10) != 0) {
                this.mouseLocation = me.getPoint();
                Point point = this.mouseLocation;
                if (this.pPane.getComponentAt(point) != this.pPane) {
                    return;
                }
                Component top = (Component)this.pPane.components.get("NORTH");
                Component bottom = (Component)this.pPane.components.get("SOUTH");
                Component center = (Component)this.pPane.components.get("CENTER");
                Component left = (Component)this.pPane.components.get("WEST");
                Component right = (Component)this.pPane.components.get("EAST");
                if (top != null && center != null) {
                    this.tryToSetHorizontal(top, center, point.y);
                }
                if (this.horizontal == null && center != null && bottom != null) {
                    this.tryToSetHorizontal(center, bottom, point.y);
                }
                if (this.horizontal == null && top != null && left != null && center == null) {
                    this.tryToSetHorizontal(top, left, point.y);
                }
                if (this.horizontal == null && top != null && right != null && center == null) {
                    this.tryToSetHorizontal(top, right, point.y);
                }
                if (this.horizontal == null && left != null && bottom != null && center == null) {
                    this.tryToSetHorizontal(left, bottom, point.y);
                }
                if (this.horizontal == null && right != null && bottom != null && center == null) {
                    this.tryToSetHorizontal(right, bottom, point.y);
                }
                if (!(this.horizontal != null || top == null || bottom == null || center != null || left != null && left.getBounds().x >= top.getBounds().x && left.getBounds().x >= bottom.getBounds().x || right != null && top.getBounds().x + top.getBounds().width >= right.getBounds().x + right.getBounds().width && bottom.getBounds().x + bottom.getBounds().width >= right.getBounds().x + right.getBounds().width)) {
                    this.tryToSetHorizontal(top, bottom, point.y);
                }
                if (left != null && center != null) {
                    this.tryToSetVertical(left, center, point.x);
                }
                if (this.vertical == null && center != null && right != null) {
                    this.tryToSetVertical(center, right, point.x);
                }
                if (this.vertical == null && left != null && top != null && center == null) {
                    this.tryToSetVertical(left, top, point.x);
                }
                if (this.vertical == null && left != null && bottom != null && center == null) {
                    this.tryToSetVertical(left, bottom, point.x);
                }
                if (this.vertical == null && top != null && right != null && center == null) {
                    this.tryToSetVertical(top, right, point.x);
                }
                if (this.vertical == null && bottom != null && right != null && center == null) {
                    this.tryToSetVertical(bottom, right, point.x);
                }
                if (!(this.vertical != null || left == null || right == null || center != null || top != null && top.getBounds().y >= left.getBounds().y && top.getBounds().y >= right.getBounds().y || bottom != null && left.getBounds().y + left.getBounds().height >= top.getBounds().y + top.getBounds().height && right.getBounds().y + right.getBounds().height >= bottom.getBounds().y + bottom.getBounds().height)) {
                    this.tryToSetVertical(left, right, point.x);
                }
                if (this.horizontal == null && this.vertical == null) {
                    this.resizing = false;
                    return;
                }
                this.resizing = true;
                this.pPane.horiz = this.horizontal;
                this.pPane.vert = this.vertical;
                if (this.vertical != null) {
                    this.pPane.deltaX = point.x - this.vertical.x;
                }
                if (this.horizontal != null) {
                    this.pPane.deltaY = point.y - this.horizontal.y;
                }
                this.pPane.newLoc = point;
                if (this.horizontal != null && this.vertical != null) {
                    if (!this.vertical.contains(point.x, point.y + (this.horizontal.height + 1))) {
                        this.pPane.orientation = 1;
                    } else if (!this.vertical.contains(point.x, point.y - (this.horizontal.height + 1))) {
                        this.pPane.orientation = 2;
                    } else if (!this.horizontal.contains(point.x + (this.vertical.width + 1), point.y)) {
                        this.pPane.orientation = 3;
                    } else if (!this.horizontal.contains(point.x - (this.vertical.width + 1), point.y)) {
                        this.pPane.orientation = 4;
                    }
                }
            }
        }

        private void tryToSetHorizontal(Component top, Component bottom, int y) {
            if (top.getBounds().y + top.getBounds().height <= y && bottom.getBounds().y >= y) {
                this.horizontal = this.getHorizontalSplitRect(top.getBounds(), bottom.getBounds());
            }
        }

        private void tryToSetVertical(Component left, Component right, int x) {
            if (left.getBounds().x + left.getBounds().width <= x && right.getBounds().x >= x) {
                this.vertical = this.getVerticalSplitRect(left.getBounds(), right.getBounds());
            }
        }

        private Rectangle getHorizontalSplitRect(Rectangle top, Rectangle bottom) {
            return new Rectangle(Math.min(top.x, bottom.x), top.y + top.height, Math.max(top.width, bottom.width), bottom.y - (top.y + top.height));
        }

        private Rectangle getVerticalSplitRect(Rectangle left, Rectangle right) {
            return new Rectangle(left.x + left.width, Math.min(left.y, right.y), right.x - (left.x + left.width), Math.max(left.height, right.height));
        }

        public void mouseReleased(MouseEvent me) {
            this.resizing = false;
            this.horizontal = null;
            this.vertical = null;
            this.pPane.setDragging(false);
            this.dragging = false;
            Point newLoc = me.getPoint();
            Rectangle rect = this.pPane.getBounds();
            rect.setLocation(0, 0);
            if (rect.contains(newLoc)) {
                this.updateComponents(newLoc);
            }
            this.setBothCursors(null);
            this.pPane.repaint();
        }

        public void mouseDragged(MouseEvent me) {
            if (this.resizing) {
                this.pPane.setDragging(true);
                this.dragging = true;
                Point newLoc = me.getPoint();
                if (this.oldCursorType == this.pPane.getCursor().getType() && this.sizingCursorSet) {
                    int newCursorType = this.getCursorType(this.outcodes[4]);
                    this.setBothCursors(Cursor.getPredefinedCursor(newCursorType));
                }
                if (newLoc.distance(this.mouseLocation) > 3.0) {
                    this.pPane.newLoc = newLoc;
                    Rectangle h = PerimeterPane.this.horiz;
                    Rectangle v = PerimeterPane.this.vert;
                    Point newPoint = newLoc;
                    if (PerimeterPane.this.getBounds().contains(newPoint)) {
                        if (h != null && newPoint != null) {
                            Rectangle hh = (Rectangle)h.clone();
                            hh.setLocation(hh.x, newPoint.y + PerimeterPane.this.deltaY);
                            if (PerimeterPane.this.orientation == 3) {
                                hh.setBounds(hh.x, hh.y, newPoint.x + PerimeterPane.this.deltaX - hh.x, h.height);
                            } else if (PerimeterPane.this.orientation == 4) {
                                hh.setBounds(newPoint.x + PerimeterPane.this.deltaX, hh.y, hh.width - (newPoint.x + PerimeterPane.this.deltaX - h.x), hh.height);
                            }
                            h = h.union(hh);
                        }
                        if (v != null && newPoint != null) {
                            Rectangle vv = (Rectangle)v.clone();
                            vv.setLocation(newPoint.x + PerimeterPane.this.deltaX, vv.y);
                            if (PerimeterPane.this.orientation == 1) {
                                vv.setBounds(vv.x, vv.y, vv.width, newPoint.y + PerimeterPane.this.deltaY - vv.y);
                            } else if (PerimeterPane.this.orientation == 2) {
                                vv.setBounds(vv.x, newPoint.y + PerimeterPane.this.deltaY, vv.width, vv.height - (newPoint.y + PerimeterPane.this.deltaY - vv.y));
                            }
                            v = v.union(vv);
                        }
                    }
                    if (h != null) {
                        this.pPane.repaint(h);
                    }
                    if (v != null) {
                        this.pPane.repaint(v);
                    }
                    this.mouseLocation = newLoc;
                }
            }
        }

        private void updateComponents(Point newLoc) {
            Rectangle rect;
            Component comp;
            Map comps = this.pPane.components;
            Rectangle pRect = this.pPane.getBounds();
            if (this.outcodes[0] == 8 && (comp = (Component)comps.get("NORTH")) != null) {
                rect = comp.getBounds();
                rect.height = newLoc.y;
                comp.setBounds(rect);
            }
            if (this.outcodes[1] == 2 && (comp = (Component)comps.get("SOUTH")) != null) {
                rect = comp.getBounds();
                rect.height = pRect.height - newLoc.y - PerimeterPane.this.layout.getGap();
                comp.setBounds(rect);
            }
            if (this.outcodes[2] == 1 && (comp = (Component)comps.get("EAST")) != null) {
                rect = comp.getBounds();
                rect.width = pRect.width - newLoc.x - PerimeterPane.this.layout.getGap();
                rect.x = newLoc.x;
                comp.setBounds(rect);
            }
            if (this.outcodes[3] == 4 && (comp = (Component)comps.get("WEST")) != null) {
                rect = comp.getBounds();
                rect.width = newLoc.x;
                comp.setBounds(rect);
            }
            this.pPane.revalidate();
        }

        public void mouseMoved(MouseEvent me) {
            Component comp = this.pPane.getComponentAt(me.getPoint());
            this.updateOutcodes(me.getPoint());
            int newCursorType = this.getCursorType(this.outcodes[4]);
            if (comp == this.pPane) {
                if (!this.sizingCursorSet) {
                    this.oldCursorType = this.pPane.getCursor().getType();
                    this.sizingCursorSet = true;
                }
                this.setBothCursors(Cursor.getPredefinedCursor(newCursorType));
            } else if (this.sizingCursorSet) {
                this.setBothCursors(null);
                this.sizingCursorSet = false;
            }
        }

        public void mouseExited(MouseEvent evt) {
            if (!this.dragging) {
                this.setBothCursors(null);
            }
        }

        private void setBothCursors(Cursor cursor) {
            this.pPane.setCursor(cursor);
            JRootPane rootPane = this.pPane.getRootPane();
            if (rootPane != null) {
                Component glass = rootPane.getGlassPane();
                glass.setCursor(cursor);
            }
        }

        private void updateOutcodes(Point newLoc) {
            Component comp = (Component)this.pPane.components.get("NORTH");
            this.outcodes[0] = comp != null ? this.getOutcode(comp, newLoc) & 8 : 0;
            comp = (Component)this.pPane.components.get("SOUTH");
            this.outcodes[1] = comp != null ? this.getOutcode(comp, newLoc) & 2 : 0;
            comp = (Component)this.pPane.components.get("EAST");
            this.outcodes[2] = comp != null ? this.getOutcode(comp, newLoc) & 1 : 0;
            comp = (Component)this.pPane.components.get("WEST");
            this.outcodes[3] = comp != null ? this.getOutcode(comp, newLoc) & 4 : 0;
            this.outcodes[4] = this.outcodes[0] | this.outcodes[1] | this.outcodes[2] | this.outcodes[3];
        }

        private int getOutcode(Component comp, Point newLoc) {
            Rectangle compRect = comp.getBounds();
            int gap = PerimeterPane.this.layout.getGap();
            compRect.setLocation(compRect.x - gap, compRect.y - gap);
            compRect.grow(gap * 2, gap * 2);
            int outcode = compRect.contains(newLoc) ? comp.getBounds().outcode(newLoc) : 0;
            return outcode;
        }

        private int getCursorType(int outcode) {
            switch (outcode) {
                case 2: {
                    return 9;
                }
                case 8: {
                    return 8;
                }
                case 1: {
                    return 11;
                }
                case 4: {
                    return 10;
                }
                case 3: {
                    return 5;
                }
                case 12: {
                    return 6;
                }
                case 6: {
                    return 4;
                }
                case 9: {
                    return 7;
                }
                case 7: 
                case 11: 
                case 13: 
                case 14: 
                case 15: {
                    return 13;
                }
            }
            return this.pPane.getCursor().getType();
        }
    }

    private class AWTListener
    implements AWTEventListener {
        static /* synthetic */ Class class$javax$swing$JPanel;

        AWTListener() {
        }

        public void eventDispatched(AWTEvent evt) {
            MouseEvent mEvt = (MouseEvent)evt;
            if (PerimeterPane.this.contains(mEvt.getPoint()) && (class$javax$swing$JPanel == null ? (class$javax$swing$JPanel = AWTListener.class$("javax.swing.JPanel")) : class$javax$swing$JPanel).equals(mEvt.getComponent().getClass())) {
                PerimeterPane.this.dispatchEvent(new MouseEvent(PerimeterPane.this, mEvt.getID(), mEvt.getWhen(), mEvt.getModifiers(), mEvt.getX(), mEvt.getY(), mEvt.getClickCount(), mEvt.isPopupTrigger()));
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

