/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.DefaultFocusManager;
import javax.swing.FocusManager;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.Keymap;
import org.netbeans.core.windows.MainWindow;
import org.openide.actions.ActionManager;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public final class NbFocusManager
extends DefaultFocusManager {
    private static boolean shortcutAndMenuKeyEventProcessorInstalled = false;
    private Set pendingEvents = new HashSet();
    static /* synthetic */ Class class$org$netbeans$core$windows$frames$NbFocusManager;
    static /* synthetic */ Class class$javax$swing$text$Keymap;
    static /* synthetic */ Class class$org$openide$actions$ActionManager;

    private NbFocusManager() {
    }

    public static synchronized void install() {
        if (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) < 0) {
            FocusManager fm = FocusManager.getCurrentManager();
            if (fm == null || fm.getClass() != (class$org$netbeans$core$windows$frames$NbFocusManager == null ? (class$org$netbeans$core$windows$frames$NbFocusManager = NbFocusManager.class$("org.netbeans.core.windows.frames.NbFocusManager")) : class$org$netbeans$core$windows$frames$NbFocusManager)) {
                FocusManager.setCurrentManager(new NbFocusManager());
            }
        } else if (!shortcutAndMenuKeyEventProcessorInstalled) {
            shortcutAndMenuKeyEventProcessorInstalled = true;
            try {
                Class.forName("org.netbeans.core.windows.frames.ShortcutAndMenuKeyEventProcessor").newInstance();
            }
            catch (InstantiationException ex) {
            }
            catch (IllegalAccessException ex) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public void processKeyEvent(Component focusedComponent, KeyEvent anEvent) {
        if (anEvent.getID() == 401 && anEvent.getModifiers() == 3 && (anEvent.getKeyCode() == 19 || anEvent.getKeyCode() == 3)) {
            Window w = SwingUtilities.windowForComponent(focusedComponent);
            Component focused = SwingUtilities.findFocusOwner(w);
            System.err.println("*** NbFocusManager: current focus owner = " + focused);
            anEvent.consume();
            return;
        }
        super.processKeyEvent(focusedComponent, anEvent);
        if (anEvent.isConsumed()) {
            return;
        }
        KeyStroke key = KeyStroke.getKeyStrokeForEvent(anEvent);
        MenuSelectionManager selManager = MenuSelectionManager.defaultManager();
        MenuElement[] elems = selManager.getSelectedPath();
        if (elems != null && elems.length > 0 && !(elems[0].getComponent() instanceof ComboPopup) && anEvent.getID() == 401 && anEvent.getModifiers() == 0 && anEvent.getKeyCode() == 27) {
            selManager.clearSelectedPath();
            anEvent.consume();
            return;
        }
        if (!NbFocusManager.isTransmodalAction(key)) {
            Window w = SwingUtilities.windowForComponent(focusedComponent);
            if (w instanceof Dialog) {
                Dialog d = (Dialog)w;
                if (elems == null || elems.length == 0) {
                    return;
                }
            }
        } else {
            ActionEvent aev = new ActionEvent(key, 1001, Utilities.keyToString((KeyStroke)key));
            if (NbFocusManager.processKeyStroke(key, aev)) {
                anEvent.consume();
                return;
            }
        }
        final KeyEvent ev = anEvent;
        final Component comp = focusedComponent;
        if (this.pendingEvents.contains(ev)) {
            return;
        }
        this.pendingEvents.add(ev);
        Window w = SwingUtilities.windowForComponent(ev.getComponent());
        MainWindow mw = MainWindow.getDefault();
        if (!(elems == null || elems.length <= 0 || mw == w && elems[0] instanceof JMenuBar)) {
            if (!(elems[0].getComponent() instanceof ComboPopup)) {
                int i = elems.length;
                while (--i >= 0 && !ev.isConsumed()) {
                    Component compo = elems[i].getComponent();
                    compo.dispatchEvent(ev);
                    if (ev.isConsumed()) break;
                }
                ev.consume();
            }
            this.pendingEvents.remove(ev);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!ev.isConsumed()) {
                    NbFocusManager.this.processEvent(ev, comp);
                }
                NbFocusManager.this.pendingEvents.remove(ev);
            }
        });
    }

    private void processEvent(KeyEvent ev, Component comp) {
        ActionEvent aev;
        KeyStroke key = KeyStroke.getKeyStrokeForEvent(ev);
        if (NbFocusManager.processKeyStroke(key, aev = new ActionEvent(ev, 1001, Utilities.keyToString((KeyStroke)key)))) {
            ev.consume();
        } else {
            Window w = SwingUtilities.windowForComponent(ev.getComponent());
            MainWindow mw = MainWindow.getDefault();
            if (mw == w) {
                return;
            }
            JMenuBar menubar = mw.getJMenuBar();
            if (menubar == null) {
                return;
            }
            menubar.dispatchEvent(ev);
            ev.consume();
        }
    }

    static boolean processKeyStroke(KeyStroke key, ActionEvent ev) {
        Keymap root = (Keymap)Lookup.getDefault().lookup(class$javax$swing$text$Keymap == null ? (class$javax$swing$text$Keymap = NbFocusManager.class$("javax.swing.text.Keymap")) : class$javax$swing$text$Keymap);
        Action a = root.getAction(key);
        if (a != null && a.isEnabled()) {
            ActionManager am = (ActionManager)Lookup.getDefault().lookup(class$org$openide$actions$ActionManager == null ? (class$org$openide$actions$ActionManager = NbFocusManager.class$("org.openide.actions.ActionManager")) : class$org$openide$actions$ActionManager);
            am.invokeAction(a, ev);
            return true;
        }
        return false;
    }

    private static boolean isTransmodalAction(KeyStroke key) {
        Keymap root = (Keymap)Lookup.getDefault().lookup(class$javax$swing$text$Keymap == null ? (class$javax$swing$text$Keymap = NbFocusManager.class$("javax.swing.text.Keymap")) : class$javax$swing$text$Keymap);
        Action a = root.getAction(key);
        if (a == null) {
            return false;
        }
        Object val = a.getValue("OpenIDE-Transmodal-Action");
        return val != null && val.equals(Boolean.TRUE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

