/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.netbeans.core.NbPlaces;
import org.netbeans.core.awt.TabControl;
import org.netbeans.core.windows.KeyFocuseWorkspace;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.awt.JPopupMenuPlus;
import org.openide.awt.MouseUtils;
import org.openide.nodes.NodeOperation;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class WorkspaceSwitcher {
    private WindowManagerImpl pool;
    static TabControl control;
    private static WorkspaceSwitcher workspaceSwitcher;
    private ArrayList workspaces;
    private HashMap listeners;
    private KeyFocuseWorkspace FocuseListen;
    boolean changeCurrentAllowed = true;
    int index;
    Workspace workspace;
    private static final int MOUSE_ADAPTOR = 0;
    private static final int IN_OUT_WORKSPACES = 1;
    private static final int EVENTS_ON_CONTROL = 2;
    private static final int ADD_NEW_WORKSPACES = 3;
    private static final int SWITCH_TO_WORKSPACE = 4;
    private static final int DELETE_WORKSPACE = 5;
    private static final int CUSTOMIZE_WORKSPACE = 6;
    static /* synthetic */ Class class$org$netbeans$core$windows$WorkspaceSwitcher;
    static /* synthetic */ Class class$org$netbeans$core$windows$WindowManagerImpl;

    public WorkspaceSwitcher(WindowManager wpool) {
        int ind;
        this.pool = (WindowManagerImpl)wpool;
        control = new TabControl();
        control.putClientProperty("Toolbar", "Fixed");
        HelpCtx.setHelpIDString((JComponent)control, (String)(class$org$netbeans$core$windows$WorkspaceSwitcher == null ? (class$org$netbeans$core$windows$WorkspaceSwitcher = WorkspaceSwitcher.class$("org.netbeans.core.windows.WorkspaceSwitcher")) : class$org$netbeans$core$windows$WorkspaceSwitcher).getName());
        this.workspaces = new ArrayList(5);
        this.listeners = new HashMap(7);
        control.setDirection(false);
        this.addNew(this.pool.getWorkspaces());
        Workspace cur = this.pool.getCurrentWorkspace();
        if (this.pool.getWorkspacesNoLoad() != null && (ind = this.workspaces.indexOf(cur)) >= 0) {
            control.setSelectedIndex(ind);
        }
        this.FocuseListen = new KeyFocuseWorkspace();
        control.addKeyListener(this.FocuseListen);
        this.pool.addPropertyChangeListener(new PoolListener(1));
        PoolListener pcl2 = new PoolListener(2);
        control.addIndexChangeListener(pcl2);
        PoolListener mouseL = new PoolListener(0);
        control.addMouseListener((MouseListener)((Object)mouseL));
    }

    private void propChange(PropertyChangeEvent che) {
        int i;
        if (che.getPropertyName().equals("workspaces")) {
            Workspace[] newDesks = (Workspace[])che.getNewValue();
            this.changeCurrentAllowed = false;
            this.removeOld();
            this.addNew(newDesks);
            i = this.workspaces.indexOf(this.pool.getCurrentWorkspace());
            if (i >= 0) {
                control.setSelectedIndex(i);
            }
            control.revalidate();
            this.changeCurrentAllowed = true;
        }
        if (che.getPropertyName().equals("currentWorkspace")) {
            Workspace newDesk = (Workspace)che.getNewValue();
            i = this.workspaces.indexOf(newDesk);
            if (i < 0) {
                this.addNew(new Workspace[]{newDesk});
                control.revalidate();
                return;
            }
            control.setSelectedIndex(i);
            control.repaint();
        }
    }

    void showPopup(int x, int y) {
        JPopupMenuPlus m = new JPopupMenuPlus();
        this.index = control.pointToIndex(x);
        this.workspace = WindowManager.getDefault().getWorkspaces()[this.index];
        String workspaceName = Actions.cutAmpersand((String)this.workspace.getDisplayName());
        boolean current = this.index == control.getSelectedIndex();
        JMenuItem mi = new JMenuItem(WorkspaceSwitcher.getMainString("CTL_SwitchToWorkspace", workspaceName));
        HelpCtx.setHelpIDString((JComponent)mi, (String)(class$org$netbeans$core$windows$WorkspaceSwitcher == null ? (class$org$netbeans$core$windows$WorkspaceSwitcher = WorkspaceSwitcher.class$("org.netbeans.core.windows.WorkspaceSwitcher")) : class$org$netbeans$core$windows$WorkspaceSwitcher).getName());
        mi.addActionListener(new PoolListener(4));
        mi.setEnabled(!current);
        m.add(mi);
        m.addSeparator();
        mi = new JMenuItem(WorkspaceSwitcher.getMainString("CTL_DeleteWorkspace", workspaceName));
        HelpCtx.setHelpIDString((JComponent)mi, (String)(class$org$netbeans$core$windows$WorkspaceSwitcher == null ? (class$org$netbeans$core$windows$WorkspaceSwitcher = WorkspaceSwitcher.class$("org.netbeans.core.windows.WorkspaceSwitcher")) : class$org$netbeans$core$windows$WorkspaceSwitcher).getName());
        mi.addActionListener(new PoolListener(5));
        mi.setEnabled(!current);
        m.add(mi);
        m.addSeparator();
        mi = new JMenuItem(WorkspaceSwitcher.getMainString("CTL_CustomizeWorkspaces"));
        HelpCtx.setHelpIDString((JComponent)mi, (String)(class$org$netbeans$core$windows$WorkspaceSwitcher == null ? (class$org$netbeans$core$windows$WorkspaceSwitcher = WorkspaceSwitcher.class$("org.netbeans.core.windows.WorkspaceSwitcher")) : class$org$netbeans$core$windows$WorkspaceSwitcher).getName());
        mi.addActionListener(new PoolListener(6));
        m.add(mi);
        m.show(control, x, y);
    }

    protected void addNew(Workspace[] newWorkspaces) {
        if (newWorkspaces == null) {
            return;
        }
        String name = null;
        PoolListener l = null;
        int i = 0;
        while (i < newWorkspaces.length) {
            name = Actions.cutAmpersand((String)newWorkspaces[i].getDisplayName());
            control.addTab(name);
            this.workspaces.add(newWorkspaces[i]);
            l = new PoolListener(3);
            newWorkspaces[i].addPropertyChangeListener((PropertyChangeListener)l);
            this.listeners.put(newWorkspaces[i], l);
            ++i;
        }
    }

    protected void removeOld() {
        Workspace[] toRemove = this.workspaces.toArray(new Workspace[0]);
        PropertyChangeListener l = null;
        int i = 0;
        while (i < toRemove.length) {
            l = (PropertyChangeListener)this.listeners.remove(toRemove[i]);
            if (l != null) {
                toRemove[i].removePropertyChangeListener(l);
            }
            ++i;
        }
        this.workspaces.clear();
        control.removeAllTabs();
    }

    public Component getComponent() {
        return control;
    }

    public static synchronized TabControl getDefault() {
        return control;
    }

    public static Component createSwitcher() {
        return WorkspaceSwitcher.getInstance().getComponent();
    }

    public static synchronized WorkspaceSwitcher getInstance() {
        if (workspaceSwitcher == null) {
            workspaceSwitcher = new WorkspaceSwitcher(WindowManager.getDefault());
        }
        return workspaceSwitcher;
    }

    public static String stripAmpersand(String text) {
        int i = text.indexOf(38);
        return i < 0 ? text : text.substring(0, i) + text.substring(i + 1);
    }

    private static String getMainString(String resName) {
        return NbBundle.getMessage((Class)(class$org$netbeans$core$windows$WindowManagerImpl == null ? (class$org$netbeans$core$windows$WindowManagerImpl = WorkspaceSwitcher.class$("org.netbeans.core.windows.WindowManagerImpl")) : class$org$netbeans$core$windows$WindowManagerImpl), (String)resName);
    }

    private static String getMainString(String resName, Object arg) {
        return NbBundle.getMessage((Class)(class$org$netbeans$core$windows$WindowManagerImpl == null ? (class$org$netbeans$core$windows$WindowManagerImpl = WorkspaceSwitcher.class$("org.netbeans.core.windows.WindowManagerImpl")) : class$org$netbeans$core$windows$WindowManagerImpl), (String)resName, (Object)arg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    final class PoolListener
    extends MouseUtils.PopupMouseAdapter
    implements ActionListener,
    PropertyChangeListener {
        private int id;
        static /* synthetic */ Class class$org$netbeans$core$windows$WorkspaceSwitcher;
        static /* synthetic */ Class class$org$openide$nodes$NodeOperation;

        public PoolListener(int id) {
            this.id = id;
        }

        public void propertyChange(PropertyChangeEvent che) {
            switch (this.id) {
                case 1: {
                    if (EventQueue.isDispatchThread()) {
                        WorkspaceSwitcher.this.propChange(che);
                        break;
                    }
                    EventQueue.invokeLater(new Runnable(this, che){
                        private final /* synthetic */ PropertyChangeEvent val$che;
                        private final /* synthetic */ PoolListener this$1;
                        {
                            this.this$1 = this$1;
                            this.val$che = val$che;
                        }

                        public void run() {
                            WorkspaceSwitcher.access$000(PoolListener.access$100(this.this$1), this.val$che);
                        }
                    });
                    break;
                }
                case 2: {
                    if (!WorkspaceSwitcher.this.changeCurrentAllowed) break;
                    int i = control.getSelectedIndex();
                    if (i < 0 || i >= WorkspaceSwitcher.this.workspaces.size()) {
                        return;
                    }
                    ((Workspace)WorkspaceSwitcher.this.workspaces.get(i)).activate();
                    break;
                }
                case 3: {
                    if (!che.getPropertyName().equals("displayName")) break;
                    Workspace source = (Workspace)che.getSource();
                    int y = WorkspaceSwitcher.this.workspaces.indexOf(source);
                    if (y < 0) {
                        return;
                    }
                    control.replaceTabAt(Actions.cutAmpersand((String)source.getDisplayName()), y);
                    control.revalidate();
                }
            }
        }

        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            int anyModifier = e.getModifiers() & 0xF;
            if (anyModifier != 0) {
                e.consume();
            }
        }

        public void actionPerformed(ActionEvent ev) {
            switch (this.id) {
                case 4: {
                    control.setSelectedIndex(WorkspaceSwitcher.this.index);
                    break;
                }
                case 5: {
                    NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)(class$org$netbeans$core$windows$WorkspaceSwitcher == null ? (class$org$netbeans$core$windows$WorkspaceSwitcher = PoolListener.class$("org.netbeans.core.windows.WorkspaceSwitcher")) : class$org$netbeans$core$windows$WorkspaceSwitcher), (String)"MSG_ConfirmDeleteObject", (Object)Actions.cutAmpersand((String)WorkspaceSwitcher.this.workspace.getDisplayName())), NbBundle.getMessage((Class)(class$org$netbeans$core$windows$WorkspaceSwitcher == null ? (class$org$netbeans$core$windows$WorkspaceSwitcher = PoolListener.class$("org.netbeans.core.windows.WorkspaceSwitcher")) : class$org$netbeans$core$windows$WorkspaceSwitcher), (String)"MSG_ConfirmDeleteObjectTitle"), 0);
                    if (!NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)desc))) break;
                    WorkspaceSwitcher.this.workspace.remove();
                    break;
                }
                case 6: {
                    NodeOperation no = (NodeOperation)Lookup.getDefault().lookup(class$org$openide$nodes$NodeOperation == null ? (class$org$openide$nodes$NodeOperation = PoolListener.class$("org.openide.nodes.NodeOperation")) : class$org$openide$nodes$NodeOperation);
                    no.explore(NbPlaces.getDefault().workspaces());
                }
            }
        }

        protected void showPopup(MouseEvent ev) {
            WorkspaceSwitcher.this.showPopup(ev.getX(), ev.getY());
        }

        static /* synthetic */ WorkspaceSwitcher access$100(PoolListener x0) {
            return x0.WorkspaceSwitcher.this;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

