/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Iterator;
import org.netbeans.core.windows.MainWindow;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.frames.PerimeterLayout;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

class WorkspaceBoundsManager {
    public static final int DEFAULT_MODE_WIDTH = 500;
    public static final int DEFAULT_MODE_HEIGHT = 350;
    private static Rectangle lastMainBounds;
    private WorkspaceImpl workspace;
    private Dimension cascadeStep;
    private int cascadeStepsCount;
    private Point cascadePoint;
    private Point cascadingOrigin;

    WorkspaceBoundsManager(WorkspaceImpl workspace) {
        this.workspace = workspace;
    }

    public void copyFrom(WorkspaceBoundsManager other) {
        this.cascadeStep = new Dimension(other.getCascadeStep());
        this.cascadeStepsCount = other.getCascadeStepsCount();
        Point helper = other.getCascadePoint();
        this.cascadePoint = helper == null ? null : new Point(helper);
    }

    public Point getCascadingOrigin() {
        if (this.cascadingOrigin == null) {
            this.cascadingOrigin = new Point(0, 0);
        }
        return this.cascadingOrigin;
    }

    public void setCascadingOrigin(Point cascadingOrigin) {
        this.cascadingOrigin = cascadingOrigin;
        this.recomputeCascadePoint();
    }

    public Dimension getCascadeStep() {
        if (this.cascadeStep == null) {
            this.cascadeStep = new Dimension(20, 20);
        }
        return this.cascadeStep;
    }

    public void setCascadeStep(Dimension cascadeStep) {
        this.cascadeStep = cascadeStep;
    }

    public int getCascadeStepsCount() {
        return this.cascadeStepsCount;
    }

    public void setCascadeStepsCount(int cascadeStepsCount) {
        this.cascadeStepsCount = cascadeStepsCount;
    }

    public Point getCascadePoint() {
        MainWindow mainWindow = MainWindow.getDefault();
        Rectangle mainBounds = mainWindow.getBounds();
        if (lastMainBounds == null) {
            lastMainBounds = mainBounds;
        }
        if (this.cascadeStepsCount <= 0 || WindowUtils.isMdi()) {
            this.cascadePoint = null;
        }
        if (this.cascadePoint == null || !lastMainBounds.equals(mainBounds) || mainBounds.width == 0 && mainBounds.height == 0) {
            this.recomputeCascadePoint();
            lastMainBounds = mainBounds;
        }
        return this.cascadePoint;
    }

    void setCascadePoint(Point cascadePoint) {
        this.cascadePoint = cascadePoint;
    }

    public void correctBounds() {
        Dimension currentScreen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension oldScreen = WindowManagerImpl.getInstance().getOldScreenSize();
        if (oldScreen == null || currentScreen.equals(oldScreen)) {
            return;
        }
        Iterator iter = this.workspace.getModeList().iterator();
        while (iter.hasNext()) {
            ModeImpl curMode = (ModeImpl)iter.next();
            Rectangle modeRect = curMode.getBounds();
            if (modeRect == null) continue;
            Rectangle newBounds = new Rectangle(modeRect);
            WindowUtils.convertRectangle(newBounds, oldScreen, currentScreen);
            if (!WindowUtils.isMdi()) {
                this.removeMainWindowOverlapping(newBounds);
            }
            curMode.setBounds(newBounds);
        }
    }

    public Rectangle getWorkingSpaceBounds() {
        MainWindow mainWindow = MainWindow.getDefault();
        Rectangle mainBounds = mainWindow.getBounds();
        if (WindowUtils.isMdi()) {
            Dimension desktopSize = mainWindow.getDesktopSize();
            if (desktopSize.width != 0 && desktopSize.height != 0) {
                return new Rectangle(0, 0, desktopSize.width, desktopSize.height);
            }
        }
        mainBounds.height = mainWindow.getPreferredSize().height;
        Rectangle workingSpace = null;
        Rectangle screenBounds = Utilities.getUsableScreenBounds();
        workingSpace = mainBounds.y < screenBounds.y + screenBounds.height / 2 ? new Rectangle(screenBounds.x, mainBounds.y + mainBounds.height, screenBounds.width, screenBounds.y + screenBounds.height - (mainBounds.y + mainBounds.height)) : new Rectangle(screenBounds);
        return workingSpace;
    }

    public void placeMode(ModeImpl mode, TopComponent tc) {
        if (mode.isBoundsSet()) {
            return;
        }
        Rectangle modeBounds = new Rectangle();
        Point cascadePoint = this.getCascadePoint();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        modeBounds.x = cascadePoint.x;
        modeBounds.y = cascadePoint.y;
        Dimension d = tc.getPreferredSize();
        if (d == null || d.width == 0 && d.height == 0) {
            modeBounds.width = Math.min(500, screenSize.width - modeBounds.x);
            modeBounds.height = Math.min(350, screenSize.height - modeBounds.y);
        } else {
            Dimension availSpace = "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(mode.getFrameType()) ? this.workspace.desktopPane().getComponentAt("CENTER").getSize() : screenSize;
            modeBounds.width = Math.min(d.width, availSpace.width - modeBounds.x);
            modeBounds.height = Math.min(d.height, availSpace.height - modeBounds.y);
        }
        Dimension cascadeStep = this.getCascadeStep();
        ++this.cascadeStepsCount;
        mode.setBounds(modeBounds);
    }

    public Point getDesktopScreenLocation() {
        ModeImpl northMode;
        Point loc = MainWindow.getDefault().getDesktopScreenLocation();
        ModeImpl westMode = WindowUtils.findConstrainedMode(this.workspace, "WEST", true);
        int draggerWidth = ((PerimeterLayout)this.workspace.desktopPane().getLayout()).getGap();
        if (westMode != null) {
            loc.x += westMode.getBounds().width + draggerWidth;
        }
        if ((northMode = WindowUtils.findConstrainedMode(this.workspace, "NORTH", true)) != null) {
            loc.y += northMode.getBounds().height + draggerWidth;
        }
        return loc;
    }

    private void removeMainWindowOverlapping(Rectangle rect) {
        Rectangle mainBounds = WindowManagerImpl.getInstance().getOldMainWindowBounds();
        if (rect.y > mainBounds.y && rect.y < mainBounds.y + mainBounds.height) {
            rect.y = mainBounds.y + mainBounds.height;
        }
    }

    private void recomputeCascadePoint() {
        Rectangle workingSpace = this.getWorkingSpaceBounds();
        Point cascadingOrigin = this.getCascadingOrigin();
        Dimension cascadeStep = this.getCascadeStep();
        if (this.cascadeStepsCount * cascadeStep.width > workingSpace.width / 2 || this.cascadeStepsCount * cascadeStep.height > workingSpace.height / 2) {
            this.cascadeStepsCount = 0;
        }
        this.cascadePoint = new Point(workingSpace.x + cascadingOrigin.x * workingSpace.width / 100 + this.cascadeStepsCount * cascadeStep.width, workingSpace.y + cascadingOrigin.y * workingSpace.height / 100 + this.cascadeStepsCount * cascadeStep.height);
    }
}

