/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Component;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.netbeans.core.IDESettings;
import org.netbeans.core.windows.DeferredPerformer;
import org.netbeans.core.windows.MainWindow;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceManager;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.frames.WindowTypesManager;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class UIModeManager
implements PropertyChangeListener {
    public static final int SDI_MODE = 1;
    public static final int MDI_MODE = 2;
    public static final int DIALOG_SDI_MODE = 4;
    private Map uiModes2Frames;
    private Map names2Modes;
    private IDESettings ideSettings;
    private boolean inProgress;
    private static UIModeManager defaultInstance;
    private int mdiHeight;
    static /* synthetic */ Class class$org$netbeans$core$IDESettings;
    static /* synthetic */ Class class$org$netbeans$core$windows$UIModeManager;

    private UIModeManager() {
    }

    public static synchronized UIModeManager getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new UIModeManager();
        }
        return defaultInstance;
    }

    public void setUIMode(int uiMode) {
        this.setUIMode(uiMode, true, true);
    }

    public void setUIMode(int uiMode, boolean update) {
        this.setUIMode(uiMode, update, true);
    }

    public void setUIMode(int uiMode, boolean update, boolean alterTypes) {
        int oldMode = this.getUIMode();
        if (oldMode == uiMode) {
            return;
        }
        MainWindow mainWindow = MainWindow.getDefault();
        if (uiMode != 2 && mainWindow.isShowing()) {
            this.mdiHeight = mainWindow.getBounds().height;
        }
        this.inProgress = true;
        this.ideSettings.setUIMode(uiMode);
        WindowTypesManager.setDefaultFrame((String)this.uiModes2Frames().get(new Integer(uiMode)));
        if (update) {
            this.updateAll(alterTypes);
        } else if (alterTypes) {
            this.changeModeFrameTypes();
        }
        DeferredPerformer.getDefault().putRequest(new DeferredPerformer.DeferredCommand(){

            public void performCommand(DeferredPerformer.DeferredContext dc) {
                try {
                    PersistenceManager.getDefault().writeXML();
                }
                catch (IOException exc) {
                    ErrorManager em = ErrorManager.getDefault();
                    em.notify(1, (Throwable)exc);
                }
            }
        }, new DeferredPerformer.DeferredContext(null, true));
        this.logModeChange(oldMode, uiMode);
        this.inProgress = false;
    }

    private void logModeChange(int oldMode, int newMode) {
        String loggedText = newMode == 2 ? "Switching from multiple views (SDI) to full screen (MDI) UI mode." : "Switching from full screen (MDI) to multiple views (SDI) UI mode.";
        UIModeManager.winsysErrorMan().log(65536, loggedText);
    }

    private void logStartMode(int uiMode) {
        String loggedText = uiMode == 2 ? "Starting system in full screen (MDI) UI mode." : "Starting system in multiple views (SDI) UI mode.";
        UIModeManager.winsysErrorMan().log(65536, loggedText);
    }

    private static ErrorManager winsysErrorMan() {
        return ErrorManager.getDefault();
    }

    public int getUIMode() {
        if (this.ideSettings == null) {
            this.ideSettings = (IDESettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = UIModeManager.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true);
            String uiModeSysProp = System.getProperty("netbeans.windows");
            if ("mdi".equalsIgnoreCase(uiModeSysProp)) {
                this.setUIMode(2);
                WindowTypesManager.setDefaultFrame((String)this.uiModes2Frames().get(new Integer(2)));
            } else if ("sdi".equalsIgnoreCase(uiModeSysProp)) {
                this.setUIMode(1);
                WindowTypesManager.setDefaultFrame((String)this.uiModes2Frames().get(new Integer(1)));
            } else {
                int uiMode = this.ideSettings.getUIMode();
                WindowTypesManager.setDefaultFrame((String)this.uiModes2Frames().get(new Integer(uiMode)));
                this.logStartMode(uiMode);
            }
            this.ideSettings.addPropertyChangeListener(this);
        }
        return this.ideSettings.getUIMode();
    }

    public void updateAll() {
        this.updateAll(true);
    }

    public void changeModeFrameTypes() {
        WindowManagerImpl wm = (WindowManagerImpl)WindowManager.getDefault();
        Workspace[] workspaces = wm.getWorkspacesNoLoad();
        if (workspaces == null) {
            return;
        }
        List modes = null;
        ModeImpl curMode = null;
        int i = 0;
        while (i < workspaces.length) {
            modes = ((WorkspaceImpl)workspaces[i]).getLoadedModeList();
            int j = 0;
            while (j < modes.size()) {
                curMode = (ModeImpl)modes.get(j);
                curMode.setFrameType(this.findFrameType(curMode));
                ++j;
            }
            ++i;
        }
    }

    public final Map getModeNames() {
        if (this.names2Modes == null) {
            this.names2Modes = new HashMap(10);
            this.names2Modes.put(NbBundle.getMessage((Class)(class$org$netbeans$core$windows$UIModeManager == null ? (class$org$netbeans$core$windows$UIModeManager = UIModeManager.class$("org.netbeans.core.windows.UIModeManager")) : class$org$netbeans$core$windows$UIModeManager), (String)"CTL_SdiMode"), new Integer(1));
            this.names2Modes.put(NbBundle.getMessage((Class)(class$org$netbeans$core$windows$UIModeManager == null ? (class$org$netbeans$core$windows$UIModeManager = UIModeManager.class$("org.netbeans.core.windows.UIModeManager")) : class$org$netbeans$core$windows$UIModeManager), (String)"CTL_MdiMode"), new Integer(2));
        }
        return this.names2Modes;
    }

    String findFrameType(ModeImpl mode) {
        int curMode = this.getUIMode();
        Object constraint = mode.getConstraints();
        String result = WindowUtils.convertFrameType(curMode, constraint);
        return result;
    }

    private void updateAll(boolean alterTypes) {
        WindowManagerImpl wm = (WindowManagerImpl)WindowManager.getDefault();
        WorkspaceImpl curWorkspace = (WorkspaceImpl)wm.getCurrentWorkspace();
        if (curWorkspace == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.uiModeUpdater(curWorkspace, alterTypes).run();
        } else {
            SwingUtilities.invokeLater(this.uiModeUpdater(curWorkspace, alterTypes));
        }
    }

    public Runnable uiModeUpdater(final WorkspaceImpl curWorkspace, final boolean alterTypes) {
        return new Runnable(){

            public void run() {
                MainWindow mainWindow = MainWindow.getDefault();
                int oldWidth = mainWindow.getBounds().width;
                curWorkspace.setVisible(false);
                curWorkspace.setTopMaximizedMode(null);
                if (alterTypes) {
                    UIModeManager.this.changeModeFrameTypes();
                }
                mainWindow.pack();
                Rectangle bounds = mainWindow.getBounds();
                ((Component)mainWindow).setBounds(new Rectangle(bounds.x, bounds.y, oldWidth, UIModeManager.this.getUIMode() == 2 && UIModeManager.this.mdiHeight > 0 ? UIModeManager.this.mdiHeight : bounds.height));
                curWorkspace.setVisible(true);
            }
        };
    }

    private Map uiModes2Frames() {
        if (this.uiModes2Frames == null) {
            this.uiModes2Frames = new HashMap(10);
            this.uiModes2Frames.put(new Integer(1), "org.netbeans.core.windows.frames.TopFrameTypeImpl");
            this.uiModes2Frames.put(new Integer(2), "org.netbeans.core.windows.frames.TopFrameTypeImpl");
        }
        return this.uiModes2Frames;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ((propName == null || "UIMode".equals(propName)) && !this.inProgress) {
            WindowTypesManager.setDefaultFrame((String)this.uiModes2Frames().get(new Integer(this.getUIMode())));
            this.updateAll();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

