/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.WeakHashMap;
import org.netbeans.core.projects.SessionManager;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.WeakListener;

final class FileStateManager {
    public static final int LAYER_PROJECT = 0;
    public static final int LAYER_SESSION = 1;
    public static final int LAYER_MODULES = 2;
    public static final int FSTATE_DEFINED = 0;
    public static final int FSTATE_IGNORED = 1;
    public static final int FSTATE_INHERITED = 2;
    public static final int FSTATE_UNDEFINED = 3;
    private static FileStateManager manager = null;
    private WeakHashMap info = new WeakHashMap();
    private static final int LAYERS_COUNT = 3;
    private FileSystem[] layers = new FileSystem[3];
    private HashMap listeners = new HashMap(10);
    private PropertyChangeListener propL = null;

    public static synchronized FileStateManager getDefault() {
        if (manager == null) {
            manager = new FileStateManager();
        }
        return manager;
    }

    private FileStateManager() {
        this.getLayers();
        this.propL = new PropL();
        SessionManager.getDefault().addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.propL, (Object)SessionManager.getDefault()));
    }

    public void define(final FileObject mfo, int layer, boolean revert) throws IOException {
        if (0 == this.getFileState(mfo, layer)) {
            return;
        }
        FileSystem fsLayer = this.getLayer(layer);
        if (fsLayer == null) {
            throw new IllegalArgumentException("Invalid layer " + layer);
        }
        FileObject fo = fsLayer.findResource(mfo.getPath());
        if (fo != null && !revert) {
            this.deleteImpl(mfo, fsLayer);
            fo = null;
        }
        if (fo == null) {
            String parent = mfo.getParent().getPath();
            final FileObject fparent = FileUtil.createFolder((FileObject)fsLayer.getRoot(), (String)parent);
            fparent.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    mfo.copy(fparent, mfo.getName(), mfo.getExt());
                }
            });
        }
        int i = 0;
        while (i < layer) {
            FileSystem fsl = this.getLayer(i);
            if (fsl != null) {
                this.deleteImpl(mfo, fsl);
            }
            ++i;
        }
    }

    public void delete(FileObject mfo, int layer) throws IOException {
        FileSystem fsLayer = this.getLayer(layer);
        if (fsLayer == null) {
            throw new IllegalArgumentException("Invalid layer " + layer);
        }
        this.deleteImpl(mfo, fsLayer);
    }

    public int getFileState(FileObject mfo, int layer) {
        FileSystem fs = null;
        FileInfo finf = null;
        try {
            fs = mfo.getFileSystem();
        }
        catch (FileStateInvalidException e) {
            // empty catch block
        }
        if (fs == null || !Repository.getDefault().getDefaultFileSystem().equals(fs)) {
            throw new IllegalArgumentException("FileObject has to be from DefaultFileSystem - " + mfo);
        }
        WeakHashMap weakHashMap = this.info;
        synchronized (weakHashMap) {
            finf = (FileInfo)((Object)this.info.get(mfo));
            if (null == finf) {
                finf = new FileInfo(mfo);
                this.info.put(mfo, finf);
            }
        }
        return finf.getState(layer);
    }

    public final void addFileStatusListener(FileStatusListener l, FileObject mfo) {
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            LinkedList lst = null;
            if (!this.listeners.containsKey(l)) {
                lst = new LinkedList();
                this.listeners.put(l, lst);
            } else {
                lst = (LinkedList)this.listeners.get(l);
            }
            if (!lst.contains(mfo)) {
                lst.add(mfo);
            }
        }
    }

    public final void removeFileStatusListener(FileStatusListener l, FileObject mfo) {
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            if (mfo == null) {
                this.listeners.remove(l);
            } else {
                LinkedList lst = (LinkedList)this.listeners.get(l);
                if (lst != null) {
                    lst.remove(mfo);
                    if (lst.isEmpty()) {
                        this.listeners.remove(l);
                    }
                }
            }
        }
    }

    private void fireFileStatusChanged(FileObject mfo) {
        HashMap h = null;
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            h = (HashMap)this.listeners.clone();
        }
        Iterator i = h.keySet().iterator();
        while (i.hasNext()) {
            FileStatusListener l = (FileStatusListener)i.next();
            LinkedList lst = (LinkedList)h.get(l);
            if (!lst.contains(mfo)) continue;
            l.fileStatusChanged(mfo);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deleteImpl(FileObject mfo, FileSystem fsLayer) throws IOException {
        FileObject fo = fsLayer.findResource(mfo.getPath());
        if (fo == null) return;
        FileLock lock = null;
        try {
            lock = fo.lock();
            fo.delete(lock);
            Object var6_5 = null;
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (lock == null) throw throwable;
            lock.releaseLock();
            throw throwable;
        }
        lock.releaseLock();
    }

    private void discard(FileObject mfo) {
        WeakHashMap weakHashMap = this.info;
        synchronized (weakHashMap) {
            this.info.remove(mfo);
        }
    }

    private void getLayers() {
        this.layers[0] = SessionManager.getDefault().getLayer("project");
        this.layers[1] = SessionManager.getDefault().getLayer("session");
        this.layers[2] = SessionManager.getDefault().getLayer("install");
    }

    private FileSystem getLayer(int layer) {
        return this.layers[layer];
    }

    private class FileInfo
    extends FileChangeAdapter {
        private WeakReference file = null;
        private int[] state = new int[3];
        private final Object LOCK = new Object();
        private FileObject[] notifiers = new FileObject[3];
        private FileChangeListener[] weakL = new FileChangeListener[3];

        public FileInfo(FileObject mfo) {
            this.file = new WeakReference<FileObject>(mfo);
            int i = 0;
            while (i < 3) {
                this.state[i] = this.getStateImpl(mfo, i);
                ++i;
            }
            int i2 = 0;
            while (i2 < 3) {
                this.attachNotifier(mfo, i2);
                ++i2;
            }
        }

        public void invalidate() {
            this.detachAllNotifiers();
            Object object = this.LOCK;
            synchronized (object) {
                int i = 0;
                while (i < 3) {
                    this.state[i] = 3;
                    ++i;
                }
            }
        }

        public int getState(int layer) {
            Object object = this.LOCK;
            synchronized (object) {
                int n = this.state[layer];
                return n;
            }
        }

        private void rescan(FileObject mfo) {
            boolean changed = false;
            Object object = this.LOCK;
            synchronized (object) {
                int i = 0;
                while (i < 3) {
                    int ns = this.getStateImpl(mfo, i);
                    if (this.state[i] != ns) {
                        this.state[i] = ns;
                        changed = true;
                    }
                    ++i;
                }
            }
            if (changed) {
                FileStateManager.this.fireFileStatusChanged(mfo);
            }
        }

        private int getStateImpl(FileObject mfo, int layer) {
            boolean above = false;
            boolean below = false;
            int i = 0;
            while (i < layer) {
                if (this.isOnLayer(mfo, i)) {
                    above = true;
                    break;
                }
                ++i;
            }
            int i2 = layer + 1;
            while (i2 < 3) {
                if (this.isOnLayer(mfo, i2)) {
                    below = true;
                    break;
                }
                ++i2;
            }
            if (this.isOnLayer(mfo, layer)) {
                return above ? 1 : 0;
            }
            return below && !above ? 2 : 3;
        }

        private boolean isOnLayer(FileObject mfo, int layer) {
            FileSystem fsLayer = FileStateManager.this.getLayer(layer);
            return fsLayer == null ? false : null != fsLayer.findResource(mfo.getPath());
        }

        /*
         * Unable to fully structure code
         */
        private synchronized boolean attachNotifier(FileObject mfo, int layer) {
            fsLayer = FileStateManager.access$300(FileStateManager.this, layer);
            fn = mfo.getPath();
            fo = null;
            isDelegate = true;
            if (fsLayer != null) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                pos = fn.lastIndexOf(47);
                isDelegate = false;
                if (-1 == pos) break;
                fn = fn.substring(0, pos);
lbl11:
                // 2 sources

                ** while (fn.length() > 0 && null == (fo = fsLayer.findResource((String)fn)))
            }
lbl12:
            // 2 sources

            if (fo == null) {
                fo = fsLayer.getRoot();
            }
            if (fo != this.notifiers[layer]) {
                if (this.notifiers[layer] != null) {
                    this.notifiers[layer].removeFileChangeListener(this.weakL[layer]);
                }
                this.weakL[layer] = WeakListener.fileChange((FileChangeListener)this, (Object)fo);
                fo.addFileChangeListener(this.weakL[layer]);
                this.notifiers[layer] = fo;
            }
            return isDelegate;
        }

        private synchronized void detachAllNotifiers() {
            int i = 0;
            while (i < 3) {
                if (this.notifiers[i] != null) {
                    this.notifiers[i].removeFileChangeListener(this.weakL[i]);
                    this.notifiers[i] = null;
                    this.weakL[i] = null;
                }
                ++i;
            }
        }

        private int layerOfFile(FileObject fo) {
            try {
                FileSystem fs = fo.getFileSystem();
                int i = 0;
                while (i < 3) {
                    if (fs.equals(FileStateManager.this.getLayer(i))) {
                        return i;
                    }
                    ++i;
                }
            }
            catch (FileStateInvalidException e) {
                IllegalStateException ex = new IllegalStateException("Invalid file - " + fo);
                ErrorManager.getDefault().annotate((Throwable)ex, (Throwable)e);
                throw ex;
            }
            return -1;
        }

        public void fileRenamed(FileRenameEvent fe) {
            FileObject mfo = (FileObject)this.file.get();
            if (mfo != null && mfo.isValid()) {
                FileStateManager.this.discard(mfo);
                FileStateManager.this.fireFileStatusChanged(mfo);
            } else {
                this.detachAllNotifiers();
            }
        }

        public void fileDataCreated(FileEvent fe) {
            FileObject mfo = (FileObject)this.file.get();
            if (mfo != null && mfo.isValid()) {
                String mfoname;
                String created = fe.getFile().getPath();
                if (created.equals(mfoname = mfo.getPath())) {
                    int layer = this.layerOfFile(fe.getFile());
                    if (-1 != layer) {
                        this.attachNotifier(mfo, layer);
                    }
                    this.rescan(mfo);
                }
            } else {
                this.detachAllNotifiers();
            }
        }

        public void fileFolderCreated(FileEvent fe) {
            FileObject mfo = (FileObject)this.file.get();
            if (mfo != null && mfo.isValid()) {
                int layer;
                String created = fe.getFile().getPath();
                String mfoname = mfo.getPath();
                if (mfoname.startsWith(created) && -1 != (layer = this.layerOfFile(fe.getFile())) && this.attachNotifier(mfo, layer)) {
                    this.rescan(mfo);
                }
            } else {
                this.detachAllNotifiers();
            }
        }

        public void fileDeleted(FileEvent fe) {
            FileObject mfo = (FileObject)this.file.get();
            if (mfo != null && mfo.isValid()) {
                String mfoname;
                String deleted = fe.getFile().getPath();
                if (deleted.equals(mfoname = mfo.getPath())) {
                    int layer = this.layerOfFile(fe.getFile());
                    if (-1 != layer) {
                        this.attachNotifier(mfo, layer);
                    }
                    this.rescan(mfo);
                }
            } else {
                this.detachAllNotifiers();
            }
        }
    }

    public static interface FileStatusListener {
        public void fileStatusChanged(FileObject var1);
    }

    private class PropL
    implements PropertyChangeListener {
        PropL() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("session_open".equals(evt.getPropertyName())) {
                int i;
                FileObject[] mfos = null;
                WeakHashMap weakHashMap = FileStateManager.this.info;
                synchronized (weakHashMap) {
                    mfos = ((AbstractMap)FileStateManager.this.info).keySet().toArray(new FileObject[0]);
                    i = 0;
                    while (i < mfos.length) {
                        FileInfo finf = (FileInfo)((Object)FileStateManager.this.info.get(mfos[i]));
                        if (finf != null) {
                            finf.invalidate();
                        }
                        ++i;
                    }
                    FileStateManager.this.info.clear();
                    FileStateManager.this.getLayers();
                }
                i = 0;
                while (i < mfos.length) {
                    FileStateManager.this.fireFileStatusChanged(mfos[i]);
                    ++i;
                }
            }
        }
    }
}

