/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.beans.Beans;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import org.netbeans.core.modules.Events;
import org.netbeans.core.modules.InvalidException;
import org.netbeans.core.modules.Module;
import org.netbeans.core.modules.Util;
import org.openide.ServiceType;
import org.openide.filesystems.FileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;

public abstract class ManifestSection {
    private final Class superclazz;
    private final String name;
    private final String className;
    private Class clazz;
    private Object result;
    private Exception problem;
    private final Module module;
    static /* synthetic */ Class class$org$openide$util$SharedClassObject;

    protected ManifestSection(String name, Module module, Class superclazz) throws InvalidException {
        this.name = name;
        this.module = module;
        this.superclazz = superclazz;
        try {
            this.className = Util.createPackageName(name);
        }
        catch (IllegalArgumentException iae) {
            InvalidException ie = new InvalidException(module, iae.toString());
            Util.err.annotate((Throwable)ie, (Throwable)iae);
            throw ie;
        }
    }

    public final Module getModule() {
        return this.module;
    }

    protected final ClassLoader getClassLoader() {
        return this.module.getClassLoader();
    }

    public final boolean isDefaultInstance() {
        return this.name.endsWith(".class");
    }

    public final Class getSectionClass() throws Exception {
        if (this.clazz != null) {
            return this.clazz;
        }
        if (this.problem != null) {
            throw this.problem;
        }
        if (this.isDefaultInstance()) {
            try {
                this.clazz = this.getClassLoader().loadClass(this.className);
                if (!this.superclazz.isAssignableFrom(this.clazz)) {
                    throw new ClassCastException("Class " + this.clazz.getName() + " is not a subclass of " + this.getSuperclass().getName());
                }
                if (this.clazz.getClassLoader() != this.getClassLoader()) {
                    Events ev = this.module.getManager().getEvents();
                    ev.log("wrongClassLoader", (Object)this.module, this.clazz, this.getClassLoader());
                }
                return this.clazz;
            }
            catch (ClassNotFoundException cnfe) {
                Util.err.annotate((Throwable)cnfe, 0, "Loader for ClassNotFoundException: " + this.getClassLoader(), null, null, null);
                this.problem = cnfe;
                throw this.problem;
            }
            catch (Exception e) {
                this.problem = e;
                throw this.problem;
            }
            catch (LinkageError t) {
                this.problem = new ClassNotFoundException(t.toString(), t);
                throw this.problem;
            }
        }
        this.clazz = this.getInstance().getClass();
        return this.clazz;
    }

    public String getSectionClassName() throws Exception {
        if (this.isDefaultInstance()) {
            return this.className;
        }
        return this.getSectionClass().getName();
    }

    protected final Object createInstance() throws Exception {
        if (!this.isDefaultInstance()) {
            try {
                Object o = Beans.instantiate(this.getClassLoader(), this.className);
                this.clazz = o.getClass();
                if (!this.superclazz.isAssignableFrom(this.clazz)) {
                    throw new ClassCastException("Class " + this.clazz.getName() + " is not a subclass of " + this.getSuperclass().getName());
                }
                return o;
            }
            catch (ClassNotFoundException cnfe) {
                Util.err.annotate((Throwable)cnfe, 0, "Loader for ClassNotFoundException: " + this.getClassLoader(), null, null, null);
                throw cnfe;
            }
            catch (LinkageError le) {
                throw new ClassNotFoundException(le.toString(), le);
            }
        }
        this.getSectionClass();
        if ((class$org$openide$util$SharedClassObject == null ? (class$org$openide$util$SharedClassObject = ManifestSection.class$("org.openide.util.SharedClassObject")) : class$org$openide$util$SharedClassObject).isAssignableFrom(this.clazz)) {
            return SharedClassObject.findObject((Class)this.clazz, (boolean)true);
        }
        return this.clazz.newInstance();
    }

    public final Object getInstance() throws Exception {
        if (this.problem != null) {
            this.problem.fillInStackTrace();
            throw this.problem;
        }
        if (this.result == null) {
            try {
                this.result = this.createInstance();
            }
            catch (Exception ex) {
                this.problem = ex;
                throw this.problem;
            }
            catch (LinkageError t) {
                this.problem = new ClassNotFoundException(t.toString(), t);
                throw this.problem;
            }
        }
        return this.result;
    }

    public final Class getSuperclass() {
        return this.superclazz;
    }

    public void dispose() {
        this.result = null;
        this.problem = null;
        this.clazz = null;
    }

    public String toString() {
        return "ManifestSection[" + this.className + "]";
    }

    public static ManifestSection create(String name, Attributes attr, Module module) throws InvalidException {
        String sectionName = attr.getValue("OpenIDE-Module-Class");
        if (sectionName == null) {
            return null;
        }
        if (sectionName.equalsIgnoreCase("Action")) {
            return new ActionSection(name, attr, module);
        }
        if (sectionName.equalsIgnoreCase("Option")) {
            ManifestSection.warnObsolete(sectionName, module);
            return new OptionSection(name, attr, module);
        }
        if (sectionName.equalsIgnoreCase("Loader")) {
            return new LoaderSection(name, attr, module);
        }
        if (sectionName.equalsIgnoreCase("Filesystem")) {
            ManifestSection.warnObsolete(sectionName, module);
            return new FileSystemSection(name, attr, module);
        }
        if (sectionName.equalsIgnoreCase("Node")) {
            ManifestSection.warnObsolete(sectionName, module);
            Util.err.log(16, "(See http://www.netbeans.org/issues/show_bug.cgi?id=19609, last comment, for howto.)");
            return new NodeSection(name, attr, module);
        }
        if (sectionName.equalsIgnoreCase("Service")) {
            ManifestSection.warnObsolete(sectionName, module);
            return new ServiceSection(name, attr, module);
        }
        if (sectionName.equalsIgnoreCase("Debugger")) {
            ManifestSection.warnObsolete(sectionName, module);
            return new DebuggerSection(name, attr, module);
        }
        if (sectionName.equalsIgnoreCase("ClipboardConvertor")) {
            ManifestSection.warnObsolete(sectionName, module);
            return new ClipboardConvertorSection(name, attr, module);
        }
        throw new InvalidException(module, "Illegal manifest section type: " + sectionName);
    }

    private static void warnObsolete(String sectionName, Module module) {
        Util.err.log(16, "Use of OpenIDE-Module-Class: " + sectionName + " in " + module.getCodeNameBase() + " is obsolete.");
        Util.err.log(16, "(Please use layer-based installation of objects instead.)");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class ClipboardConvertorSection
    extends ManifestSection {
        static /* synthetic */ Class class$org$openide$util$datatransfer$ExClipboard$Convertor;

        ClipboardConvertorSection(String name, Attributes attrs, Module module) throws InvalidException {
            super(name, module, class$org$openide$util$datatransfer$ExClipboard$Convertor == null ? (class$org$openide$util$datatransfer$ExClipboard$Convertor = ClipboardConvertorSection.class$("org.openide.util.datatransfer.ExClipboard$Convertor")) : class$org$openide$util$datatransfer$ExClipboard$Convertor);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class NodeSection
    extends ManifestSection {
        public static final String TYPE_ROOTS = "roots";
        public static final String TYPE_ENVIRONMENT = "environment";
        public static final String TYPE_SESSION = "session";
        private String type;
        static /* synthetic */ Class class$org$openide$nodes$Node;

        NodeSection(String name, Attributes attrs, Module module) throws InvalidException {
            super(name, module, class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = NodeSection.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node);
            this.type = attrs.getValue("Type");
            if (this.type == null) {
                this.type = TYPE_ENVIRONMENT;
            }
            this.type = this.type.toLowerCase();
            if (!(this.type.equalsIgnoreCase(TYPE_ROOTS) || this.type.equalsIgnoreCase(TYPE_ENVIRONMENT) || this.type.equalsIgnoreCase(TYPE_SESSION))) {
                throw new InvalidException(module, "Unrecognized node section type: " + this.type);
            }
        }

        public String getType() {
            return this.type;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class FileSystemSection
    extends ManifestSection {
        private final String locAttr;
        private final HelpCtx help;
        static /* synthetic */ Class class$org$openide$filesystems$FileSystem;

        FileSystemSection(String name, Attributes attr, Module module) throws InvalidException {
            super(name, module, class$org$openide$filesystems$FileSystem == null ? (class$org$openide$filesystems$FileSystem = FileSystemSection.class$("org.openide.filesystems.FileSystem")) : class$org$openide$filesystems$FileSystem);
            this.locAttr = name + "/Display-Name";
            String s = attr.getValue("Help");
            this.help = s == null ? HelpCtx.DEFAULT_HELP : new HelpCtx(s);
        }

        public String getName() {
            String s = (String)this.getModule().getLocalizedAttribute(this.locAttr);
            if (s == null) {
                return "<unnamed filesystem>";
            }
            return s;
        }

        public HelpCtx getHelpCtx() {
            return this.help;
        }

        public FileSystem createFileSystem() throws InstantiationException {
            try {
                return (FileSystem)this.createInstance();
            }
            catch (Exception ex) {
                InstantiationException ie = new InstantiationException(ex.toString());
                Util.err.annotate((Throwable)ie, (Throwable)ex);
                throw ie;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class ServiceSection
    extends ManifestSection {
        private final boolean deflt;
        static /* synthetic */ Class class$org$openide$ServiceType;

        ServiceSection(String name, Attributes attrs, Module module) throws InvalidException {
            super(name, module, class$org$openide$ServiceType == null ? (class$org$openide$ServiceType = ServiceSection.class$("org.openide.ServiceType")) : class$org$openide$ServiceType);
            this.deflt = Boolean.valueOf(attrs.getValue("Default"));
        }

        public boolean isDefault() {
            return this.deflt;
        }

        public ServiceType createServiceType() throws InstantiationException {
            try {
                return (ServiceType)this.createInstance();
            }
            catch (Exception ex) {
                InstantiationException ie = new InstantiationException(ex.toString());
                Util.err.annotate((Throwable)ie, (Throwable)ex);
                throw ie;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class DebuggerSection
    extends ManifestSection {
        static /* synthetic */ Class class$java$lang$ClassLoader;

        DebuggerSection(String name, Attributes attrs, Module module) throws InvalidException {
            super(name, module, DebuggerSection.getDebuggerClazz(module));
        }

        private static Class getDebuggerClazz(Module m) throws InvalidException {
            try {
                return ((ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = DebuggerSection.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader)).loadClass("org.openide.debugger.Debugger");
            }
            catch (ClassNotFoundException cnfe) {
                InvalidException e = new InvalidException(m, "Debugger sections may only be used if you depend on org.openide.deprecated to be able to access Debugger");
                Util.err.annotate((Throwable)e, (Throwable)cnfe);
                throw e;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class LoaderSection
    extends ManifestSection {
        private final String[] installAfter;
        private final String[] installBefore;
        static /* synthetic */ Class class$org$openide$loaders$DataLoader;

        LoaderSection(String name, Attributes attrs, Module module) throws InvalidException {
            super(name, module, class$org$openide$loaders$DataLoader == null ? (class$org$openide$loaders$DataLoader = LoaderSection.class$("org.openide.loaders.DataLoader")) : class$org$openide$loaders$DataLoader);
            String clazz;
            LinkedList<String> res;
            StringTokenizer tok;
            String val = attrs.getValue("Install-After");
            if (val != null) {
                tok = new StringTokenizer(val, ", ");
                res = new LinkedList<String>();
                while (tok.hasMoreTokens()) {
                    clazz = tok.nextToken();
                    if (clazz.equals("")) continue;
                    res.add(clazz);
                }
                this.installAfter = res.toArray(new String[res.size()]);
            } else {
                this.installAfter = null;
            }
            val = attrs.getValue("Install-Before");
            if (val != null) {
                tok = new StringTokenizer(val, ", ");
                res = new LinkedList();
                while (tok.hasMoreTokens()) {
                    clazz = tok.nextToken();
                    if (clazz.equals("")) continue;
                    res.add(clazz);
                }
                this.installBefore = res.toArray(new String[res.size()]);
            } else {
                this.installBefore = null;
            }
        }

        public String[] getInstallAfter() {
            return this.installAfter;
        }

        public String[] getInstallBefore() {
            return this.installBefore;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class OptionSection
    extends ManifestSection {
        static /* synthetic */ Class class$org$openide$options$SystemOption;

        OptionSection(String name, Attributes attrs, Module module) throws InvalidException {
            super(name, module, class$org$openide$options$SystemOption == null ? (class$org$openide$options$SystemOption = OptionSection.class$("org.openide.options.SystemOption")) : class$org$openide$options$SystemOption);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class ActionSection
    extends ManifestSection {
        static /* synthetic */ Class class$org$openide$util$actions$SystemAction;

        ActionSection(String name, Attributes attrs, Module module) throws InvalidException {
            super(name, module, class$org$openide$util$actions$SystemAction == null ? (class$org$openide$util$actions$SystemAction = ActionSection.class$("org.openide.util.actions.SystemAction")) : class$org$openide$util$actions$SystemAction);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

