/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.EnvironmentNode;
import org.netbeans.core.ui.MountNode;
import org.netbeans.core.windows.nodes.WorkspacePoolContext;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;

public final class NbPlaces {
    private final List listeners = new ArrayList();
    private static NbPlaces DEFAULT;

    private NbPlaces() {
    }

    public static synchronized NbPlaces getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new NbPlaces();
        }
        return DEFAULT;
    }

    public void addChangeListener(ChangeListener l) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    public void removeChangeListener(ChangeListener l) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    void fireChange() {
        ChangeListener[] l;
        List list = this.listeners;
        synchronized (list) {
            l = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        ChangeEvent ev = new ChangeEvent(this);
        int i = 0;
        while (i < l.length) {
            l[i].stateChanged(ev);
            ++i;
        }
    }

    public Node environment() {
        return EnvironmentNode.find("environment");
    }

    public Node session() {
        return EnvironmentNode.find("session");
    }

    public Node workspaces() {
        return WorkspacePoolContext.getDefault();
    }

    public Node repositorySettings() {
        return new MountNode();
    }

    public Node projectDesktop() {
        return this.workplace().getNodeDelegate();
    }

    public Node[] roots() {
        return EnvironmentNode.find("roots").getChildren().getNodes();
    }

    public DataFolder templates() {
        return NbPlaces.findSessionFolder("Templates");
    }

    public DataFolder toolbars() {
        return NbPlaces.findSessionFolder("Toolbars");
    }

    public DataFolder menus() {
        return NbPlaces.findSessionFolder("Menu");
    }

    public DataFolder actions() {
        return NbPlaces.findSessionFolder("Actions");
    }

    public DataFolder bookmarks() {
        return NbPlaces.findSessionFolder("Bookmarks");
    }

    public DataFolder projects() {
        return NbPlaces.findSessionFolder("Projects");
    }

    public DataFolder startup() {
        return NbPlaces.findSessionFolder("Startup");
    }

    public DataFolder welcome() {
        return NbPlaces.findSessionFolder("Welcome");
    }

    public DataFolder workplace() {
        return NbPlaces.findSessionFolder("Workplace");
    }

    public static DataFolder findSessionFolder(String name) {
        try {
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            FileObject fo = fs.findResource(name);
            if (fo == null) {
                fo = fs.getRoot();
                StringTokenizer st = new StringTokenizer(name, "/");
                while (st.hasMoreTokens()) {
                    String subFolderName = st.nextToken();
                    FileObject ff = fo.getFileObject(subFolderName);
                    fo = ff != null && ff.isFolder() ? ff : fo.createFolder(subFolderName);
                }
            }
            DataFolder df = DataFolder.findFolder((FileObject)fo);
            return df;
        }
        catch (IOException ex) {
            IllegalStateException e = new IllegalStateException("Folder not found and cannot be created: " + name);
            ErrorManager.getDefault().annotate((Throwable)e, (Throwable)ex);
            throw e;
        }
    }
}

