/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;

public final class NbKeymap
extends Observable
implements Keymap {
    String name;
    Keymap parent;
    Map bindings;
    Action defaultAction;
    Map actions;

    public NbKeymap() {
        this("Default", null);
    }

    NbKeymap(String name, Keymap parent) {
        this.name = name;
        this.parent = parent;
        this.bindings = new HashMap();
    }

    public Action getDefaultAction() {
        if (this.defaultAction != null) {
            return this.defaultAction;
        }
        return this.parent != null ? this.parent.getDefaultAction() : null;
    }

    public void setDefaultAction(Action a) {
        this.defaultAction = a;
        this.setChanged();
        this.notifyObservers();
    }

    public String getName() {
        return this.name;
    }

    public Action getAction(KeyStroke key) {
        Action a = null;
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            a = (Action)this.bindings.get(key);
        }
        if (a == null && this.parent != null) {
            a = this.parent.getAction(key);
        }
        return a;
    }

    public KeyStroke[] getBoundKeyStrokes() {
        int i = 0;
        KeyStroke[] keys = null;
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            keys = new KeyStroke[this.bindings.size()];
            Iterator iter = this.bindings.keySet().iterator();
            while (iter.hasNext()) {
                keys[i++] = (KeyStroke)iter.next();
            }
        }
        return keys;
    }

    public Action[] getBoundActions() {
        int i = 0;
        Action[] actionsArray = null;
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            actionsArray = new Action[this.bindings.size()];
            Iterator iter = this.bindings.values().iterator();
            while (iter.hasNext()) {
                actionsArray[i++] = (Action)iter.next();
            }
        }
        return actionsArray;
    }

    public KeyStroke[] getKeyStrokesForAction(Action a) {
        List strokes;
        Map localActions = this.actions;
        if (localActions == null) {
            localActions = this.buildReverseMapping();
        }
        if ((strokes = (List)localActions.get(a)) != null) {
            return strokes.toArray(new KeyStroke[strokes.size()]);
        }
        return new KeyStroke[0];
    }

    private Map buildReverseMapping() {
        HashMap<Action, List<KeyStroke>> localActions = this.actions = new HashMap<Action, List<KeyStroke>>();
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            Iterator it = this.bindings.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry curEntry = it.next();
                Action curAction = (Action)curEntry.getValue();
                KeyStroke curKey = (KeyStroke)curEntry.getKey();
                List<KeyStroke> keysForAction = (List<KeyStroke>)localActions.get(curAction);
                if (keysForAction == null) {
                    keysForAction = Collections.synchronizedList(new ArrayList(1));
                    localActions.put(curAction, keysForAction);
                }
                keysForAction.add(curKey);
            }
        }
        return localActions;
    }

    public synchronized boolean isLocallyDefined(KeyStroke key) {
        return this.bindings.containsKey(key);
    }

    private void updateActionAccelerator(Action a) {
        if (a == null) {
            return;
        }
        KeyStroke[] keystrokes = this.getKeyStrokesForAction(a);
        a.putValue("AcceleratorKey", keystrokes.length > 0 ? keystrokes[0] : null);
    }

    public void addActionForKeyStroke(KeyStroke key, Action a) {
        Action old;
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            old = this.bindings.put(key, a);
            this.actions = null;
        }
        this.updateActionAccelerator(a);
        this.updateActionAccelerator(old);
        this.setChanged();
        this.notifyObservers();
    }

    void addActionForKeyStrokeMap(Map map) {
        Iterator<Object> it;
        HashSet actionsSet = new HashSet();
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            it = map.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                Object value = map.get(key);
                actionsSet.add(value);
                actionsSet.add(this.bindings.put(key, value));
            }
            this.actions = null;
        }
        it = actionsSet.iterator();
        while (it.hasNext()) {
            this.updateActionAccelerator((Action)it.next());
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void removeKeyStrokeBinding(KeyStroke key) {
        Action a;
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            a = (Action)this.bindings.remove(key);
            this.actions = null;
        }
        this.updateActionAccelerator(a);
        this.setChanged();
        this.notifyObservers();
    }

    public void removeBindings() {
        HashSet actionsSet;
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            actionsSet = new HashSet(this.bindings.values());
            this.bindings.clear();
            this.actions = null;
        }
        Iterator it = actionsSet.iterator();
        while (it.hasNext()) {
            this.updateActionAccelerator((Action)it.next());
        }
        this.setChanged();
        this.notifyObservers();
    }

    public Keymap getResolveParent() {
        return this.parent;
    }

    public void setResolveParent(Keymap parent) {
        this.parent = parent;
        this.setChanged();
        this.notifyObservers();
    }

    public String toString() {
        return "Keymap[" + this.name + "]" + this.bindings;
    }
}

