/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.loaders.ExtensionList;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class ExLocalFileSystem
extends LocalFileSystem
implements Runnable {
    private static final long serialVersionUID = -6117993653210115798L;
    private static final ExtensionList DEFAULT_EXTENSIONS = new ExtensionList();
    private static final String BACKUP_EXT = System.getProperty("org.netbeans.core.ExLocalFileSystem.BACKUP_EXT", "~");
    private ExtensionList backupExtensions;
    private String ignoredFiles = "";
    private transient RE ignoredRE = null;
    private static final Object ignoredRELock = new String("org.netbeans.core.ExLocalFileSystem.ignoredRELock");
    private String relativeName;
    private boolean relativeFlag = false;
    static /* synthetic */ Class class$org$netbeans$core$ExLocalFileSystem;

    public OutputStream outputStream(String name) throws IOException {
        this.backupIfNecessary(name);
        return super.outputStream(name);
    }

    protected void delete(String name) throws IOException {
        this.backupIfNecessary(name);
        super.delete(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void backupIfNecessary(String name) throws IOException {
        ExtensionList b = this.backupExtensions == null ? DEFAULT_EXTENSIONS : this.backupExtensions;
        if (!b.isRegistered(name)) return;
        InputStream is = null;
        try {
            try {
                is = super.inputStream(name);
                OutputStream os = super.outputStream(name + BACKUP_EXT);
                try {
                    FileUtil.copy((InputStream)is, (OutputStream)os);
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    os.close();
                    throw throwable;
                }
                os.close();
                Object var8_9 = null;
                if (is == null) return;
            }
            catch (FileNotFoundException fex) {
                Object var8_10 = null;
                if (is == null) return;
                is.close();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (is == null) throw throwable;
            is.close();
            throw throwable;
        }
        is.close();
    }

    public String[] children(String name) {
        String[] arr = super.children(name);
        if (arr == null) {
            return null;
        }
        Object object = ignoredRELock;
        synchronized (object) {
            int i = 0;
            while (i < arr.length) {
                if (Utilities.getOperatingSystem() == 8192 && arr[i].endsWith(".java_")) {
                    try {
                        String newBackupFile = arr[i].substring(0, arr[i].length() - 1) + BACKUP_EXT;
                        super.rename(name + "/" + arr[i], name + "/" + newBackupFile);
                        arr[i] = newBackupFile;
                    }
                    catch (IOException fex) {
                        // empty catch block
                    }
                }
                if (arr[i].endsWith(BACKUP_EXT) || this.ignoredRE != null && this.ignoredRE.match(arr[i])) {
                    arr[i] = null;
                }
                ++i;
            }
        }
        return arr;
    }

    public void setRefreshTime2(int ms) {
        int old = super.getRefreshTime();
        super.setRefreshTime(ms);
        if (old != ms) {
            this.firePropertyChange("refreshTime", new Integer(old), new Integer(ms));
        }
    }

    public int getRefreshTime2() {
        return super.getRefreshTime();
    }

    public void setSystemName2(String name) throws PropertyVetoException {
        try {
            super.setSystemName(name);
        }
        catch (PropertyVetoException pvx) {
            ErrorManager.getDefault().annotate((Throwable)pvx, pvx.getMessage());
            throw pvx;
        }
    }

    public void setBackupExtensions(ExtensionList l) {
        this.backupExtensions = l;
        this.firePropertyChange("backupExtensions", null, null);
    }

    public ExtensionList getBackupExtensions() {
        if (this.backupExtensions == null) {
            return (ExtensionList)DEFAULT_EXTENSIONS.clone();
        }
        return this.backupExtensions;
    }

    public String getIgnoredFiles() {
        return this.ignoredFiles;
    }

    public synchronized void setIgnoredFiles(String nue) throws IllegalArgumentException {
        if (!nue.equals(this.ignoredFiles)) {
            block7: {
                if (nue.length() > 0) {
                    try {
                        Object object = ignoredRELock;
                        synchronized (object) {
                            this.ignoredRE = new RE(nue);
                            break block7;
                        }
                    }
                    catch (RESyntaxException rese) {
                        IllegalArgumentException iae = new IllegalArgumentException();
                        ErrorManager.getDefault().annotate((Throwable)iae, 256, null, NbBundle.getMessage((Class)(class$org$netbeans$core$ExLocalFileSystem == null ? (class$org$netbeans$core$ExLocalFileSystem = ExLocalFileSystem.class$("org.netbeans.core.ExLocalFileSystem")) : class$org$netbeans$core$ExLocalFileSystem), (String)"EXC_InvalidRegularExpressionForIgnoredFiles", (Object)rese.getLocalizedMessage()), (Throwable)rese, new Date());
                        throw iae;
                    }
                }
                this.ignoredRE = null;
            }
            this.ignoredFiles = nue;
            this.firePropertyChange("ignoredFiles", null, null);
            RequestProcessor.getDefault().post((Runnable)this);
        }
    }

    public void run() {
        Enumeration e = this.existingFileObjects(this.getRoot());
        while (e.hasMoreElements()) {
            FileObject fo = (FileObject)e.nextElement();
            if (!fo.isFolder()) continue;
            fo.refresh(true);
        }
    }

    public void setRelativeDirectory(String relativeName) throws PropertyVetoException, IOException {
        String oldRelative = this.relativeName;
        try {
            try {
                this.relativeName = relativeName;
                this.relativeFlag = true;
                String file = System.getProperty("netbeans.user") + File.separatorChar + relativeName;
                File f = new File(file);
                try {
                    f = f.getCanonicalFile();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.setRootDirectory(f);
            }
            catch (PropertyVetoException ex) {
                this.relativeName = oldRelative;
                throw ex;
            }
            catch (IOException ex) {
                this.relativeName = oldRelative;
                throw ex;
            }
            Object var7_8 = null;
            this.relativeFlag = false;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.relativeFlag = false;
            throw throwable;
        }
    }

    public String getRelativeDirectory() {
        return this.relativeName;
    }

    protected String computeSystemName(File rootFile) {
        if (this.relativeName != null) {
            return "{netbeans.user}/" + this.relativeName;
        }
        return super.computeSystemName(rootFile);
    }

    public synchronized void setRootDirectory(File r) throws PropertyVetoException, IOException {
        String oldRelative = this.relativeName;
        if (!this.relativeFlag) {
            this.relativeName = null;
        }
        try {
            super.setRootDirectory(r);
        }
        catch (PropertyVetoException ex) {
            this.relativeName = oldRelative;
            throw ex;
        }
        catch (IOException ex) {
            this.relativeName = oldRelative;
            throw ex;
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.ignoredFiles == null) {
            this.ignoredFiles = "";
        } else if (this.ignoredFiles.length() > 0) {
            try {
                this.ignoredRE = new RE(this.ignoredFiles);
            }
            catch (RESyntaxException rese) {
                ErrorManager.getDefault().notify((Throwable)rese);
            }
        }
        if (this.relativeName != null) {
            try {
                this.setRelativeDirectory(this.relativeName);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

