/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openide.ErrorManager;
import org.openide.actions.CloneViewAction;
import org.openide.actions.CloseViewAction;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.DefaultTopComponentLookup;
import org.openide.windows.DelegateActionMap;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class TopComponent
extends JComponent
implements Externalizable,
Accessible,
HelpCtx.Provider,
Lookup.Provider {
    static final long serialVersionUID = -3022538025284122942L;
    private static final Log log = LogFactory.getLog(TopComponent.class);
    public static final int CLOSE_EACH = 0;
    public static final int CLOSE_LAST = 1;
    private static SystemAction[] DEFAULT_ACTIONS;
    private static Object defaultLookupLock;
    private Reference defaultLookupRef = new WeakReference<Object>(null);
    private NodeName nodeName;
    private final WindowManager.Component manager;
    private int closeOperation = 1;
    short serialVersion = 1;

    public TopComponent() {
        log.debug((Object)"using stand-alone GP TopComponent");
        this.enableEvents(8L);
        try {
            Method method = this.getClass().getMethod("setFocusable", Boolean.TYPE);
            method.invoke((Object)this, new Boolean(false));
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        this.manager = WindowManager.getDefault().createTopComponentManager(this);
    }

    public static final Registry getRegistry() {
        return WindowManager.getDefault().getRegistry();
    }

    public final Node[] getActivatedNodes() {
        return this.getManager().getActivatedNodes();
    }

    public final void setActivatedNodes(Node[] nodeArray) {
        this.getManager().setActivatedNodes(nodeArray);
        this.firePropertyChange("activatedNodes", null, null);
    }

    public UndoRedo getUndoRedo() {
        return UndoRedo.NONE;
    }

    public void open() {
        this.open(null);
    }

    public void open(Workspace workspace) {
        this.getManager().open(workspace);
    }

    public final boolean isOpened() {
        return this.getManager().whereOpened().size() > 0;
    }

    public final boolean isOpened(Workspace workspace) {
        return this.getManager().whereOpened().contains(workspace);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!(this.getParent() instanceof TopComponent)) {
            this.setBorder(UIManager.getBorder("nb.TopComponent.border"));
        }
    }

    public final boolean close() {
        return this.close(WindowManager.getDefault().getCurrentWorkspace());
    }

    public final boolean close(Workspace workspace) {
        boolean bl;
        Set set = this.getManager().whereOpened();
        if (this.closeOperation != 0 && !set.contains(workspace)) {
            return true;
        }
        switch (this.closeOperation) {
            case 1: {
                bl = this.canClose(workspace, set.size() == 1);
                break;
            }
            case 0: {
                bl = this.canClose(null, true);
                break;
            }
            default: {
                throw new IllegalStateException("closeOperation=" + this.closeOperation);
            }
        }
        if (bl) {
            this.getManager().close(workspace);
        }
        return bl;
    }

    public boolean canClose(Workspace workspace, boolean bl) {
        return true;
    }

    protected void openNotify() {
    }

    protected void closeNotify() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemAction[] getSystemActions() {
        Class<TopComponent> clazz = TopComponent.class;
        synchronized (TopComponent.class) {
            if (DEFAULT_ACTIONS == null) {
                DEFAULT_ACTIONS = new SystemAction[]{SystemAction.get(CloneViewAction.class), null, SystemAction.get(CloseViewAction.class)};
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DEFAULT_ACTIONS;
        }
    }

    public Action[] getActions() {
        return this.getSystemActions();
    }

    public final void setCloseOperation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(NbBundle.getBundle(TopComponent.class).getString("EXC_UnknownOperation"));
        }
        if (this.closeOperation == n) {
            return;
        }
        this.closeOperation = n;
        this.firePropertyChange("closeOperation", null, null);
    }

    public final int getCloseOperation() {
        return this.closeOperation;
    }

    protected void componentOpened() {
        this.openNotify();
    }

    protected void componentClosed() {
        this.closeNotify();
    }

    protected void componentShowing() {
    }

    protected void componentHidden() {
    }

    protected void componentActivated() {
    }

    protected void componentDeactivated() {
    }

    @Override
    public void requestFocus() {
        this.getManager().requestFocus();
        super.requestFocus();
    }

    public void requestVisible() {
        this.getManager().requestVisible();
    }

    @Override
    public void setName(String string) {
        String string2 = this.getName();
        if (string != null && string.equals(string2)) {
            return;
        }
        super.setName(string);
        this.firePropertyChange("name", string2, string);
        this.getManager().nameChanged();
    }

    @Override
    public void setToolTipText(String string) {
        if (string != null && string.equals(this.getToolTipText())) {
            return;
        }
        super.setToolTipText(string);
        this.getManager().nameChanged();
    }

    public void setIcon(Image image) {
        this.getManager().setIcon(image);
        this.firePropertyChange("icon", null, null);
    }

    public Image getIcon() {
        return this.getManager().getIcon();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(TopComponent.class);
    }

    public List availableModes(List list) {
        return list;
    }

    final WindowManager.Component getManager() {
        return this.manager;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(new Short(this.serialVersion));
        objectOutput.writeInt(this.closeOperation);
        objectOutput.writeObject(this.getName());
        objectOutput.writeObject(this.getToolTipText());
        Node.Handle handle = this.nodeName == null ? null : this.nodeName.node.getHandle();
        objectOutput.writeObject(handle);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        throw new IOException("GP: restore not supported");
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new Replacer(this);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }

                @Override
                public String getAccessibleName() {
                    if (this.accessibleName != null) {
                        return this.accessibleName;
                    }
                    return TopComponent.this.getName();
                }

                @Override
                public String getToolTipText() {
                    return TopComponent.this.getToolTipText();
                }
            };
        }
        return this.accessibleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookup() {
        Object object = defaultLookupLock;
        synchronized (object) {
            Object t = this.defaultLookupRef.get();
            if (t instanceof Lookup) {
                return (Lookup)t;
            }
            ProxyLookup proxyLookup = new ProxyLookup(new Lookup[]{new DefaultTopComponentLookup(this), Lookups.singleton((Object)new DelegateActionMap((JComponent)this))});
            this.defaultLookupRef = new WeakReference<ProxyLookup>(proxyLookup);
            return proxyLookup;
        }
    }

    static {
        defaultLookupLock = new Object();
    }

    private static final class Replacer
    implements Serializable {
        static final long serialVersionUID = -8897067133215740572L;
        transient TopComponent tc;

        public Replacer(TopComponent topComponent) {
            this.tc = topComponent;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
            objectOutputStream.writeObject(this.tc.getClass().getName());
            this.tc.writeExternal(objectOutputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            block14: {
                String string = (String)objectInputStream.readObject();
                string = Utilities.translate((String)string);
                try {
                    Class<?>[] classArray;
                    Class<?> clazz = Class.forName(string, true, (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class));
                    Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    try {
                        this.tc = (TopComponent)constructor.newInstance(new Object[0]);
                    }
                    finally {
                        constructor.setAccessible(false);
                    }
                    this.tc.readExternal(objectInputStream);
                    Method method = Replacer.findReadResolveMethod(clazz);
                    if (method == null || (classArray = method.getExceptionTypes()).length != 1 || !ObjectStreamException.class.equals(classArray[0]) || !Object.class.equals(method.getReturnType())) break block14;
                    method.setAccessible(true);
                    try {
                        TopComponent topComponent = this.tc;
                        this.tc = (TopComponent)method.invoke((Object)this.tc, (Object[])new Class[0]);
                        if (this.tc == null) {
                            throw new InvalidObjectException("TopComponent.readResolve() cannot return null. See http://www.netbeans.org/issues/show_bug.cgi?id=27849 for more info. TopComponent:" + topComponent);
                        }
                    }
                    finally {
                        method.setAccessible(false);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (classNotFoundException.getMessage().indexOf("org.netbeans.modules.objectbrowser") != -1 || classNotFoundException.getMessage().indexOf("org.netbeans.modules.icebrowser") != -1) {
                        this.tc = null;
                    }
                    IOException iOException = new IOException(classNotFoundException.getMessage());
                    ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)classNotFoundException);
                    throw iOException;
                }
                catch (Exception exception) {
                    Throwable throwable = exception;
                    if (throwable instanceof InvocationTargetException) {
                        throwable = ((InvocationTargetException)throwable).getTargetException();
                    }
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    IOException iOException = new IOException(throwable.getMessage());
                    ErrorManager.getDefault().annotate((Throwable)iOException, throwable);
                    throw iOException;
                }
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return this.tc;
        }

        private static Method findReadResolveMethod(Class clazz) {
            Method method = null;
            try {
                method = clazz.getMethod("readResolve", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                try {
                    method = clazz2.getDeclaredMethod("readResolve", new Class[0]);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            return method;
        }
    }

    public static interface Registry {
        public static final String PROP_OPENED = "opened";
        public static final String PROP_ACTIVATED = "activated";
        public static final String PROP_CURRENT_NODES = "currentNodes";
        public static final String PROP_ACTIVATED_NODES = "activatedNodes";

        public Set getOpened();

        public TopComponent getActivated();

        public Node[] getCurrentNodes();

        public Node[] getActivatedNodes();

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }

    public static class NodeName
    extends NodeAdapter {
        private transient Reference top;
        private transient Node node;

        public NodeName(TopComponent topComponent) {
            this.top = new WeakReference<TopComponent>(topComponent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void attach(Node node) {
            TopComponent topComponent = (TopComponent)this.top.get();
            if (topComponent != null) {
                TopComponent topComponent2 = topComponent;
                synchronized (topComponent2) {
                    if (node == this.node) {
                        return;
                    }
                    if (this.node != null) {
                        this.node.removeNodeListener((NodeListener)this);
                    }
                    this.node = node;
                    if (node != null) {
                        node.addNodeListener((NodeListener)this);
                        topComponent.setActivatedNodes(new Node[]{node});
                        topComponent.setName(node.getDisplayName());
                    }
                }
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TopComponent topComponent = (TopComponent)this.top.get();
            if (topComponent == null) {
                if (propertyChangeEvent.getSource() instanceof Node) {
                    Node node = (Node)propertyChangeEvent.getSource();
                    node.removeNodeListener((NodeListener)this);
                }
                return;
            }
            this.attach(this.node);
            if (propertyChangeEvent.getPropertyName().equals("displayName")) {
                topComponent.setName(this.node.getDisplayName());
            }
        }
    }

    public static interface Cloneable {
        public TopComponent cloneComponent();
    }
}

