/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.swing.JFrame;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openide.nodes.Node;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class DummyWindowManager
extends WindowManager {
    private static final Log log = LogFactory.getLog(DummyWindowManager.class);
    private static final long serialVersionUID = 1L;
    private final Map workspaces;
    private transient Frame mw;
    private transient PropertyChangeSupport pcs;
    private transient R r;

    public DummyWindowManager() {
        log.debug((Object)"instantiating DummyWindowManager");
        this.workspaces = new TreeMap();
        this.createWorkspace("default", null);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport((Object)this);
        }
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected TopComponent.Registry componentRegistry() {
        TopComponent.Registry registry = super.componentRegistry();
        if (registry != null) {
            return registry;
        }
        return this.registry();
    }

    public synchronized R registry() {
        if (this.r == null) {
            this.r = new R();
        }
        log.debug((Object)("returning dummy TopComponent.Registry() R():" + this.r));
        return this.r;
    }

    protected WindowManager.Component createTopComponentManager(TopComponent topComponent) {
        return new TCM(topComponent);
    }

    public synchronized Workspace createWorkspace(String string, String string2) {
        W w = new W(string);
        this.workspaces.put(string, w);
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workspaces", null, null);
            this.pcs.firePropertyChange("currentWorkspace", null, null);
        }
        return w;
    }

    synchronized void delete(Workspace workspace) {
        this.workspaces.remove(workspace.getName());
        if (this.workspaces.isEmpty()) {
            this.createWorkspace("default", null);
        }
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workspaces", null, null);
            this.pcs.firePropertyChange("currentWorkspace", null, null);
        }
    }

    public synchronized Workspace findWorkspace(String string) {
        return (Workspace)this.workspaces.get(string);
    }

    public synchronized Workspace getCurrentWorkspace() {
        return (Workspace)this.workspaces.values().iterator().next();
    }

    public synchronized Workspace[] getWorkspaces() {
        return this.workspaces.values().toArray(new Workspace[0]);
    }

    public synchronized void setWorkspaces(Workspace[] workspaceArray) {
        if (workspaceArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this.workspaces.clear();
        for (int i = 0; i < workspaceArray.length; ++i) {
            this.workspaces.put(workspaceArray[i].getName(), workspaceArray[i]);
        }
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workspaces", null, null);
            this.pcs.firePropertyChange("currentWorkspace", null, null);
        }
    }

    public synchronized Frame getMainWindow() {
        if (this.mw == null) {
            this.mw = new JFrame("dummy");
        }
        return this.mw;
    }

    public void updateUI() {
    }

    private final class R
    implements TopComponent.Registry {
        private TopComponent active;
        private final Set opened = new HashSet();
        private Node[] nodes = new Node[0];
        private PropertyChangeSupport pcs;

        @Override
        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.pcs == null) {
                this.pcs = new PropertyChangeSupport(this);
            }
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.pcs != null) {
                this.pcs.removePropertyChangeListener(propertyChangeListener);
            }
        }

        synchronized void open(TopComponent topComponent) {
            this.opened.add(topComponent);
            if (this.pcs != null) {
                this.pcs.firePropertyChange("opened", null, null);
            }
        }

        synchronized void close(TopComponent topComponent) {
            this.opened.remove(topComponent);
            if (this.pcs != null) {
                this.pcs.firePropertyChange("opened", null, null);
            }
        }

        @Override
        public synchronized Set getOpened() {
            return new HashSet(this.opened);
        }

        synchronized void setActive(TopComponent topComponent) {
            this.active = topComponent;
            Node[] nodeArray = topComponent.getActivatedNodes();
            if (nodeArray != null) {
                this.nodes = nodeArray;
                if (this.pcs != null) {
                    this.pcs.firePropertyChange("activatedNodes", null, null);
                }
            }
            if (this.pcs != null) {
                this.pcs.firePropertyChange("activated", null, null);
                this.pcs.firePropertyChange("currentNodes", null, null);
            }
        }

        synchronized void setActivatedNodes(TopComponent topComponent, Node[] nodeArray) {
            if (topComponent == this.active) {
                if (nodeArray != null) {
                    this.nodes = nodeArray;
                    if (this.pcs != null) {
                        this.pcs.firePropertyChange("activatedNodes", null, null);
                    }
                }
                if (this.pcs != null) {
                    this.pcs.firePropertyChange("currentNodes", null, null);
                }
            }
        }

        @Override
        public TopComponent getActivated() {
            return this.active;
        }

        @Override
        public Node[] getActivatedNodes() {
            return this.nodes;
        }

        @Override
        public synchronized Node[] getCurrentNodes() {
            if (this.active != null) {
                return this.active.getActivatedNodes();
            }
            return null;
        }
    }

    private final class W
    implements Workspace {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final Map modes = new HashMap();
        private final Map modesByComponent = new WeakHashMap();
        private transient PropertyChangeSupport pcs;

        public W(String string) {
            this.name = string;
        }

        public void activate() {
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.pcs == null) {
                this.pcs = new PropertyChangeSupport(this);
            }
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.pcs != null) {
                this.pcs.removePropertyChangeListener(propertyChangeListener);
            }
        }

        public void remove() {
            DummyWindowManager.this.delete(this);
        }

        public synchronized Mode createMode(String string, String string2, URL uRL) {
            M m = new M(string);
            this.modes.put(string, m);
            if (this.pcs != null) {
                this.pcs.firePropertyChange("modes", null, null);
            }
            return m;
        }

        public synchronized Set getModes() {
            return new HashSet(this.modes.values());
        }

        public synchronized Mode findMode(String string) {
            return (Mode)this.modes.get(string);
        }

        public synchronized Mode findMode(TopComponent topComponent) {
            return (Mode)this.modesByComponent.get(topComponent);
        }

        synchronized void dock(Mode mode, TopComponent topComponent) {
            this.modesByComponent.put(topComponent, mode);
        }

        public Rectangle getBounds() {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.getName();
        }

        private final class M
        implements Mode {
            private static final long serialVersionUID = 1L;
            private final String name;
            private final Set components = new HashSet();

            public M(String string) {
                this.name = string;
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            }

            public boolean canDock(TopComponent topComponent) {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized boolean dockInto(TopComponent topComponent) {
                if (this.components.add(topComponent)) {
                    Mode mode = W.this.findMode(topComponent);
                    if (mode != null && mode != this && mode instanceof M) {
                        Mode mode2 = mode;
                        synchronized (mode2) {
                            ((M)mode).components.remove(topComponent);
                        }
                    }
                    W.this.dock(this, topComponent);
                }
                return true;
            }

            public String getName() {
                return this.name;
            }

            public String getDisplayName() {
                return this.getName();
            }

            public Image getIcon() {
                return null;
            }

            public synchronized TopComponent[] getTopComponents() {
                return this.components.toArray(new TopComponent[0]);
            }

            public Workspace getWorkspace() {
                return W.this;
            }

            public synchronized Rectangle getBounds() {
                return W.this.getBounds();
            }

            public void setBounds(Rectangle rectangle) {
            }
        }
    }

    private final class TCM
    implements WindowManager.Component {
        private static final long serialVersionUID = 1L;
        private final TopComponent tc;
        private transient JFrame f;
        private Image icon;
        private final Set workspaces = new HashSet();
        private transient Node[] nodes;

        public TCM(TopComponent topComponent) {
            this.tc = topComponent;
        }

        public void open() {
            this.open(DummyWindowManager.this.getCurrentWorkspace());
        }

        public synchronized void open(final Workspace workspace) {
            if (this.f == null) {
                this.f = new JFrame(this.tc.getName());
                if (this.icon != null) {
                    this.f.setIconImage(this.icon);
                }
                this.f.getContentPane().add(this.tc);
                this.f.pack();
                this.f.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        TCM.this.close(workspace);
                    }
                });
            }
            this.f.show();
            this.workspaces.add(workspace);
            DummyWindowManager.this.registry().open(this.tc);
        }

        public synchronized void close(Workspace workspace) {
            if (this.f != null) {
                this.f.setVisible(false);
            }
            this.workspaces.remove(workspace);
            DummyWindowManager.this.registry().close(this.tc);
        }

        public synchronized Set whereOpened() {
            return this.workspaces;
        }

        public Node[] getActivatedNodes() {
            return this.nodes;
        }

        public void setActivatedNodes(Node[] nodeArray) {
            log.debug((Object)("activated nodes: " + nodeArray));
            this.nodes = nodeArray;
            DummyWindowManager.this.registry().setActivatedNodes(this.tc, nodeArray);
        }

        public synchronized void nameChanged() {
            if (this.f != null) {
                this.f.setTitle(this.tc.getName());
            }
        }

        public void requestFocus() {
            DummyWindowManager.this.registry().setActive(this.tc);
        }

        public void requestVisible() {
            if (this.f != null) {
                this.f.show();
            }
        }

        public Image getIcon() {
            return this.icon;
        }

        public void setIcon(Image image) {
            this.icon = image;
            if (this.f != null && image != null) {
                this.f.setIconImage(image);
            }
        }
    }
}

