/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.util.buffer;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import cern.laser.util.buffer.PullEvent;
import cern.laser.util.buffer.PullException;
import cern.laser.util.buffer.SynchroBufferListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class LinkedQueueSynchroBuffer {
    private static final Logger LOGGER = Logger.getLogger(LinkedQueueSynchroBuffer.class);
    private SynchroBufferListener listener = null;
    private LinkedQueue buffer = new LinkedQueue();
    private Thread postman = new Thread(new Postman());

    public void push(Object object) {
        while (true) {
            try {
                this.buffer.put(object);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public Object take() {
        Object object = null;
        while (true) {
            try {
                object = this.buffer.take();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return object;
    }

    public void push(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.push(iterator.next());
        }
    }

    public void setSynchroBufferListener(SynchroBufferListener synchroBufferListener) {
        this.listener = synchroBufferListener;
    }

    public void enable() {
        this.postman.start();
    }

    public void disable() {
        LOGGER.error((Object)"disable() called, but not implemented");
    }

    public void close() {
        LOGGER.error((Object)"close() called, but it is not implemented.");
    }

    private class Postman
    implements Runnable {
        private Postman() {
        }

        @Override
        public void run() {
            while (true) {
                ArrayList<Object> arrayList = new ArrayList<Object>(1);
                try {
                    arrayList.add(LinkedQueueSynchroBuffer.this.buffer.take());
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                LOGGER.debug((Object)"take() returned an element.");
                try {
                    LinkedQueueSynchroBuffer.this.listener.pull(new PullEvent(this, arrayList));
                    LOGGER.debug((Object)"Delivered element to listener.");
                    continue;
                }
                catch (PullException pullException) {
                    LOGGER.error((Object)"Error while delivering element.", (Throwable)pullException);
                    continue;
                }
                break;
            }
        }
    }
}

