/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class HttpServer {
    private static Impl registeredServer = null;
    static /* synthetic */ Class class$org$openide$util$HttpServer$Impl;
    static /* synthetic */ Class class$org$openide$util$HttpServer;

    private HttpServer() {
    }

    private static Impl getServer() throws UnknownHostException {
        Object o = Lookup.getDefault().lookup(class$org$openide$util$HttpServer$Impl == null ? (class$org$openide$util$HttpServer$Impl = HttpServer.class$("org.openide.util.HttpServer$Impl")) : class$org$openide$util$HttpServer$Impl);
        if (o != null) {
            return (Impl)o;
        }
        if (registeredServer != null) {
            return registeredServer;
        }
        throw new UnknownHostException(NbBundle.getBundle(class$org$openide$util$HttpServer == null ? (class$org$openide$util$HttpServer = HttpServer.class$("org.openide.util.HttpServer")) : class$org$openide$util$HttpServer).getString("MSG_NoServerRegistered"));
    }

    public static void registerServer(Impl server) throws SecurityException {
        if (registeredServer != null) {
            throw new SecurityException(NbBundle.getBundle(class$org$openide$util$HttpServer == null ? (class$org$openide$util$HttpServer = HttpServer.class$("org.openide.util.HttpServer")) : class$org$openide$util$HttpServer).getString("SERVER_REGISTERED"));
        }
        registeredServer = server;
    }

    public static void deregisterServer(Impl server) throws SecurityException {
        if (registeredServer == null) {
            return;
        }
        if (registeredServer != server) {
            throw new SecurityException(NbBundle.getBundle(class$org$openide$util$HttpServer == null ? (class$org$openide$util$HttpServer = HttpServer.class$("org.openide.util.HttpServer")) : class$org$openide$util$HttpServer).getString("SERVER_CANNOT_UNREGISTER"));
        }
        registeredServer = null;
    }

    public static URL getRepositoryURL(FileObject fo) throws MalformedURLException, UnknownHostException {
        return HttpServer.getServer().getRepositoryURL(fo);
    }

    public static URL getRepositoryRoot() throws MalformedURLException, UnknownHostException {
        return HttpServer.getServer().getRepositoryRoot();
    }

    public static URL getResourceURL(String resourcePath) throws MalformedURLException, UnknownHostException {
        return HttpServer.getServer().getResourceURL(resourcePath);
    }

    public static URL getResourceRoot() throws MalformedURLException, UnknownHostException {
        return HttpServer.getServer().getResourceRoot();
    }

    public static boolean allowAccess(InetAddress addr) throws UnknownHostException {
        return HttpServer.getServer().allowAccess(addr);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Impl {
        public URL getRepositoryURL(FileObject var1) throws MalformedURLException, UnknownHostException;

        public URL getRepositoryRoot() throws MalformedURLException, UnknownHostException;

        public URL getResourceURL(String var1) throws MalformedURLException, UnknownHostException;

        public URL getResourceRoot() throws MalformedURLException, UnknownHostException;

        public boolean allowAccess(InetAddress var1) throws UnknownHostException;
    }
}

