/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.text.MessageFormat;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;

public abstract class NodeTransfer {
    public static final int DND_NONE = 0;
    public static final int DND_COPY = 1;
    public static final int DND_MOVE = 2;
    public static final int DND_COPY_OR_MOVE = 3;
    public static final int DND_LINK = 0x40000000;
    public static final int DND_REFERENCE = 0x40000000;
    public static final int CLIPBOARD_COPY = 1;
    public static final int CLIPBOARD_CUT = 4;
    public static final int COPY = 1;
    public static final int MOVE = 6;
    private static final DataFlavor nodePasteFlavor = new DataFlavor("application/x-java-openide-nodepaste;class=org.openide.nodes.Node", Node.getString("LBL_nodePasteFlavor"));
    private static MessageFormat dndMimeType = new MessageFormat("application/x-java-openide-nodednd;class=org.openide.nodes.Node;mask={0}");

    private NodeTransfer() {
    }

    private static DataFlavor createDndFlavor(int actions) {
        try {
            return new DataFlavor(dndMimeType.format(new Object[]{new Integer(actions)}));
        }
        catch (ClassNotFoundException ex) {
            throw new InternalError();
        }
    }

    public static ExTransferable.Single transferable(final Node n, int actions) {
        return new ExTransferable.Single(NodeTransfer.createDndFlavor(actions)){

            public Object getData() {
                return n;
            }
        };
    }

    public static Node node(Transferable t, int action) {
        DataFlavor[] flavors = t.getTransferDataFlavors();
        if (flavors == null) {
            return null;
        }
        int len = flavors.length;
        String subtype = "x-java-openide-nodednd";
        String primary = "application";
        String mask = "mask";
        int i = 0;
        while (i < len) {
            DataFlavor df = flavors[i];
            if (df.getSubType().equals(subtype) && df.getPrimaryType().equals(primary)) {
                try {
                    int m = Integer.valueOf(df.getParameter(mask));
                    if ((m & action) != 0) {
                        return (Node)t.getTransferData(df);
                    }
                }
                catch (NumberFormatException nfe) {
                    NodeTransfer.maybeReportException(nfe);
                }
                catch (ClassCastException cce) {
                    NodeTransfer.maybeReportException(cce);
                }
                catch (IOException ioe) {
                    NodeTransfer.maybeReportException(ioe);
                }
                catch (UnsupportedFlavorException ufe) {
                    NodeTransfer.maybeReportException(ufe);
                }
            }
            ++i;
        }
        return null;
    }

    public static Node[] nodes(Transferable t, int action) {
        try {
            if (t.isDataFlavorSupported(ExTransferable.multiFlavor)) {
                MultiTransferObject mto = (MultiTransferObject)t.getTransferData(ExTransferable.multiFlavor);
                int count = mto.getCount();
                Node[] ns = new Node[count];
                boolean ok = true;
                int i = 0;
                while (i < count) {
                    Node n = NodeTransfer.node(mto.getTransferableAt(i), action);
                    if (n == null) {
                        ok = false;
                        break;
                    }
                    ns[i] = n;
                    ++i;
                }
                if (ok && count > 0) {
                    return ns;
                }
            } else {
                Node n = NodeTransfer.node(t, action);
                if (n != null) {
                    return new Node[]{n};
                }
            }
        }
        catch (ClassCastException cce) {
            NodeTransfer.maybeReportException(cce);
        }
        catch (IOException ioe) {
            NodeTransfer.maybeReportException(ioe);
        }
        catch (UnsupportedFlavorException ufe) {
            NodeTransfer.maybeReportException(ufe);
        }
        return null;
    }

    public static Node.Cookie cookie(Transferable t, int action, Class cookie) {
        Node n = NodeTransfer.node(t, action);
        return n == null ? null : n.getCookie(cookie);
    }

    public static ExTransferable.Single createPaste(final Paste paste) {
        return new ExTransferable.Single(nodePasteFlavor){

            public Object getData() {
                return paste;
            }
        };
    }

    public static Paste findPaste(Transferable t) {
        try {
            if (t.isDataFlavorSupported(nodePasteFlavor)) {
                return (Paste)t.getTransferData(nodePasteFlavor);
            }
        }
        catch (ClassCastException cce) {
            NodeTransfer.maybeReportException(cce);
        }
        catch (IOException ioe) {
            NodeTransfer.maybeReportException(ioe);
        }
        catch (UnsupportedFlavorException ufe) {
            NodeTransfer.maybeReportException(ufe);
        }
        return null;
    }

    private static void maybeReportException(Exception e) {
        ErrorManager.getDefault().notify(1, e);
    }

    public static interface Paste {
        public PasteType[] types(Node var1);
    }
}

