/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.swing.tree.TreePath;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;

public class ContextTreeView
extends TreeView {
    static final long serialVersionUID = -8282594827988436813L;

    public ContextTreeView() {
        this.tree.getSelectionModel().setSelectionMode(1);
    }

    protected boolean selectionAccept(Node[] nodes) {
        if (nodes.length == 0) {
            return true;
        }
        Node parent = nodes[0].getParentNode();
        int i = 1;
        while (i < nodes.length) {
            if (nodes[i].getParentNode() != parent) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void selectionChanged(Node[] nodes, ExplorerManager man) throws PropertyVetoException {
        if (nodes.length > 0) {
            man.setExploredContext(nodes[0]);
        }
        man.setSelectedNodes(nodes);
    }

    protected void showPath(TreePath path) {
        this.tree.makeVisible(path);
        Rectangle rect = this.tree.getPathBounds(path);
        if (rect != null) {
            rect.width += rect.x;
            rect.x = 0;
            this.tree.scrollRectToVisible(rect);
        }
        this.tree.setSelectionPath(path);
    }

    protected void showSelection(TreePath[] paths) {
        if (paths.length == 0) {
            this.tree.setSelectionPaths(new TreePath[0]);
        } else {
            this.tree.setSelectionPath(paths[0].getParentPath());
        }
    }

    protected boolean useExploredContextMenu() {
        return true;
    }

    protected NodeTreeModel createModel() {
        return new NodeTreeModel();
    }
}

