/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.swing.tree.TreePath;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;

public class BeanTreeView
extends TreeView {
    static final long serialVersionUID = 3841322840231536380L;

    void initializeTree() {
        super.initializeTree();
    }

    protected NodeTreeModel createModel() {
        return new NodeTreeModel();
    }

    protected boolean selectionAccept(Node[] nodes) {
        return true;
    }

    protected void showSelection(TreePath[] treePaths) {
        this.tree.getSelectionModel().setSelectionPaths(treePaths);
        if (treePaths.length == 1) {
            this.showPathWithoutExpansion(treePaths[0]);
        }
    }

    protected void selectionChanged(Node[] nodes, ExplorerManager em) throws PropertyVetoException {
        if (nodes.length > 0) {
            Node context = nodes[0].getParentNode();
            int i = 1;
            while (i < nodes.length) {
                if (context != nodes[i].getParentNode()) {
                    em.setSelectedNodes(nodes);
                    return;
                }
                ++i;
            }
            if (em.getRootContext().getParentNode() == context) {
                em.setExploredContextAndSelection(null, nodes);
            } else {
                em.setExploredContextAndSelection(context, nodes);
            }
        } else {
            em.setSelectedNodes(nodes);
        }
    }

    protected void showPath(TreePath path) {
        this.tree.expandPath(path);
        this.showPathWithoutExpansion(path);
    }

    private void showPathWithoutExpansion(TreePath path) {
        Rectangle rect = this.tree.getPathBounds(path);
        if (rect != null) {
            Rectangle vis = this.tree.getVisibleRect();
            if (vis != null) {
                rect.width = vis.width;
                rect.x = vis.x;
            } else {
                rect.width += rect.x;
                rect.x = 0;
            }
            this.tree.scrollRectToVisible(rect);
        }
    }

    public void setEnabled(boolean enabled) {
        this.tree.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.tree.isEnabled();
    }
}

