/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.util.WeakListener;

public class DefaultPropertyModel
implements ExPropertyModel,
PropertyChangeListener {
    private Object bean;
    private String propertyName;
    private PropertyChangeSupport support;
    private PropertyDescriptor prop;
    private Method readMethod;
    private Method writeMethod;
    private Class propertyTypeClass;
    private boolean donotfire = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    public DefaultPropertyModel(Object bean, String propertyName) throws IllegalArgumentException {
        this(bean, DefaultPropertyModel.findInfo(bean, propertyName));
    }

    public DefaultPropertyModel(Object bean, PropertyDescriptor descr) {
        this.bean = bean;
        this.propertyName = descr.getName();
        this.support = new PropertyChangeSupport(this);
        this.prop = descr;
        this.propertyTypeClass = descr.getPropertyType();
        this.readMethod = descr.getReadMethod();
        this.writeMethod = descr.getWriteMethod();
        try {
            try {
                Method addList = bean.getClass().getMethod("addPropertyChangeListener", class$java$lang$String == null ? (class$java$lang$String = DefaultPropertyModel.class$("java.lang.String")) : class$java$lang$String, class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = DefaultPropertyModel.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener);
                addList.invoke(bean, this.propertyName, WeakListener.propertyChange(this, bean));
            }
            catch (NoSuchMethodException nsme) {
                try {
                    Method addList = bean.getClass().getMethod("addPropertyChangeListener", class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = DefaultPropertyModel.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener);
                    addList.invoke(bean, WeakListener.propertyChange(this, bean));
                }
                catch (NoSuchMethodException nosme) {}
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, e);
        }
    }

    private static PropertyDescriptor findInfo(Object bean, String name) throws IllegalArgumentException {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] descr = beanInfo.getPropertyDescriptors();
            int i = 0;
            while (i < descr.length) {
                if (descr[i].getName().equals(name)) {
                    return descr[i];
                }
                ++i;
            }
            throw new IllegalArgumentException("No property named " + name + " in class " + bean.getClass());
        }
        catch (IntrospectionException e) {
            IllegalArgumentException newEx = new IllegalArgumentException();
            ErrorManager.getDefault().annotate((Throwable)newEx, e);
            throw newEx;
        }
    }

    public Class getPropertyType() {
        return this.propertyTypeClass;
    }

    public Object getValue() throws InvocationTargetException {
        try {
            return this.readMethod == null ? null : this.readMethod.invoke(this.bean, new Object[0]);
        }
        catch (IllegalAccessException e) {
            ErrorManager.getDefault().notify(1, e);
            throw new InvocationTargetException(e);
        }
    }

    public void setValue(Object v) throws InvocationTargetException {
        try {
            if (this.writeMethod != null) {
                this.donotfire = true;
                this.writeMethod.invoke(this.bean, v);
                this.donotfire = false;
            }
        }
        catch (IllegalAccessException e) {
            ErrorManager.getDefault().notify(1, e);
            throw new InvocationTargetException(e);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.propertyName.equals(evt.getPropertyName()) && !this.donotfire) {
            this.support.firePropertyChange("value", evt.getOldValue(), evt.getNewValue());
        }
    }

    public Class getPropertyEditorClass() {
        return this.prop.getPropertyEditorClass();
    }

    public Object[] getBeans() {
        return new Object[]{this.bean};
    }

    public FeatureDescriptor getFeatureDescriptor() {
        return this.prop;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

