/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openide.actions.ActionManager;
import org.openide.awt.JInlineMenu;
import org.openide.awt.JMenuPlus;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class ToolsAction
extends SystemAction
implements ContextAwareAction,
Presenter.Menu,
Presenter.Popup {
    static final long serialVersionUID = 4906417339959070129L;
    private static G gl;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$ActionManager;

    private static synchronized G gl() {
        if (gl == null) {
            gl = new G();
        }
        return gl;
    }

    public String getName() {
        return ToolsAction.getActionName();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = ToolsAction.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction);
    }

    public JMenuItem getMenuPresenter() {
        return new Inline(this);
    }

    public JMenuItem getPopupPresenter() {
        return new Popup(this);
    }

    public void actionPerformed(ActionEvent ev) {
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new DelegateAction(this, actionContext);
    }

    private static String getActionName() {
        return NbBundle.getMessage(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = ToolsAction.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction, "CTL_Tools");
    }

    private static List generate(Action toolsAction, boolean forMenu) {
        ActionManager am = (ActionManager)Lookup.getDefault().lookup(class$org$openide$actions$ActionManager == null ? (class$org$openide$actions$ActionManager = ToolsAction.class$("org.openide.actions.ActionManager")) : class$org$openide$actions$ActionManager);
        SystemAction[] actions = am.getContextActions();
        ArrayList<JMenuItem> list = new ArrayList<JMenuItem>(actions.length);
        boolean separator = false;
        boolean firstItemAdded = false;
        Lookup lookup = toolsAction instanceof Lookup.Provider ? ((Lookup.Provider)((Object)toolsAction)).getLookup() : null;
        int i = 0;
        while (i < actions.length) {
            JMenuItem mi;
            Action a = lookup != null && actions[i] instanceof ContextAwareAction ? ((ContextAwareAction)((Object)actions[i])).createContextAwareInstance(lookup) : actions[i];
            if (a == null) {
                if (firstItemAdded) {
                    separator = true;
                }
            } else if (forMenu) {
                if (a instanceof Presenter.Menu && a.isEnabled()) {
                    if (separator) {
                        list.add(null);
                        separator = false;
                    }
                    mi = ((Presenter.Menu)((Object)a)).getMenuPresenter();
                    list.add(mi);
                    firstItemAdded = true;
                }
            } else if (a instanceof Presenter.Popup && a.isEnabled()) {
                if (separator) {
                    list.add(null);
                    separator = false;
                }
                mi = ((Presenter.Popup)((Object)a)).getPopupPresenter();
                list.add(mi);
                firstItemAdded = true;
            }
            ++i;
        }
        return list;
    }

    public static void setModel(Model m) {
        throw new SecurityException();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class DelegateAction
    implements Action,
    Presenter.Menu,
    Presenter.Popup,
    Lookup.Provider {
        private ToolsAction delegate;
        private Lookup lookup;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);

        public DelegateAction(ToolsAction delegate, Lookup actionContext) {
            this.delegate = delegate;
            this.lookup = actionContext;
        }

        public String toString() {
            return super.toString() + "[delegate=" + this.delegate + "]";
        }

        public Lookup getLookup() {
            return this.lookup;
        }

        public void actionPerformed(ActionEvent e) {
        }

        public void putValue(String key, Object o) {
        }

        public Object getValue(String key) {
            return this.delegate.getValue(key);
        }

        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }

        public void setEnabled(boolean b) {
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }

        public JMenuItem getMenuPresenter() {
            return new Inline(this);
        }

        public JMenuItem getPopupPresenter() {
            return new Popup(this);
        }
    }

    private static class G
    implements PropertyChangeListener {
        private int timestamp = 1;
        private SystemAction[] actions = null;
        private PropertyChangeSupport supp = new PropertyChangeSupport(this);
        public static final String PROP_STATE = "actionsState";
        static /* synthetic */ Class class$org$openide$actions$ActionManager;

        public G() {
            ActionManager am = (ActionManager)Lookup.getDefault().lookup(class$org$openide$actions$ActionManager == null ? (class$org$openide$actions$ActionManager = G.class$("org.openide.actions.ActionManager")) : class$org$openide$actions$ActionManager);
            am.addPropertyChangeListener(this);
            this.actionsListChanged();
        }

        public final void addPropertyChangeListener(PropertyChangeListener listener) {
            this.supp.addPropertyChangeListener(listener);
        }

        public final void removePropertyChangeListener(PropertyChangeListener listener) {
            this.supp.removePropertyChangeListener(listener);
        }

        protected final void firePropertyChange(String name, Object o, Object n) {
            this.supp.firePropertyChange(name, o, n);
        }

        private void actionsListChanged() {
            ++this.timestamp;
            SystemAction[] copy = this.actions;
            if (copy != null) {
                int i = 0;
                while (i < copy.length) {
                    SystemAction act = copy[i];
                    if (act != null) {
                        act.removePropertyChangeListener(this);
                    }
                    ++i;
                }
            }
            ActionManager am = (ActionManager)Lookup.getDefault().lookup(class$org$openide$actions$ActionManager == null ? (class$org$openide$actions$ActionManager = G.class$("org.openide.actions.ActionManager")) : class$org$openide$actions$ActionManager);
            copy = am.getContextActions();
            int i = 0;
            while (i < copy.length) {
                SystemAction act = copy[i];
                if (act != null) {
                    act.addPropertyChangeListener(this);
                }
                ++i;
            }
            this.actions = copy;
            this.firePropertyChange(PROP_STATE, null, null);
        }

        private void actionStateChanged() {
            ++this.timestamp;
            this.firePropertyChange(PROP_STATE, null, null);
        }

        public void propertyChange(PropertyChangeEvent ev) {
            String prop = ev.getPropertyName();
            if (prop == null || prop.equals("contextActions")) {
                this.actionsListChanged();
            } else if (prop.equals("enabled")) {
                this.actionStateChanged();
            }
        }

        private boolean isPopupEnabled(Action toolsAction) {
            boolean en = false;
            SystemAction[] copy = this.actions;
            Lookup lookup = toolsAction instanceof Lookup.Provider ? ((Lookup.Provider)((Object)toolsAction)).getLookup() : null;
            int i = 0;
            while (i < copy.length) {
                Action act = lookup != null && copy[i] instanceof ContextAwareAction ? ((ContextAwareAction)((Object)copy[i])).createContextAwareInstance(lookup) : copy[i];
                if (act instanceof Presenter.Popup && act.isEnabled()) {
                    en = true;
                    break;
                }
                ++i;
            }
            return en;
        }

        private int getTimestamp() {
            return this.timestamp;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static interface Model {
        public SystemAction[] getActions();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }

    private static final class Popup
    extends JInlineMenu
    implements Runnable {
        static final long serialVersionUID = 2269006599727576059L;
        private JMenu menu = new MyMenu();
        private boolean inited = false;
        private Action toolsAction;
        static /* synthetic */ Class class$org$openide$actions$ToolsAction;

        public Popup(Action toolsAction) {
            this.toolsAction = toolsAction;
            HelpCtx.setHelpIDString(this.menu, (class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = Popup.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction).getName());
            this.putClientProperty("hack.preShowUpdater", this);
        }

        public void addNotify() {
            if (!this.inited) {
                SwingUtilities.invokeLater(this);
            }
            super.addNotify();
        }

        public void run() {
            if (!this.inited) {
                JMenuItem[] jMenuItemArray;
                if (ToolsAction.gl().isPopupEnabled(this.toolsAction)) {
                    JMenuItem[] jMenuItemArray2 = new JMenuItem[1];
                    jMenuItemArray = jMenuItemArray2;
                    jMenuItemArray2[0] = this.menu;
                } else {
                    jMenuItemArray = new JMenuItem[]{};
                }
                this.setMenuItems(jMenuItemArray);
                this.inited = true;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private class MyMenu
        extends JMenuPlus
        implements PopupMenuListener {
            private JPopupMenu lastPopup = null;
            static /* synthetic */ Class class$org$openide$actions$ToolsAction;

            MyMenu() {
                super(ToolsAction.getActionName());
            }

            public JPopupMenu getPopupMenu() {
                JPopupMenu popup = super.getPopupMenu();
                this.fillSubmenu(popup);
                return popup;
            }

            private void fillSubmenu(JPopupMenu pop) {
                if (this.lastPopup == null) {
                    pop.addPopupMenuListener(this);
                    this.lastPopup = pop;
                    this.removeAll();
                    Iterator it = ToolsAction.generate(Popup.this.toolsAction, false).iterator();
                    while (it.hasNext()) {
                        Component item = (Component)it.next();
                        if (item == null) {
                            this.addSeparator();
                            continue;
                        }
                        this.add(item);
                    }
                    if (this.getMenuComponentCount() == 0) {
                        JMenuItem empty = new JMenuItem(NbBundle.getMessage(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = MyMenu.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction, "CTL_EmptySubMenu"));
                        empty.setEnabled(false);
                        this.add(empty);
                    }
                }
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                this.lastPopup.removePopupMenuListener(this);
                this.lastPopup = null;
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }
    }

    private static final class Inline
    extends JInlineMenu
    implements PropertyChangeListener,
    Runnable {
        static final long serialVersionUID = 2269006599727576059L;
        private int timestamp = 0;
        private Action toolsAction;

        Inline(Action toolsAction) {
            this.toolsAction = toolsAction;
            this.putClientProperty("hack.preShowUpdater", this);
        }

        public void addNotify() {
            if (this.timestamp != ToolsAction.gl().getTimestamp()) {
                SwingUtilities.invokeLater(this);
            }
            ToolsAction.gl().addPropertyChangeListener(this);
            super.addNotify();
        }

        public void removeNotify() {
            ToolsAction.gl().removePropertyChangeListener(this);
            super.removeNotify();
        }

        public void propertyChange(PropertyChangeEvent ev) {
            String prop = ev.getPropertyName();
            if (prop == null || prop.equals("actionsState")) {
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            if (this.timestamp == ToolsAction.gl().getTimestamp()) {
                return;
            }
            List l = ToolsAction.generate(this.toolsAction, true);
            this.setMenuItems(l.toArray(new JMenuItem[l.size()]));
            this.timestamp = ToolsAction.gl().getTimestamp();
        }
    }
}

