/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.alarmArchiver;

import alma.ArchiveIdentifierError.wrappers.AcsJIdentifierUnexpectedEx;
import alma.ArchiveIdentifierError.wrappers.AcsJRangeExhaustedEx;
import alma.acs.component.ComponentImplBase;
import alma.acs.component.ComponentLifecycleException;
import alma.acs.container.ContainerServices;
import alma.acs.container.ContainerServicesBase;
import alma.acs.container.archive.Range;
import alma.acsErrTypeAlarmSourceFactory.ACSASFactoryNotInitedEx;
import alma.acsErrTypeAlarmSourceFactory.FaultStateCreationErrorEx;
import alma.acsErrTypeAlarmSourceFactory.SourceCreationErrorEx;
import alma.alarmsystem.clients.SourceClient;
import alma.alarmsystem.clients.source.SourceListener;
import alma.alarmsystem.source.ACSAlarmSystemInterface;
import alma.alarmsystem.source.ACSAlarmSystemInterfaceFactory;
import alma.alarmsystem.source.ACSFaultState;
import alma.archive.database.interfaces.IdentifierManager;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.access.PermissionDeniedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.EntityExistsException;
import alma.archive.exceptions.general.UnknownSchemaException;
import alma.archive.exceptions.syntax.MalformedPermissionsException;
import alma.archive.exceptions.syntax.MalformedURIException;
import alma.archive.exceptions.syntax.MalformedXMLException;
import alma.archive.exceptions.user.UserDoesNotExistException;
import alma.archive.wrappers.Permissions;
import alma.xmlstore.AlarmArchiverOperations;
import cern.laser.source.alarmsysteminterface.FaultState;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Logger;

public class AlarmArchiver
extends ComponentImplBase
implements AlarmArchiverOperations {
    ContainerServices cs;
    SourceClient alarmSourceClient;
    AlarmListener alarmListener;
    InternalIF xmlStore;
    String schema = "ASIMessage";
    URI schemaURI = null;
    final String myName = "ARCHIVE_ALARM_ARCHIVER";
    private Range range;
    private IdentifierManager ident;

    public void initialize(ContainerServices containerServices) throws ComponentLifecycleException {
        super.initialize(containerServices);
        this.cs = containerServices;
        this.m_logger = this.cs.getLogger();
        try {
            this.xmlStore = InternalIFFactory.getInternalIF((Logger)this.m_logger);
        }
        catch (Exception exception) {
            this.m_logger.severe("Could not retrieve interface to Oracle, aborting:\n" + exception);
            throw new ComponentLifecycleException((Throwable)exception);
        }
        try {
            this.schemaURI = this.xmlStore.getSchemaManager("ARCHIVE_ALARM_ARCHIVER").getSchemaURI(this.schema);
        }
        catch (DatabaseException databaseException) {
            this.m_logger.severe("Could not retrieve UID for schema " + this.schema);
            throw new ComponentLifecycleException(databaseException.toString());
        }
        catch (UnknownSchemaException unknownSchemaException) {
            this.m_logger.severe("Could find Alarm schema " + this.schema);
            throw new ComponentLifecycleException(unknownSchemaException.toString());
        }
        catch (PermissionDeniedException permissionDeniedException) {
            this.m_logger.severe("No sufficient permissions for reading schema " + this.schema);
            throw new ComponentLifecycleException(permissionDeniedException.toString());
        }
        catch (UserDoesNotExistException userDoesNotExistException) {
            this.m_logger.severe("AlarmArchiver uses unknown user ARCHIVE_ALARM_ARCHIVER");
            throw new ComponentLifecycleException(userDoesNotExistException.toString());
        }
        catch (ModuleCriticalException moduleCriticalException) {
            this.m_logger.severe("Severe problems in initializing AlarmArchiver (while retrieving internal IF) " + moduleCriticalException.toString());
            throw new ComponentLifecycleException(moduleCriticalException.getCause().toString());
        }
        catch (ArchiveException archiveException) {
            this.m_logger.severe("Severe problems in initializing AlarmArchiver (while retrieving internal IF) " + archiveException.toString());
            throw new ComponentLifecycleException(archiveException.toString());
        }
        try {
            this.ident = InternalIFFactory.getIdentifierManager((Logger)this.m_logger);
        }
        catch (Exception exception) {
            this.m_logger.severe("Could not retrieve Identifier Manager, aborting");
            throw new ComponentLifecycleException((Throwable)exception);
        }
        try {
            this.range = new Range(this.ident.getNewRange());
        }
        catch (Exception exception) {
            this.m_logger.severe("Could not retrieve new Range from Identifier Manager, aborting");
            throw new ComponentLifecycleException((Throwable)exception);
        }
        this.alarmListener = new AlarmListener();
        try {
            this.alarmSourceClient = new SourceClient(this.cs);
            this.alarmSourceClient.connect();
            this.alarmSourceClient.addAlarmListener((SourceListener)this.alarmListener);
        }
        catch (Exception exception) {
            throw new ComponentLifecycleException((Throwable)exception);
        }
    }

    public void cleanUp() {
        this.alarmSourceClient.close();
    }

    public void triggerTestAlarms() {
        try {
            ACSAlarmSystemInterfaceFactory.init((ContainerServicesBase)this.m_containerServices);
            this.m_logger.severe("TESTING...");
            this.send_alarm("Backend", "NGAS", 1, "ACTIVE");
            this.send_alarm("Backend", "Oracle", 1, "ACTIVE");
            this.send_alarm("Backend", "NGAS", 1, "TERMINATE");
            this.send_alarm("Backend", "NGAS", 1, "ACTIVE");
            this.send_alarm("Backend", "Oracle", 1, "TERMINATE");
            this.send_alarm("Backend", "NGAS", 1, "TERMINATE");
            this.send_alarm("Backend", "Oracle", 1, "ACTIVE");
            this.send_alarm("Backend", "NGAS", 1, "ACTIVE");
            this.send_alarm("Backend", "NGAS", 1, "ACTIVE");
            this.send_alarm("Backend", "Oracle", 1, "TERMINATE");
        }
        catch (Throwable throwable) {
            this.m_logger.severe("TEST ERROR when raising alarm: " + throwable);
        }
    }

    private void send_alarm(String string, String string2, int n, String string3) throws ACSASFactoryNotInitedEx, SourceCreationErrorEx, FaultStateCreationErrorEx {
        this.m_logger.severe("1");
        ACSAlarmSystemInterface aCSAlarmSystemInterface = ACSAlarmSystemInterfaceFactory.createSource((String)"ARCHIVE_ALARM_ARCHIVER_TEST");
        this.m_logger.severe("2");
        ACSFaultState aCSFaultState = ACSAlarmSystemInterfaceFactory.createFaultState((String)string, (String)string2, (int)n);
        this.m_logger.severe("3");
        aCSFaultState.setDescriptor(string3);
        this.m_logger.severe("4");
        aCSFaultState.setUserTimestamp(new Timestamp(System.currentTimeMillis()));
        this.m_logger.severe("5");
        Properties properties = new Properties();
        this.m_logger.severe("6");
        properties.setProperty("ASI_PREFIX", "prefix");
        this.m_logger.severe("7");
        properties.setProperty("ASI_SUFFIX", "suffix");
        this.m_logger.severe("8");
        aCSFaultState.setUserProperties(properties);
        this.m_logger.severe("9");
        aCSAlarmSystemInterface.push(aCSFaultState);
        this.m_logger.severe("10");
    }

    class AlarmListener
    implements SourceListener {
        AlarmListener() {
        }

        public void faultStateReceived(FaultState faultState) {
        }

        public void sourceXMLMsgReceived(String string) {
            AlarmArchiver.this.m_logger.info("Received alarm, storing: " + string);
            if (!AlarmArchiver.this.range.hasNextID()) {
                try {
                    AlarmArchiver.this.range = new Range(AlarmArchiver.this.ident.getNewRange());
                }
                catch (Exception exception) {
                    AlarmArchiver.this.m_logger.severe("Could not retrieve new Range from Identifier Manager, this alarm is not stored: " + string);
                }
            }
            try {
                AlarmArchiver.this.xmlStore.store(AlarmArchiver.this.range.next(), string, AlarmArchiver.this.schemaURI, AlarmArchiver.this.schema, "ARCHIVE_ALARM_ARCHIVER", new Permissions(), "ARCHIVE_ALARM_ARCHIVER", true);
            }
            catch (DatabaseException databaseException) {
                AlarmArchiver.this.m_logger.warning("Could not store alarm in DB: " + string + "\n" + (Object)((Object)databaseException));
            }
            catch (MalformedURIException malformedURIException) {
                AlarmArchiver.this.m_logger.warning("Identifier returned invalid UID. Could not store alarm in DB: " + string + "\n" + (Object)((Object)malformedURIException));
            }
            catch (MalformedXMLException malformedXMLException) {
                AlarmArchiver.this.m_logger.warning("Malformed alarm message. Could not store alarm in DB: " + string + "\n" + (Object)((Object)malformedXMLException));
            }
            catch (EntityExistsException entityExistsException) {
                AlarmArchiver.this.m_logger.warning("UID already occupied (Should not happen). Could not store alarm in DB: " + string + "\n" + (Object)((Object)entityExistsException));
            }
            catch (UnknownSchemaException unknownSchemaException) {
                AlarmArchiver.this.m_logger.warning("Schema " + AlarmArchiver.this.schemaURI + " does not exist (Should not happen). Could not store alarm in DB: " + string + "\n" + (Object)((Object)unknownSchemaException));
            }
            catch (UserDoesNotExistException userDoesNotExistException) {
                AlarmArchiver.this.m_logger.warning("User ARCHIVE_ALARM_ARCHIVER does not exist. Could not store alarm in DB: " + string + "\n" + (Object)((Object)userDoesNotExistException));
            }
            catch (MalformedPermissionsException malformedPermissionsException) {
                AlarmArchiver.this.m_logger.warning("Bad permission string. Could not store alarm in DB: " + string + "\n" + (Object)((Object)malformedPermissionsException));
            }
            catch (AcsJIdentifierUnexpectedEx acsJIdentifierUnexpectedEx) {
                AlarmArchiver.this.m_logger.warning("Could not store alarm in DB: " + string + "\n" + (Object)((Object)acsJIdentifierUnexpectedEx));
            }
            catch (AcsJRangeExhaustedEx acsJRangeExhaustedEx) {
                AlarmArchiver.this.m_logger.warning("UID range exhausted (should not happen). Could not store alarm in DB: " + string + "\n" + (Object)((Object)acsJRangeExhaustedEx));
            }
            catch (ModuleCriticalException moduleCriticalException) {
                AlarmArchiver.this.m_logger.warning("Could not store alarm in DB: " + string + "\n" + (Object)((Object)moduleCriticalException));
            }
            catch (ArchiveException archiveException) {
                AlarmArchiver.this.m_logger.warning("Could not store alarm in DB: " + string + "\n" + (Object)((Object)archiveException));
            }
        }
    }
}

