/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.windows;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openide.util.WeakListener;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class WorkspaceSwitchListenerSupport
implements PropertyChangeListener {
    private final Workspace myWorkspace;
    private final boolean mineOnly;
    private boolean listening;
    private final Object listeningLock = new Object();

    protected WorkspaceSwitchListenerSupport() {
        this(null, false);
    }

    protected WorkspaceSwitchListenerSupport(Workspace workspace, boolean bl) {
        this.myWorkspace = workspace;
        this.mineOnly = bl;
        this.startListening();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListening() {
        if (this.listening) {
            Object object = this.listeningLock;
            synchronized (object) {
                if (this.listening) {
                    WindowManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                    this.listening = !this.listening;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListening() {
        if (!this.listening) {
            Object object = this.listeningLock;
            synchronized (object) {
                if (!this.listening) {
                    PropertyChangeListener propertyChangeListener = WeakListener.propertyChange((PropertyChangeListener)this, (Object)WindowManager.getDefault());
                    WindowManager.getDefault().addPropertyChangeListener(propertyChangeListener);
                    this.listening = !this.listening;
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!"currentWorkspace".equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        if (!this.mineOnly) {
            this.workspaceExited((Workspace)propertyChangeEvent.getOldValue());
            this.workspaceEntered((Workspace)propertyChangeEvent.getNewValue());
        }
        if (this.myWorkspace != null) {
            if (this.myWorkspace == propertyChangeEvent.getOldValue()) {
                this.myWorkspaceExited();
            } else if (this.myWorkspace == propertyChangeEvent.getNewValue()) {
                this.myWorkspaceEntered();
            }
        }
    }

    protected void workspaceEntered(Workspace workspace) {
    }

    protected void workspaceExited(Workspace workspace) {
    }

    protected void myWorkspaceEntered() {
    }

    protected void myWorkspaceExited() {
    }
}

