/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.windows;

import cern.gp.util.Assertion;
import cern.gp.util.GPManager;
import java.awt.Container;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class WindowUtils {
    public static final int INTERNAL_FRAME = 0;
    public static final int TOP_FRAME = 1;
    public static final int DESKTOP_FRAME = 2;
    private static final String INTERNAL_FRAME_STRING = "INTERNAL_FRAME";
    private static final String TOP_FRAME_STRING = "TOP_FRAME";
    private static final String DESKTOP_FRAME_STRING = "DESKTOP_FRAME";
    private static final String CONSTRAINT_WEST = "WEST";
    public static final int PERSIST_ONLY_OPENED = 1;
    public static final int PERSIST_NEVER = 0;
    public static final int PERSIST_ALWAYS = 2;
    public static final int PERSIST_UNKNOWN = -1;
    private static final String PERSISTENCE_TYPE = "PersistenceType";
    private static final String PERSIST_NEVER_STR = "Never";
    private static final String PERSIST_ONLY_OPENED_STR = "OnlyOpened";
    private static final String PERSIST_ALWAYS_STR = null;
    private static int defaultFrameType = 0;
    private static String[] possibleFrameTypes = new String[]{"INTERNAL_FRAME", "TOP_FRAME", "DESKTOP_FRAME"};
    private static Log log = LogFactory.getLog(WindowUtils.class);

    private WindowUtils() {
    }

    public static void setFrameType(int n) {
        defaultFrameType = n;
    }

    public static Mode openInMode(TopComponent topComponent, String string) {
        Workspace workspace = WindowManager.getDefault().getCurrentWorkspace();
        return WindowUtils.openInMode(workspace, topComponent, string, defaultFrameType);
    }

    public static Mode openInMode(Workspace workspace, TopComponent topComponent, String string) {
        return WindowUtils.openInMode(workspace, topComponent, string, defaultFrameType);
    }

    public static Mode openInMode(TopComponent topComponent, String string, int n) {
        Workspace workspace = WindowManager.getDefault().getCurrentWorkspace();
        return WindowUtils.openInMode(workspace, topComponent, string, n);
    }

    public static Mode openInMode(Workspace workspace, TopComponent topComponent, String string, int n) {
        Assertion.assertTrue(workspace != null, "workspace != null");
        Assertion.assertTrue(topComponent != null, "component != null");
        Assertion.assertTrue(string != null, "modeName != null");
        WindowUtils.setPersistMode(topComponent, 0);
        Mode mode = workspace.findMode(string);
        if (mode == null) {
            mode = workspace.createMode(string, string, null);
        }
        mode.dockInto(topComponent);
        workspace.activate();
        WindowUtils.frameResidesInDesktop(mode, n);
        topComponent.open(workspace);
        topComponent.requestFocus();
        return mode;
    }

    public static void setPersistMode(TopComponent topComponent, int n) {
        Assertion.assertTrue(topComponent != null, "comp != null");
        Assertion.assertTrue(0 == n || 2 == n || 1 == n, "bad option: " + n);
        switch (n) {
            case 0: {
                topComponent.putClientProperty((Object)PERSISTENCE_TYPE, (Object)PERSIST_NEVER_STR);
                break;
            }
            case 2: {
                topComponent.putClientProperty((Object)PERSISTENCE_TYPE, (Object)PERSIST_ALWAYS_STR);
                break;
            }
            case 1: {
                topComponent.putClientProperty((Object)PERSISTENCE_TYPE, (Object)PERSIST_ONLY_OPENED_STR);
                break;
            }
            default: {
                throw new AssertionError((Object)("[this should not happen: wrong option " + n));
            }
        }
    }

    public static int getPersistMode(TopComponent topComponent) {
        Assertion.assertTrue(topComponent != null, "comp != null");
        String string = (String)topComponent.getClientProperty((Object)PERSISTENCE_TYPE);
        if (string == PERSIST_ALWAYS_STR) {
            return 2;
        }
        if (PERSIST_NEVER_STR.equals(string)) {
            return 0;
        }
        if (PERSIST_ONLY_OPENED_STR.equals(string)) {
            return 1;
        }
        return -1;
    }

    public static void frameResidesInDesktop(Mode mode) {
        WindowUtils.frameResidesInDesktop(mode, defaultFrameType);
    }

    public static void frameResidesInDesktop(Mode mode, int n) {
        Assertion.assertTrue(mode != null, "mode != null");
        try {
            ClassLoader classLoader = Mode.class.getClassLoader();
            Class<?> clazz = Class.forName("org.netbeans.core.windows.ModeImpl", true, classLoader);
            Method method = clazz.getMethod("getCurrentConstraints", null);
            Object object = method.invoke((Object)mode, null);
            Method method2 = clazz.getMethod("setFrameType", String.class);
            Method method3 = clazz.getMethod("setVisible", Boolean.TYPE);
            Method method4 = clazz.getMethod("isVisible", null);
            boolean bl = (Boolean)method4.invoke((Object)mode, null);
            if (n == 2) {
                object = CONSTRAINT_WEST;
            }
            Class<?> clazz2 = Class.forName("org.netbeans.core.windows.util.WindowUtils", true, classLoader);
            Method method5 = clazz2.getMethod("findConstrainedMode", Workspace.class, Object.class);
            Object object2 = method5.invoke(null, mode.getWorkspace(), object);
            String string = possibleFrameTypes[n];
            if (object2 != null && n == 2) {
                n = 0;
                string = possibleFrameTypes[n];
                object = null;
            }
            Class<?> clazz3 = Class.forName("org.netbeans.core.windows.frames.WindowTypesManager", true, classLoader);
            Field field = clazz3.getField(string);
            Method method6 = clazz2.getMethod("changeModeConstraints", clazz, Object.class);
            method6.invoke(null, mode, object);
            method2.invoke((Object)mode, field.get(clazz3));
            if (bl) {
                method3.invoke((Object)mode, Boolean.TRUE);
                Class<?> clazz4 = Class.forName("org.netbeans.core.windows.MainWindow", true, classLoader);
                Method method7 = clazz4.getMethod("getDefault", null);
                Method method8 = clazz4.getMethod("getContentPane", null);
                Container container = (Container)method8.invoke(method7.invoke(null, null), null);
                container.validate();
            }
        }
        catch (Exception exception) {
            GPManager.notify(4096, exception);
        }
    }

    public static TopComponent findTopComponent(String string) {
        Workspace workspace = WindowManager.getDefault().getCurrentWorkspace();
        return WindowUtils.findTopComponent(workspace, string);
    }

    public static TopComponent findTopComponent(Workspace workspace, String string) {
        Assertion.assertTrue(workspace != null, "workspace != null");
        Assertion.assertTrue(string != null, "componentName != null");
        for (Mode mode : workspace.getModes()) {
            TopComponent[] topComponentArray = mode.getTopComponents();
            for (int i = 0; i < topComponentArray.length; ++i) {
                TopComponent topComponent = topComponentArray[i];
                if (!topComponent.getName().equals(string)) continue;
                return topComponent;
            }
        }
        return null;
    }

    public static Workspace createWorkspace(String string, String string2) {
        Workspace workspace;
        Assertion.assertTrue(string != null, "codeName != null");
        if (string2 == null || string2.equalsIgnoreCase("")) {
            string2 = string;
        }
        Workspace[] workspaceArray = new Workspace[WindowManager.getDefault().getWorkspaces().length + 1];
        Workspace[] workspaceArray2 = WindowManager.getDefault().getWorkspaces();
        for (int i = 0; i < workspaceArray2.length; ++i) {
            workspaceArray[i] = workspaceArray2[i];
        }
        workspaceArray[i] = workspace = WindowManager.getDefault().createWorkspace(string, string2);
        WindowManager.getDefault().setWorkspaces(workspaceArray);
        return workspace;
    }

    private static boolean performDesktopFrameAction(Mode mode, TopComponent topComponent, ClassLoader classLoader, Class clazz, Class clazz2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Workspace workspace = mode.getWorkspace();
        String string = CONSTRAINT_WEST;
        Method method = clazz2.getMethod("findConstrainedMode", Workspace.class, Object.class);
        Object object = method.invoke(null, workspace, string);
        if (object != null) {
            Mode mode2 = (Mode)object;
            Method method2 = clazz.getMethod("getContainerInstance", null);
            Object object2 = method2.invoke((Object)mode, null);
            if (object2 != null) {
                Class<?> clazz3 = Class.forName("org.netbeans.core.windows.frames.TopComponentContainer", true, classLoader);
                Method method3 = clazz3.getMethod("removeTopComponent", TopComponent.class);
                method3.invoke(object2, topComponent);
                Method method4 = clazz.getMethod("dockInto", TopComponent.class, Object.class);
                method4.invoke((Object)mode2, topComponent, string);
                return true;
            }
        }
        return false;
    }
}

