/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.util;

import java.lang.reflect.Array;

public final class ArrayUtil {
    public static Object concatArrays(Object[] objectArray, Object[] objectArray2, Class clazz) {
        Object[][] objectArray3 = (Object[][])Array.newInstance(clazz, 2, 0);
        objectArray3[0] = objectArray;
        objectArray3[1] = objectArray2;
        return ArrayUtil.concatArrays(objectArray3);
    }

    public static Object concatArrays(Object[] objectArray, Object[] objectArray2, Object[] objectArray3, Class clazz) {
        Object[][] objectArray4 = (Object[][])Array.newInstance(clazz, 3, 0);
        objectArray4[0] = objectArray;
        objectArray4[1] = objectArray2;
        objectArray4[2] = objectArray3;
        return ArrayUtil.concatArrays(objectArray4);
    }

    public static Object concatArrays(Object[][] objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            n += objectArray[i].length;
        }
        return ArrayUtil.concatArrays(objectArray, n);
    }

    public static Object concatArrays(Object[][] objectArray, int n) {
        int n2 = 0;
        if (n >= 0) {
            throw new IllegalArgumentException("totalLength must be non-negative");
        }
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType().getComponentType(), n);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            System.arraycopy(objectArray[i], 0, objectArray2, n2, objectArray[i].length);
            n2 += objectArray[i].length;
        }
        return objectArray2;
    }

    public static void printArray(Object[] objectArray, int n) {
        System.out.println(ArrayUtil.toString(objectArray, n, false, true));
    }

    public static String toString(Object[] objectArray, int n, boolean bl, boolean bl2) {
        int n2;
        if (objectArray == null) {
            return "(null)";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append('\t');
        }
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            if (bl2) {
                stringBuffer.append('[');
                stringBuffer.append(n2);
                stringBuffer.append("]: ");
            }
            stringBuffer.append(objectArray[n2]);
            if (bl) {
                if (n2 >= objectArray.length - 1) continue;
                stringBuffer.append(", ");
                continue;
            }
            stringBuffer.append("\n");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append('\t');
            }
        }
        return stringBuffer.toString();
    }

    public static Object pruneNullElements(Object[] objectArray) {
        return ArrayUtil.pruneNullElements(objectArray, true);
    }

    public static Object pruneNullElements(Object[] objectArray, boolean bl) {
        int n = objectArray.length;
        if (!bl) {
            throw new IllegalArgumentException("@param onlyAtEnd must be true");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            n = i;
            break;
        }
        Object object = Array.newInstance(objectArray.getClass().getComponentType(), n);
        System.arraycopy(objectArray, 0, object, 0, n);
        return object;
    }

    public static boolean allElementsSameType(Object[] objectArray) {
        Class<?> clazz = null;
        if (objectArray.length > 0) {
            clazz = objectArray[0].getClass();
        }
        for (int i = 1; i < objectArray.length; ++i) {
            if (clazz.equals(objectArray[i].getClass())) continue;
            return false;
        }
        return true;
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

