/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.nodes.impl;

import cern.gp.beans.editors.support.BeanDependentPropertyEditor;
import cern.gp.nodes.cache.Cacheable;
import cern.gp.nodes.cache.CachingStrategy;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openide.nodes.PropertySupport;

class CacheablePropertySupport
extends PropertySupport.Reflection
implements Cacheable {
    private Object cachedValue;
    private CachingStrategy cachingStrategy;

    public CacheablePropertySupport(Object object, Class clazz, Method method, Method method2, CachingStrategy cachingStrategy) {
        super(object, clazz, method, method2);
        this.cachingStrategy = cachingStrategy;
    }

    public Object getValue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.cachingStrategy.isCacheValid()) {
            this.cachedValue = super.getValue();
            this.cachingStrategy.validateCache();
        }
        return this.cachedValue;
    }

    public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        super.setValue(object);
        this.cachedValue = object;
        this.cachingStrategy.validateCache();
    }

    public PropertyEditor getPropertyEditor() {
        PropertyEditor propertyEditor = super.getPropertyEditor();
        if (propertyEditor != null && propertyEditor instanceof BeanDependentPropertyEditor) {
            ((BeanDependentPropertyEditor)((Object)propertyEditor)).initializePropertyEditor(this.instance, this.getName());
        }
        return propertyEditor;
    }

    @Override
    public void resetCache() {
        this.cachingStrategy.invalidateCache();
    }
}

