/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.explorer.properties;

import cern.gp.explorer.properties.PropertyField;
import cern.gp.nodes.GPNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.nodes.Node;

public class ReversiblePropertyField
extends PropertyField {
    private final ReversibleModel model;

    public ReversiblePropertyField(ReversibleModel reversibleModel, Object object, String string, int n) {
        super((PropertyModel)reversibleModel, object, string, n);
        this.model = reversibleModel;
    }

    public ReversiblePropertyField(GPNode gPNode, String string, int n) {
        this(new ReversibleModel(PropertyField.getNodeProperty(gPNode.getPeerNode().getPropertySets(), string), new Object[]{gPNode.getBean()}), gPNode.getBean(), string, n);
    }

    public void commit() throws InvocationTargetException {
        this.model.commit();
    }

    public void revert() {
        this.model.revert();
    }

    static class ReversibleModel
    extends PropertyField.SimpleModel
    implements ActionListener {
        private static final String OK_EVENT = "OK";
        private Object tmpValue;

        public ReversibleModel(Node.Property property, Object[] objectArray) {
            super(property, objectArray);
        }

        @Override
        public Object getValue() throws InvocationTargetException {
            if (this.tmpValue != null) {
                return this.tmpValue;
            }
            return super.getValue();
        }

        @Override
        public void setValue(Object object) throws InvocationTargetException {
            this.tmpValue = object;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (OK_EVENT.equals(actionEvent.getActionCommand())) {
                try {
                    this.commit();
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
            } else {
                this.revert();
            }
        }

        public boolean isModified() {
            return this.tmpValue != null;
        }

        public void commit() throws InvocationTargetException {
            super.setValue(this.tmpValue);
            this.tmpValue = null;
        }

        public void revert() {
            this.tmpValue = null;
        }
    }
}

