/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.explorer.properties;

import cern.gp.beans.BeanSupport;
import cern.gp.nodes.GPNode;
import cern.gp.util.Assertion;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.nodes.Node;
import org.openide.util.WeakListener;

public class PropertyField
extends PropertyPanel {
    public static final int PREF_READ_ONLY = 1;
    public static final int PREF_CUSTOM_EDITOR = 2;
    public static final int PREF_INPUT_STATE = 4;

    public PropertyField(GPNode gPNode, String string) {
        this(gPNode, string, 4);
    }

    public PropertyField(GPNode gPNode, String string, int n) {
        this((PropertyModel)new SimpleModel(PropertyField.getNodeProperty(gPNode.getPeerNode().getPropertySets(), string), new Object[]{gPNode.getBean()}), gPNode.getBean(), string, n);
    }

    protected PropertyField(PropertyModel propertyModel, Object object, String string, int n) {
        super(propertyModel, n);
        BeanPropertyChangeListener beanPropertyChangeListener;
        if (object instanceof BeanSupport) {
            BeanSupport beanSupport = (BeanSupport)object;
            beanPropertyChangeListener = new BeanPropertyChangeListener(beanSupport, string);
        } else {
            beanPropertyChangeListener = new BeanPropertyChangeListener(object, string);
        }
        beanPropertyChangeListener.registerListener();
    }

    protected static Node.Property getNodeProperty(Node.PropertySet[] propertySetArray, String string) {
        for (int i = 0; i < propertySetArray.length; ++i) {
            Node.Property[] propertyArray = propertySetArray[i].getProperties();
            for (int j = 0; j < propertyArray.length; ++j) {
                if (!propertyArray[j].getName().equals(string)) continue;
                return propertyArray[j];
            }
        }
        throw new IllegalArgumentException("unknown property: " + string);
    }

    static class SimpleModel
    implements ExPropertyModel {
        private Node.Property prop;
        private Object[] beans;
        private PropertyChangeSupport sup = new PropertyChangeSupport(this);

        public SimpleModel(Node.Property property, Object[] objectArray) {
            this.prop = property;
            this.beans = objectArray;
        }

        public Object getValue() throws InvocationTargetException {
            try {
                return this.prop.getValue();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw this.annotateException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw this.annotateException(invocationTargetException);
            }
        }

        public void setValue(Object object) throws InvocationTargetException {
            try {
                this.prop.setValue(object);
                this.sup.firePropertyChange("value", null, null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw this.annotateException(illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this.annotateException(illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw this.annotateException(invocationTargetException);
            }
        }

        private InvocationTargetException annotateException(Exception exception) {
            if (exception instanceof InvocationTargetException) {
                return (InvocationTargetException)exception;
            }
            return new InvocationTargetException(exception);
        }

        public Class getPropertyType() {
            return this.prop.getValueType();
        }

        public Class getPropertyEditorClass() {
            PropertyEditor propertyEditor = this.prop.getPropertyEditor();
            if (propertyEditor != null) {
                return propertyEditor.getClass();
            }
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            Thread.dumpStack();
            this.sup.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.sup.removePropertyChangeListener(propertyChangeListener);
        }

        public Object[] getBeans() {
            return this.beans;
        }

        public FeatureDescriptor getFeatureDescriptor() {
            return this.prop;
        }

        void fireValueChanged() {
            this.sup.firePropertyChange("value", null, null);
        }
    }

    protected final class BeanPropertyChangeListener
    implements PropertyChangeListener {
        private final Method addPclMethod;
        private final Method remPclMethod;
        private final String propName;
        private BeanSupport source;

        protected BeanPropertyChangeListener(BeanSupport beanSupport, String string) {
            this.propName = string;
            this.source = beanSupport;
            this.addPclMethod = null;
            this.remPclMethod = null;
        }

        protected BeanPropertyChangeListener(Object object, String string) {
            this.propName = string;
            Method method = null;
            Method method2 = null;
            try {
                method = object.getClass().getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
                method2 = object.getClass().getMethod("removePropertyChangeListener", String.class, PropertyChangeListener.class);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.addPclMethod = method;
            this.remPclMethod = method2;
        }

        public void registerListener() {
            Assertion.assertTrue(this.source != null, "source != null. Maybe you called this twice?");
            PropertyChangeListener propertyChangeListener = WeakListener.propertyChange((PropertyChangeListener)this, (Object)this.source);
            if (this.addPclMethod != null) {
                try {
                    this.addPclMethod.invoke((Object)this.source, this.propName, propertyChangeListener);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.source.addPropertyChangeListener(this.propName, this);
            }
            this.source = null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (!this.propName.equals(string)) {
                System.err.println("unexpected propName: " + string);
                return;
            }
            Object object = propertyChangeEvent.getNewValue();
            if (object == null) {
                System.err.println("Null newValue not yet treated for prop " + string);
            }
            try {
                PropertyField.super.getModel().setValue(object);
                PropertyField.super.repaint();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }
}

