/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.explorer;

import cern.gp.explorer.TreeViewTreeAccess;
import cern.gp.nodes.GPNode;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JTree;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;

public class TreeExplorer
extends ExplorerPanel {
    private GPNode rootNode;
    private final TreeViewTreeAccess treeViewTreeAccess;

    public TreeExplorer() {
        this(new GPBeanTreeView());
    }

    protected TreeExplorer(TreeViewTreeAccess treeViewTreeAccess) {
        this.putClientProperty("PersistenceType", "Never");
        this.treeViewTreeAccess = treeViewTreeAccess;
        this.setLayout(new BorderLayout());
        this.add((Component)treeViewTreeAccess.getTreeView(), "Center");
    }

    public TreeViewTreeAccess getTreeAccess() {
        return this.treeViewTreeAccess;
    }

    public void setRootNode(GPNode gPNode) {
        this.rootNode = gPNode;
        this.getExplorerManager().setRootContext(gPNode.getPeerNode());
    }

    public GPNode getRootNode() {
        return this.rootNode;
    }

    public void setRowHeigth(int n) {
        this.getTreeAccess().getTree().setRowHeight(n);
    }

    public int getRowHeight() {
        return this.getTreeAccess().getTree().getRowHeight();
    }

    private static class GPBeanTreeView
    extends BeanTreeView
    implements TreeViewTreeAccess {
        @Override
        public JTree getTree() {
            return this.tree;
        }

        @Override
        public TreeView getTreeView() {
            return this;
        }
    }
}

