/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.explorer;

import cern.gp.nodes.GPNode;
import cern.gp.util.GPManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.ListView;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class MultiListExplorer
extends ExplorerPanel {
    public static final int DEFAULT_WIDTH = 600;
    public static final int DEFAULT_HEIGHT = 400;
    public static final int DEFAULT_LIST_COUNT = 4;
    private ExplorerPanel[] _explorerPanels;
    private int _listCount = 4;
    private boolean _twoRows;
    private boolean _automaticSelection = true;
    private ComponentCreator _bottomComponentCreator;
    private ComponentCreator _topComponentCreator;
    private SelectionListener _selectionListener;

    public MultiListExplorer() {
        this(null, 4, 600, 400, false);
    }

    public MultiListExplorer(SelectionListener selectionListener, int n) {
        this(selectionListener, n, 600, 400, false);
    }

    public MultiListExplorer(SelectionListener selectionListener, int n, int n2) {
        this(selectionListener, 4, n, n2, false);
    }

    public MultiListExplorer(SelectionListener selectionListener, int n, int n2, int n3, boolean bl) {
        this._listCount = n;
        this._twoRows = bl;
        if (bl && n % 2 != 0) {
            throw new IllegalArgumentException("listCount must be a multiple of 2 to be on two rows");
        }
        this._selectionListener = selectionListener;
        this.setLayout(new GridLayout(1, 1));
        this.setSize(n2, n3);
        this.setPreferredSize(new Dimension(n2, n3));
        this.putClientProperty("PersistenceType", "Never");
    }

    public void addNotify() {
        super.addNotify();
        this._explorerPanels = new ExplorerPanel[this._listCount];
        JComponent jComponent = null;
        jComponent = this._twoRows ? this.createExplorerPanelRows(this.getWidth(), this.getHeight(), this._listCount) : this.createExplorerPanelRow(this.getWidth(), this.getHeight(), this._listCount, 0, null);
        this.add(jComponent, "Center");
        if (this._automaticSelection) {
            MultiListExplorer.selectNthChildren(this.getExplorerManager(), 0);
        }
    }

    public void removeNotify() {
        this._explorerPanels = null;
        super.removeNotify();
    }

    public void setRootNode(GPNode gPNode) {
        this.getExplorerManager().setRootContext(gPNode.getPeerNode());
    }

    public ComponentCreator getTopComponentCreator() {
        return this._topComponentCreator;
    }

    public void setTopComponentCreator(ComponentCreator componentCreator) {
        this._topComponentCreator = componentCreator;
    }

    public ComponentCreator getBottomComponentCreator() {
        return this._bottomComponentCreator;
    }

    public void setBottomComponentCreator(ComponentCreator componentCreator) {
        this._bottomComponentCreator = componentCreator;
    }

    public void setListCount(int n) {
        if (this._explorerPanels != null) {
            throw new IllegalStateException("addNotify already performed");
        }
        if (n < 2) {
            throw new IllegalArgumentException("The number of list in the Explorer cannot be < 2");
        }
        this._listCount = n;
    }

    public int getListCount() {
        return this._listCount;
    }

    public void setAutomaticSelection(boolean bl) {
        this._automaticSelection = bl;
    }

    public boolean getAutomaticSelection() {
        return this._automaticSelection;
    }

    protected ExplorerManager getExplorerManager(int n) {
        if (this._explorerPanels == null) {
            throw new IllegalStateException("addNotify not yet performed");
        }
        return this._explorerPanels[n].getExplorerManager();
    }

    protected static void selectNthChildren(ExplorerManager explorerManager, int n) {
        Node node = explorerManager.getExploredContext();
        if (node == null) {
            return;
        }
        Children children = node.getChildren();
        try {
            if (children == null || children.getNodesCount() == 0) {
                explorerManager.setSelectedNodes(new Node[0]);
            } else if (n >= children.getNodesCount()) {
                explorerManager.setSelectedNodes(new Node[]{children.getNodes()[0]});
            } else {
                explorerManager.setSelectedNodes(new Node[]{children.getNodes()[n]});
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            GPManager.notify(16, propertyVetoException);
        }
    }

    private JComponent createExplorerPanelRows(int n, int n2, int n3) {
        JComponent jComponent = this.createExplorerPanelRow(n, n2 / 2, n3 / 2, n3 / 2, null);
        JComponent jComponent2 = this.createExplorerPanelRow(n, n2 / 2, n3 / 2, 0, this._explorerPanels[n3 / 2]);
        JSplitPane jSplitPane = new JSplitPane(0, jComponent2, jComponent);
        jSplitPane.setPreferredSize(new Dimension(n, n2));
        jSplitPane.setDividerLocation(n2 / 2);
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setContinuousLayout(false);
        jSplitPane.setDividerSize(3);
        return jSplitPane;
    }

    private JComponent createExplorerPanelRow(int n, int n2, int n3, int n4, ExplorerPanel explorerPanel) {
        ExplorerPanel explorerPanel2 = this.createExplorerPanel(n4 + n3 - 1, explorerPanel);
        double d = (double)(n3 - 1) / (double)n3;
        int n5 = (int)Math.round(d * (double)n);
        Object object = n3 > 2 ? this.createExplorerPanelRow(n5, n2, n3 - 1, n4, explorerPanel2) : this.createExplorerPanel(n4 + n3 - 2, explorerPanel2);
        JSplitPane jSplitPane = new JSplitPane(1, (Component)object, (Component)explorerPanel2);
        jSplitPane.setPreferredSize(new Dimension(n, n2));
        jSplitPane.setDividerLocation(n5);
        jSplitPane.setResizeWeight(d);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setContinuousLayout(false);
        jSplitPane.setDividerSize(3);
        return jSplitPane;
    }

    private ExplorerPanel createExplorerPanel(int n, ExplorerPanel explorerPanel) {
        this._explorerPanels[n] = n > 0 ? new ListExplorerPanel(n, explorerPanel) : new ListExplorerPanel(this.getExplorerManager(), n, explorerPanel);
        return this._explorerPanels[n];
    }

    private class ListSelectionListener
    implements PropertyChangeListener {
        private int index;

        public ListSelectionListener(int n) {
            this.index = n;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("selectedNodes")) {
                Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                MultiListExplorer.this._selectionListener.selectionChanged(this.index, nodeArray);
            }
        }
    }

    private class ListExplorerPanel
    extends ExplorerPanel {
        private PropertyChangeListener nextListSelectionListener;
        private PropertyChangeListener listSelectionListener;

        public ListExplorerPanel(int n, ExplorerPanel explorerPanel) {
            this.initialize(n, explorerPanel);
        }

        public ListExplorerPanel(ExplorerManager explorerManager, int n, ExplorerPanel explorerPanel) {
            super(explorerManager);
            this.initialize(n, explorerPanel);
        }

        private void initialize(int n, ExplorerPanel explorerPanel) {
            JComponent jComponent;
            this.setName("List" + n);
            ListView listView = new ListView();
            listView.setSelectionMode(0);
            listView.setPopupAllowed(true);
            this.add((Component)listView, "Center");
            if (MultiListExplorer.this._topComponentCreator != null && (jComponent = MultiListExplorer.this._topComponentCreator.createComponent(n)) != null) {
                this.add(jComponent, "North");
            }
            if (MultiListExplorer.this._bottomComponentCreator != null && (jComponent = MultiListExplorer.this._bottomComponentCreator.createComponent(n)) != null) {
                this.add(jComponent, "South");
            }
            if (explorerPanel != null) {
                this.nextListSelectionListener = new NextListSelectionListener(this, explorerPanel);
                this.getExplorerManager().addPropertyChangeListener(this.nextListSelectionListener);
            }
            if (MultiListExplorer.this._selectionListener != null) {
                this.listSelectionListener = new ListSelectionListener(n);
                this.getExplorerManager().addPropertyChangeListener(this.listSelectionListener);
            }
        }

        public void addNotify() {
            super.addNotify();
        }

        public void removeNotify() {
            if (this.nextListSelectionListener != null) {
                this.getExplorerManager().removePropertyChangeListener(this.nextListSelectionListener);
            }
            if (this.listSelectionListener != null) {
                this.getExplorerManager().removePropertyChangeListener(this.listSelectionListener);
            }
            super.removeNotify();
        }
    }

    private class NextListSelectionListener
    implements PropertyChangeListener {
        private ExplorerManager sourceManager;
        private ExplorerManager targetManager;
        private String name;
        private boolean shouldUpdateSelection;

        public NextListSelectionListener(ExplorerPanel explorerPanel, ExplorerPanel explorerPanel2) {
            this.sourceManager = explorerPanel.getExplorerManager();
            this.targetManager = explorerPanel2.getExplorerManager();
            this.name = explorerPanel.getName();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("selectedNodes")) {
                this.updateTargetPanel();
                if (this.shouldUpdateSelection) {
                    this.shouldUpdateSelection = false;
                    MultiListExplorer.selectNthChildren(this.sourceManager, 0);
                }
            } else if (string.equals("exploredContext")) {
                Node node;
                Node node2;
                Object object = propertyChangeEvent.getOldValue();
                if (object != null && object instanceof Node && !(node2 = (Node)object).equals(node = this.sourceManager.getExploredContext())) {
                    this.shouldUpdateSelection = MultiListExplorer.this._automaticSelection;
                }
            } else if (string.equals("nodeChange") || string.equals("rootContext")) {
                // empty if block
            }
        }

        private void updateTargetPanel() {
            Node[] nodeArray = this.sourceManager.getSelectedNodes();
            if (nodeArray == null || nodeArray.length == 0) {
                this.targetManager.setRootContext(Node.EMPTY);
                return;
            }
            Node node = nodeArray[0];
            this.targetManager.setRootContext(node);
            if (MultiListExplorer.this._automaticSelection) {
                MultiListExplorer.selectNthChildren(this.targetManager, 0);
            }
        }
    }

    public static interface ComponentCreator {
        public JComponent createComponent(int var1);
    }

    public static interface SelectionListener {
        public void selectionChanged(int var1, Node[] var2);
    }
}

