/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.explorer;

import cern.gp.explorer.GPListExplorerPanel;
import cern.gp.explorer.NamedBean;
import cern.gp.explorer.TableHolder;
import cern.gp.explorer.TableHolderImpl;
import cern.gp.explorer.TablePropertyHolder;
import cern.gp.explorer.TreeTableViewTableAccess;
import cern.gp.nodes.GPNode;
import cern.gp.nodes.impl.NodeUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.IntrospectionException;
import javax.swing.JTable;
import javax.swing.JTree;
import org.openide.explorer.view.NodeTableModel;
import org.openide.explorer.view.TreeTableView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;

public class ListTableExplorer
extends GPListExplorerPanel
implements TableHolder,
TablePropertyHolder {
    private static final String ATTR_COMPARABLE_COLUMN = "ComparableColumnTTV";
    private static final String ATTR_SORTING_COLUMN = "SortingColumnTTV";
    private static final String ATTR_DESCENDING_ORDER = "DescendingOrderTTV";
    private final TableHolder tableHolder;
    private GPNode beanNode;
    private String[] tableColumnNames;
    private final TreeTableViewTableAccess treeTableViewTableAccess;

    public ListTableExplorer() {
        this(new GPTreeTableView());
    }

    public ListTableExplorer(GPNode[] gPNodeArray) {
        this();
        this.setListNodes(gPNodeArray);
    }

    protected ListTableExplorer(TreeTableViewTableAccess treeTableViewTableAccess) {
        this.treeTableViewTableAccess = treeTableViewTableAccess;
        this.setLayout(new BorderLayout());
        this.add((Component)treeTableViewTableAccess.getTreeTableView(), "Center");
        this.tableHolder = new TableHolderImpl(this);
    }

    public ListTableExplorer(Class clazz) {
        this(new Class[]{clazz});
    }

    public ListTableExplorer(Class[] classArray) {
        this(new GPTreeTableView(new TableHolderImpl.SelectiveTableModel(classArray)));
    }

    public TreeTableViewTableAccess getTreeTableAccess() {
        return this.treeTableViewTableAccess;
    }

    @Override
    public final void setListNodes(GPNode[] gPNodeArray) {
        if (gPNodeArray.length <= 0) {
            return;
        }
        this.beanNode = gPNodeArray[0];
        boolean bl = !this.areAllNodesLeaves(gPNodeArray);
        try {
            GPNode[] gPNodeArray2 = bl ? NodeUtils.copyToNewGPNodeArray(gPNodeArray) : gPNodeArray;
            NamedBean namedBean = new NamedBean("");
            this.setRootBean(namedBean);
            this.setRootNode(ListTableExplorer.createRootNode(namedBean, gPNodeArray2));
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
            return;
        }
        try {
            this.setTableColumns(this.beanNode);
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
            return;
        }
    }

    @Override
    public void setRootNode(GPNode gPNode) {
        super.setRootNode(gPNode);
        this.getTreeTableAccess().getTreeTableView().setRootVisible(false);
        this.setTableColumns(gPNode, null);
    }

    public void setPreferredSize(Dimension dimension) {
        this.getTreeTableAccess().getTreeTableView().setPreferredSize(dimension);
    }

    public void setTreePreferredWidth(int n) {
        this.getTreeTableAccess().getTreeTableView().setTreePreferredWidth(n);
    }

    public void setTableColumnPreferredWidth(int n, int n2) {
        this.getTreeTableAccess().getTreeTableView().setTableColumnPreferredWidth(n, n2);
    }

    public void setTableColumns(String[] stringArray) throws IntrospectionException {
        if (this.beanNode == null) {
            throw new IntrospectionException("explored beans not yet known, use setTableNodes() first!");
        }
        this.tableHolder.setTableColumns(this.beanNode, stringArray);
        this.tableColumnNames = stringArray;
    }

    public String[] getTableColumnNames() {
        return this.tableColumnNames;
    }

    @Override
    public void setTableColumns(GPNode gPNode, String[] stringArray) {
        this.tableHolder.setTableColumns(gPNode, stringArray);
    }

    @Override
    public void setTableColumns(Object object) throws IntrospectionException {
        this.tableHolder.setTableColumns(object);
    }

    @Override
    public void setTableColumns(Object object, String[] stringArray) throws IntrospectionException {
        this.tableHolder.setTableColumns(object, stringArray);
    }

    @Override
    public void setTableColumns(Class[] classArray, String[] stringArray) {
        this.tableHolder.setTableColumns(classArray, stringArray);
    }

    @Override
    public void setTableColumns(Class[] classArray, String[] stringArray, boolean[] blArray) {
        this.tableHolder.setTableColumns(classArray, stringArray, blArray);
    }

    @Override
    public void setTableColumns(GPNode gPNode, String[] stringArray, boolean[] blArray) {
        this.tableHolder.setTableColumns(gPNode, stringArray, blArray);
    }

    @Override
    public void setTableColumns(Object object, String[] stringArray, boolean[] blArray) throws IntrospectionException {
        this.tableHolder.setTableColumns(object, stringArray, blArray);
    }

    @Override
    public void setTableColumns(Class clazz) throws IntrospectionException {
        this.tableHolder.setTableColumns(clazz);
    }

    @Override
    public void setTableColumns(Class clazz, String[] stringArray) throws IntrospectionException {
        this.tableHolder.setTableColumns(clazz, stringArray);
    }

    @Override
    public void setProperties(Node.Property[] propertyArray, boolean[] blArray) {
        if (blArray != null) {
            for (int i = 0; i < propertyArray.length; ++i) {
                if (!blArray[i]) continue;
                propertyArray[i].setValue(ATTR_COMPARABLE_COLUMN, (Object)Boolean.TRUE);
            }
        } else {
            for (int i = 0; i < propertyArray.length; ++i) {
                propertyArray[i].setValue(ATTR_COMPARABLE_COLUMN, (Object)Boolean.TRUE);
            }
        }
        if (this.isVisible()) {
            this.setVisible(false);
            this.treeTableViewTableAccess.getTreeTableView().setProperties(propertyArray);
            this.setVisible(true);
        } else {
            this.treeTableViewTableAccess.getTreeTableView().setProperties(propertyArray);
        }
    }

    private boolean areAllNodesLeaves(GPNode[] gPNodeArray) {
        for (int i = 0; i < gPNodeArray.length; ++i) {
            if (gPNodeArray[i].getNodeCollection() == null) continue;
            return false;
        }
        return true;
    }

    private static class GPTreeTableView
    extends TreeTableView
    implements TreeTableViewTableAccess {
        public GPTreeTableView(NodeTableModel nodeTableModel) {
            super(nodeTableModel);
        }

        public GPTreeTableView() {
        }

        @Override
        public JTree getTree() {
            return this.tree;
        }

        @Override
        public JTable getTable() {
            return this.treeTable;
        }

        @Override
        public TreeTableView getTreeTableView() {
            return this;
        }

        @Override
        public TreeView getTreeView() {
            return this;
        }
    }
}

