/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.explorer;

import cern.gp.explorer.GPListExplorerPanel;
import cern.gp.explorer.ListViewListAccess;
import cern.gp.explorer.NamedBean;
import cern.gp.nodes.GPNode;
import cern.gp.nodes.impl.NodeUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.IntrospectionException;
import javax.swing.JList;
import org.openide.explorer.view.ListView;

public class ListExplorer
extends GPListExplorerPanel {
    private final ListViewListAccess listViewListAccess;

    public ListExplorer() {
        this(new GPListView());
    }

    public ListExplorer(GPNode[] gPNodeArray) {
        this();
        this.setListNodes(gPNodeArray);
    }

    protected ListExplorer(ListViewListAccess listViewListAccess) {
        this.listViewListAccess = listViewListAccess;
        this.setLayout(new BorderLayout());
        this.add((Component)listViewListAccess.getListView(), "Center");
    }

    public ListViewListAccess getListAccess() {
        return this.listViewListAccess;
    }

    @Override
    public final void setListNodes(GPNode[] gPNodeArray) {
        if (gPNodeArray.length <= 0) {
            return;
        }
        if (NodeUtils.haveOneCommonParent(gPNodeArray)) {
            this.setRootNode(gPNodeArray[0].getParent());
        } else {
            try {
                NamedBean namedBean = new NamedBean("");
                this.setRootBean(namedBean);
                this.setRootNode(ListExplorer.createRootNode(namedBean, gPNodeArray));
            }
            catch (IntrospectionException introspectionException) {
                introspectionException.printStackTrace();
            }
        }
    }

    private static class GPListView
    extends ListView
    implements ListViewListAccess {
        @Override
        public JList getList() {
            return this.list;
        }

        @Override
        public ListView getListView() {
            return this;
        }
    }
}

