/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.explorer;

import cern.gp.explorer.NamedBean;
import cern.gp.nodes.GPNode;
import cern.gp.nodes.NodeFactory;
import cern.gp.nodes.children.DefaultChildrenListManager;
import cern.gp.nodes.children.NodeCollection;
import cern.gp.nodes.children.NodeList;
import cern.gp.nodes.children.NodeMap;
import java.beans.IntrospectionException;
import java.util.Iterator;
import org.openide.explorer.ExplorerPanel;

public abstract class GPListExplorerPanel
extends ExplorerPanel {
    private GPNode rootNode;
    private Object rootBean;

    protected GPListExplorerPanel() {
        this.putClientProperty("PersistenceType", "Never");
    }

    public void setRootNode(GPNode gPNode) {
        this.rootNode = gPNode;
        this.getExplorerManager().setRootContext(gPNode.getPeerNode());
    }

    public GPNode getRootNode() {
        return this.rootNode;
    }

    public void setName(String string) {
        if (this.rootBean != null && this.rootBean instanceof NamedBean) {
            ((NamedBean)this.rootBean).setName(string);
        }
        super.setName(string);
    }

    public GPNode[] getListNodes() {
        NodeCollection nodeCollection = this.rootNode.getNodeCollection();
        GPNode[] gPNodeArray = new GPNode[nodeCollection.getNodesCount()];
        if (nodeCollection instanceof NodeList) {
            Iterator iterator = ((NodeList)nodeCollection).iterator();
            for (int i = 0; i < gPNodeArray.length && iterator.hasNext(); ++i) {
                gPNodeArray[i] = (GPNode)iterator.next();
            }
        } else if (nodeCollection instanceof NodeMap) {
            NodeMap nodeMap = (NodeMap)nodeCollection;
            Iterator iterator = nodeMap.keySet().iterator();
            for (int i = 0; i < gPNodeArray.length && iterator.hasNext(); ++i) {
                gPNodeArray[i] = nodeMap.getNode(iterator.next());
            }
        } else {
            throw new RuntimeException("internal error: unknown NodeCollection class: " + nodeCollection.getClass());
        }
        return gPNodeArray;
    }

    public abstract void setListNodes(GPNode[] var1);

    public static GPNode createRootNode(Object object, GPNode[] gPNodeArray) throws IntrospectionException {
        return NodeFactory.createNode(object, new DefaultChildrenListManager(gPNodeArray));
    }

    protected final Object getRootBean() {
        return this.rootBean;
    }

    protected final void setRootBean(Object object) {
        this.rootBean = object;
    }
}

