/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.beans.editors.support;

import java.awt.Font;
import java.util.HashMap;

class CachedFont {
    private final Font original;
    private HashMap derivedFonts = new HashMap();

    public CachedFont(Font font) {
        if (font == null) {
            throw new NullPointerException("must pass a non-null font");
        }
        this.derivedFonts.put(this.getStyleKey(font.getStyle()), font);
        this.original = font;
    }

    public Font getWithStyle(int n) {
        String string = this.getStyleKey(n);
        Font font = (Font)this.derivedFonts.get(string);
        if (font == null) {
            font = this.original.deriveFont(n);
            this.derivedFonts.put(string, font);
        }
        return font;
    }

    private final String getStyleKey(int n) {
        return Integer.toString(n);
    }

    public Font getOriginal() {
        return this.original;
    }
}

