/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.beans.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import javax.swing.JButton;
import javax.swing.border.LineBorder;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;
import org.openide.nodes.Node;

public class ButtonEditor
extends PropertyEditorSupport
implements EnhancedPropertyEditor,
ExPropertyEditor {
    private static final int LABEL_OFFSET = 3;
    private JButton button;
    private PropertyEnv propertyEnv;

    protected void handleButtonClick(ActionEvent actionEvent) {
        FeatureDescriptor featureDescriptor = this.propertyEnv.getFeatureDescriptor();
        if (featureDescriptor instanceof Node.Property) {
            try {
                ((Node.Property)featureDescriptor).setValue((Object)Boolean.TRUE);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.setValue(Boolean.TRUE);
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
        graphics.translate(rectangle.x - 3, rectangle.y);
        this.getButton().setSize(rectangle.width + 3, rectangle.height);
        this.getButton().paint(graphics);
        graphics.translate(-rectangle.x + 3, -rectangle.y);
    }

    public Component getInPlaceCustomEditor() {
        JButton jButton = this.getButton();
        jButton.doClick();
        return jButton;
    }

    public boolean hasInPlaceCustomEditor() {
        return true;
    }

    public boolean supportsEditingTaggedValues() {
        return false;
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        this.propertyEnv = propertyEnv;
    }

    private JButton getButton() {
        if (this.button == null) {
            this.button = this.createButton();
        }
        return this.button;
    }

    private JButton createButton() {
        if (this.propertyEnv == null) {
            throw new RuntimeException("propertyEnv variable not yet initialized");
        }
        JButton jButton = new JButton(this.propertyEnv.getFeatureDescriptor().getDisplayName());
        jButton.setHorizontalTextPosition(0);
        jButton.setHorizontalAlignment(0);
        jButton.setBorder(new LineBorder(Color.gray));
        jButton.setOpaque(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ButtonEditor.this.handleButtonClick(actionEvent);
            }
        });
        return jButton;
    }
}

