/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.beans;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;

public class BeanTagger {
    private static final String IS_CACHEABLE_PROPERTY_NAME = "beantagger.isCacheable";
    private static final String IS_EXPANDABLE_PROPERTY_NAME = "beantagger.isExpandable";
    private static final String ACTIONS_PROPERTY_NAME = "beantagger.actions";
    private static final String DEFAULT_ACTION_PROPERTY_NAME = "beantagger.defaultAction";
    private static final String EMPTY_STRING = "";

    private BeanTagger() {
    }

    public static void setCacheable(FeatureDescriptor featureDescriptor, boolean bl) {
        BeanTagger.setBooleanValue(featureDescriptor, IS_CACHEABLE_PROPERTY_NAME, bl);
    }

    public static Boolean isCacheable(FeatureDescriptor featureDescriptor) {
        return (Boolean)featureDescriptor.getValue(IS_CACHEABLE_PROPERTY_NAME);
    }

    public static void setExpandable(FeatureDescriptor featureDescriptor, boolean bl) {
        BeanTagger.setBooleanValue(featureDescriptor, IS_EXPANDABLE_PROPERTY_NAME, bl);
    }

    public static boolean isExpandable(FeatureDescriptor featureDescriptor) {
        return BeanTagger.getBooleanValue(featureDescriptor, IS_EXPANDABLE_PROPERTY_NAME);
    }

    public static void setDefaultAction(FeatureDescriptor featureDescriptor, String string) {
        featureDescriptor.setValue(DEFAULT_ACTION_PROPERTY_NAME, string);
    }

    public static void setDefaultAction(BeanInfo beanInfo, String string) {
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        if (beanDescriptor == null) {
            return;
        }
        BeanTagger.setDefaultAction(beanDescriptor, string);
    }

    public static String getDefaultAction(FeatureDescriptor featureDescriptor) {
        return (String)featureDescriptor.getValue(DEFAULT_ACTION_PROPERTY_NAME);
    }

    public static String getDefaultAction(BeanInfo beanInfo) {
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        if (beanDescriptor == null) {
            return null;
        }
        return BeanTagger.getDefaultAction(beanDescriptor);
    }

    public static void addActions(FeatureDescriptor featureDescriptor, String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("actionClasses cannot be null");
        }
        String[] stringArray2 = BeanTagger.getActions(featureDescriptor);
        if (stringArray2 == null || stringArray2.length == 0) {
            featureDescriptor.setValue(ACTIONS_PROPERTY_NAME, stringArray);
            return;
        }
        int n = 0;
        String[] stringArray3 = (String[])stringArray.clone();
        for (int i = 0; i < stringArray3.length; ++i) {
            if (stringArray3 != null && BeanTagger.doesActionExist(stringArray2, stringArray3[i])) {
                stringArray3[i] = EMPTY_STRING;
                continue;
            }
            ++n;
        }
        if (n == 0) {
            return;
        }
        String[] stringArray4 = new String[stringArray2.length + n];
        System.arraycopy(stringArray2, 0, stringArray4, 0, stringArray2.length);
        int n2 = stringArray2.length;
        for (int i = 0; i < stringArray3.length; ++i) {
            if (stringArray3[i] == EMPTY_STRING) continue;
            stringArray4[n2] = stringArray3[i];
            ++n2;
        }
        featureDescriptor.setValue(ACTIONS_PROPERTY_NAME, stringArray4);
    }

    public static String[] getActions(FeatureDescriptor featureDescriptor) {
        return (String[])featureDescriptor.getValue(ACTIONS_PROPERTY_NAME);
    }

    public static String[] getActions(BeanInfo beanInfo) {
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        if (beanDescriptor == null) {
            return null;
        }
        return BeanTagger.getActions(beanDescriptor);
    }

    public static void addActions(BeanInfo beanInfo, String[] stringArray) {
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        if (beanDescriptor == null) {
            return;
        }
        BeanTagger.addActions(beanDescriptor, stringArray);
    }

    private static final boolean getBooleanValue(FeatureDescriptor featureDescriptor, String string) {
        Object object = featureDescriptor.getValue(string);
        if (object == null) {
            return false;
        }
        return object.equals(Boolean.TRUE);
    }

    private static final void setBooleanValue(FeatureDescriptor featureDescriptor, String string, boolean bl) {
        featureDescriptor.setValue(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    private static final boolean doesActionExist(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || !stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }
}

