/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.actions.support;

import cern.gp.actions.support.ActionUtils;
import cern.gp.capabilities.Capability;
import cern.gp.nodes.GPNode;
import cern.gp.util.GPManager;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JButton;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CookieAction;
import org.openide.util.actions.SystemAction;

public abstract class BeanAction
extends CookieAction {
    private Class[] capabilityClasses;
    private int mode;

    protected BeanAction(Class clazz) {
        this(clazz, 7);
    }

    protected BeanAction(Class clazz, int n) {
        if (!Capability.class.isAssignableFrom(clazz) || !clazz.isInterface()) {
            throw new IllegalArgumentException("parameter " + clazz + " must be an Interface and inherit from Capability");
        }
        this.capabilityClasses = new Class[]{clazz};
        this.mode = n;
    }

    public String getName() {
        return "Generic GP Action";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public JButton createJButton() {
        return ActionUtils.createJButton((SystemAction)this);
    }

    protected String iconResource() {
        return "org/openide/resources/actions/clean.gif";
    }

    protected Class[] cookieClasses() {
        return this.capabilityClasses;
    }

    protected boolean surviveFocusChange() {
        return true;
    }

    protected int mode() {
        return this.mode;
    }

    protected void performAction(Node[] nodeArray) {
        for (int i = 0; i < nodeArray.length; ++i) {
            Capability capability = (Capability)nodeArray[i].getCookie(this.capabilityClasses[0]);
            try {
                if (capability == null) continue;
                if (nodeArray[i] instanceof GPNode) {
                    this.performCapability((GPNode)nodeArray[i], capability);
                    continue;
                }
                this.performCapability(null, capability);
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                GPManager.notify(4096, invocationTargetException);
            }
        }
    }

    protected abstract void performCapability(GPNode var1, Capability var2) throws InvocationTargetException;
}

