/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb.browser;

import com.cosylab.cdb.browser.Browser;
import com.cosylab.cdb.browser.CDBLogic;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

class CDBTable
extends JTable {
    boolean[] rowChanged;

    CDBTable(Object[][] objectArray, String[] stringArray) {
        super(objectArray, stringArray);
        this.tableHeader.setEnabled(false);
        this.tableHeader.setReorderingAllowed(false);
        this.rowChanged = new boolean[objectArray.length];
        this.setUpStringEditor();
    }

    public void setUpStringEditor() {
        final StringField stringField = new StringField("", 3);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(stringField){

            @Override
            public Object getCellEditorValue() {
                return stringField.getValue();
            }
        };
        this.setDefaultEditor(String.class, defaultCellEditor);
    }

    public void emptyArray() {
        for (int i = 0; i < this.rowChanged.length; ++i) {
            this.rowChanged[i] = false;
        }
    }

    class StringField
    extends JTextField {
        int counter;

        StringField(String string, int n) {
            super(n);
            this.counter = 0;
            this.setValue(string);
        }

        public void setValue(String string) {
            this.setText(string);
        }

        public String getValue() {
            return this.getText();
        }

        @Override
        protected Document createDefaultModel() {
            return new WholeStringDocument();
        }

        protected class WholeStringDocument
        extends PlainDocument {
            protected WholeStringDocument() {
            }

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                int n2 = CDBTable.this.getSelectedRow();
                int n3 = CDBTable.this.getSelectedColumn();
                if (!CDBTable.this.rowChanged[n2]) {
                    Browser.getInstance().display("MESSAGE: Row " + (n2 + 1) + " has changed. Storing its original value \"" + (String)CDBTable.this.getValueAt(n2, n3) + "\".\t[Node: " + Browser.getInstance().getPath() + "]", true);
                    CDBTable.this.rowChanged[n2] = true;
                    CDBLogic.CDBTree.setEnabled(false);
                    CDBLogic.selectedTableModel.storeVal();
                    CDBLogic.tableChanged = true;
                    if (CDBLogic.selectedTabbedPane.isEnabledAt(1)) {
                        CDBLogic.XMLIndexEnabled = true;
                        CDBLogic.selectedTabbedPane.setEnabledAt(1, false);
                    }
                    Browser.getInstance().enableButtons(true);
                }
                char[] cArray = string.toCharArray();
                char[] cArray2 = new char[cArray.length];
                int n4 = 0;
                for (int i = 0; i < cArray2.length; ++i) {
                    cArray2[n4++] = cArray[i];
                }
                super.insertString(n, new String(cArray2, 0, n4), attributeSet);
            }
        }
    }

    class CDBTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        Color background = Color.white;
        Color foreground = Color.black;
        Color selectedForeground = Color.red;

        CDBTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setFont(jTable.getFont());
            this.setText((String)object);
            return this;
        }
    }
}

