/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb.browser;

import alma.acs.util.ACSPorts;
import alma.cdbErrType.CDBRecordIsReadOnlyEx;
import com.cosylab.CDB.DAL;
import com.cosylab.CDB.JDAL;
import com.cosylab.CDB.JDALHelper;
import com.cosylab.CDB.WDAL;
import com.cosylab.CDB.WDALHelper;
import com.cosylab.cdb.CDBTreeNode;
import com.cosylab.cdb.browser.Browser;
import com.cosylab.cdb.browser.CDBAddNodeDlg;
import com.cosylab.cdb.browser.CDBTable;
import com.cosylab.cdb.browser.CDBTableModel;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.omg.CORBA.Object;

class CDBLogic
implements TreeSelectionListener,
TreeExpansionListener,
KeyListener {
    static JTree CDBTree = null;
    private static DAL dal;
    private static WDAL wdal;
    private static JDAL jdal;
    private static String hashMapKey;
    private static String originalXMLString;
    public static boolean XMLStringChanged;
    static final String titleCol1 = "ATTRIBUTE NAME";
    static final String titleCol2 = "ATTRIBUTE VALUE";
    static final String rootPrefix = "/root";
    static final int tableIndex = 0;
    static final int xmlIndex = 1;
    static boolean tableChanged;
    private static boolean tableIndexEnabled;
    static boolean XMLIndexEnabled;
    static HashMap tabbedPanes;
    static HashMap tables;
    static HashMap tableModels;
    static HashMap xmls;
    static JTabbedPane selectedTabbedPane;
    static JTextArea selectedXMLArea;
    static CDBTable selectedTable;
    static CDBTableModel selectedTableModel;

    CDBLogic() {
    }

    public static JTree setUpCDBTree(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "com.cosylab.cdb.browser.BrowserJNDIContextFactory");
        if (string == null) {
            hashtable.put("java.naming.provider.url", "corbaloc::" + ACSPorts.getIP() + ":" + ACSPorts.getCDBPort() + "/CDB");
        } else {
            hashtable.put("java.naming.provider.url", string);
        }
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext(hashtable);
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
        }
        if (initialContext == null) {
            return null;
        }
        CDBTree = new JTree((TreeNode)new CDBTreeNode("root", null, (Context)initialContext));
        CDBTree.addTreeSelectionListener(new CDBLogic());
        CDBTree.addTreeExpansionListener(new CDBLogic());
        CDBTree.setToggleClickCount(1);
        return CDBTree;
    }

    public static void setDAL(DAL dAL) {
        dal = dAL;
        try {
            wdal = WDALHelper.narrow((Object)dAL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            jdal = JDALHelper.narrow((Object)dAL);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setKey(String string) {
        hashMapKey = rootPrefix + string;
    }

    public static String getKey() {
        return hashMapKey;
    }

    public static java.lang.Object[][] getData(LinkedHashMap linkedHashMap) {
        if (!linkedHashMap.isEmpty()) {
            int n;
            int n2 = linkedHashMap.size();
            Set set = linkedHashMap.keySet();
            String[] stringArray = set.toArray(new String[n2]);
            Collection collection = linkedHashMap.values();
            java.lang.Object[] objectArray = collection.toArray();
            String[] stringArray2 = new String[n2 * 2];
            int n3 = 0;
            for (n = 0; n < n2 * 2; n += 2) {
                stringArray2[n] = stringArray[n3];
                ++n3;
            }
            n3 = 0;
            for (n = 1; n <= n2 * 2 - 1; n += 2) {
                stringArray2[n] = (String)objectArray[n3];
                ++n3;
            }
            java.lang.Object[][] objectArray2 = new java.lang.Object[n2][2];
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    objectArray2[i][j] = stringArray2[n4];
                    ++n4;
                }
            }
            return objectArray2;
        }
        return null;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        String string = CDBLogic.stringPath(treePath);
        CDBTree.setSelectionPath(treePath);
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        String string = CDBLogic.stringPath(treePath);
        CDBTree.setSelectionPath(treePath);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        String string = CDBLogic.stringPath(treePath);
        Browser.getInstance().setPath(string);
        if (tabbedPanes.containsKey(string)) {
            selectedTable = (CDBTable)tables.get(string);
            selectedTableModel = (CDBTableModel)tableModels.get(string);
            selectedXMLArea = (JTextArea)xmls.get(string);
            selectedTabbedPane = (JTabbedPane)tabbedPanes.get(string);
            Browser.getInstance().setRightComp(selectedTabbedPane, true);
        } else {
            selectedTabbedPane = null;
            selectedTable = null;
            selectedTableModel = null;
            selectedXMLArea = null;
            JTextArea jTextArea = new JTextArea();
            jTextArea.setBackground(Color.LIGHT_GRAY);
            jTextArea.setEditable(false);
            Browser.getInstance().setRightComp(jTextArea, false);
        }
    }

    public static void saveXMLString(boolean bl) {
        if (XMLStringChanged) {
            String string = selectedXMLArea.getText();
            if (bl) {
                if (wdal != null) {
                    String string2 = CDBLogic.getKey().substring(rootPrefix.length());
                    try {
                        Browser.getInstance().display("Invoking set_DAO for " + string2, true);
                        wdal.set_DAO(string2, string);
                        bl = true;
                    }
                    catch (CDBRecordIsReadOnlyEx cDBRecordIsReadOnlyEx) {
                        cDBRecordIsReadOnlyEx.printStackTrace();
                        Browser.getInstance().display("==> ERROR MESSAGE: The file or record is read only: " + (java.lang.Object)((java.lang.Object)cDBRecordIsReadOnlyEx), true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Browser.getInstance().display("==> ERROR MESSAGE: Exception while saving changes " + exception, true);
                    }
                }
                Browser.getInstance().enableButtons(false);
                CDBTree.setEnabled(true);
                if (tableIndexEnabled) {
                    selectedTabbedPane.setEnabledAt(0, true);
                    tableIndexEnabled = false;
                }
                originalXMLString = null;
            }
            if (!bl) {
                Browser.getInstance().display("==> ERROR MESSAGE: Validation function under development. ", true);
                selectedXMLArea.setText(originalXMLString);
                originalXMLString = null;
                Browser.getInstance().enableButtons(false);
                CDBTree.setEnabled(true);
                if (tableIndexEnabled) {
                    selectedTabbedPane.setEnabledAt(0, true);
                    tableIndexEnabled = false;
                }
                Browser.getInstance().display("XML string is reset to its original value.", false);
            }
            XMLStringChanged = false;
        }
    }

    public static void resetXMLString() {
        if (XMLStringChanged) {
            Browser.getInstance().display("MESSAGE: Resetting XML string for node " + Browser.getInstance().getPath() + ". ", true);
            selectedXMLArea.setText(originalXMLString);
            originalXMLString = null;
            Browser.getInstance().enableButtons(false);
            CDBTree.setEnabled(true);
            if (tableIndexEnabled) {
                selectedTabbedPane.setEnabledAt(0, true);
                tableIndexEnabled = false;
            }
            XMLStringChanged = false;
        }
    }

    public static void resetTable() {
        if (tableChanged) {
            Browser.getInstance().display("MESSAGE: Resetting values for table " + Browser.getInstance().getPath() + ". ", true);
            selectedTableModel.resetValues();
            Browser.getInstance().enableButtons(false);
            CDBTree.setEnabled(true);
            if (XMLIndexEnabled) {
                selectedTabbedPane.setEnabledAt(1, true);
                XMLIndexEnabled = false;
            }
            tableChanged = false;
            selectedTable.emptyArray();
        }
    }

    public static void saveTable() {
        if (tableChanged) {
            Browser.getInstance().display("MESSAGE: Saving values for table " + Browser.getInstance().getPath() + ". ", true);
            try {
                boolean bl = XMLIndexEnabled;
                String string = CDBLogic.getKey();
                String string2 = CDBLogic.getKey();
                while (xmls.get(string2) == null) {
                    string2 = string2.substring(0, string2.lastIndexOf(47));
                }
                String string3 = !string.equals(string2) ? string.substring(string2.length() + 1) : "";
                string2 = string2.substring("/root/".length());
                System.out.println("curl=" + string2 + " elem=" + string3);
                StringWriter stringWriter = new StringWriter();
                stringWriter.write("<?xml version='1.0' encoding='ISO-8859-1'?>\n");
                stringWriter.write("<curl ");
                if (string3.length() > 0) {
                    stringWriter.write("><" + string3 + " ");
                }
                for (int i = 0; i < selectedTableModel.getRowCount(); ++i) {
                    if (CDBLogic.selectedTableModel.resetValue.get(new Integer(i)) == null) continue;
                    System.out.println(XMLIndexEnabled + " " + Browser.getInstance().getPath() + " changed is " + selectedTableModel.getValueAt(i, 0) + "=" + selectedTableModel.getValueAt(i, 1));
                    stringWriter.write(selectedTableModel.getValueAt(i, 0) + "=\"" + selectedTableModel.getValueAt(i, 1) + "\" ");
                }
                if (string3.length() > 0) {
                    stringWriter.write("/></curl>");
                } else {
                    stringWriter.write("/>");
                }
                if (wdal != null) {
                    Browser.getInstance().display("Invoking set_DAO for " + string2, true);
                    wdal.set_DAO(string2, stringWriter.toString());
                }
            }
            catch (CDBRecordIsReadOnlyEx cDBRecordIsReadOnlyEx) {
                cDBRecordIsReadOnlyEx.printStackTrace();
                Browser.getInstance().display("==> ERROR MESSAGE: The file or record is read only: " + (java.lang.Object)((java.lang.Object)cDBRecordIsReadOnlyEx), true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Browser.getInstance().display("==> ERROR MESSAGE: Exception while saving changes " + exception, true);
            }
            Browser.getInstance().enableButtons(false);
            CDBTree.setEnabled(true);
            if (XMLIndexEnabled) {
                selectedTabbedPane.setEnabledAt(1, true);
                XMLIndexEnabled = false;
            }
            tableChanged = false;
            selectedTable.emptyArray();
        }
    }

    public static void addListener(JTextArea jTextArea) {
        jTextArea.addKeyListener(new CDBLogic());
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == selectedXMLArea && !XMLStringChanged) {
            originalXMLString = selectedXMLArea.getText();
            Browser.getInstance().display("MESSAGE: Editing XML string for node:  " + Browser.getInstance().getPath(), true);
            CDBTree.setEnabled(false);
            if (selectedTabbedPane.isEnabledAt(0)) {
                tableIndexEnabled = true;
                selectedTabbedPane.setEnabledAt(0, false);
            }
            Browser.getInstance().enableButtons(true);
            XMLStringChanged = true;
            Browser.getInstance().display(". To enable CDBTree save or reset changes made.", false);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public static boolean isXMLTabSelected() {
        if (selectedTabbedPane == null) {
            return false;
        }
        return selectedTabbedPane.getSelectedIndex() == 1;
    }

    public static void clearCache() {
        if (jdal != null) {
            jdal.clear_cache_all();
            Browser.getInstance().display("MESSAGE: Clear Cache executed sucessfully", true);
        } else {
            Browser.getInstance().display("==> ERROR MESSAGE: Clear Cache was not executed.", true);
        }
    }

    public static String stringPath(TreePath treePath) {
        java.lang.Object[] objectArray = treePath.getPath();
        String string = "";
        for (int i = 0; i < treePath.getPathCount(); ++i) {
            string = string + "/" + objectArray[i].toString();
        }
        return string;
    }

    public static void clearHashMaps() {
        tabbedPanes.clear();
        tables.clear();
        tableModels.clear();
        xmls.clear();
        selectedTabbedPane = null;
        selectedTable = null;
        selectedTableModel = null;
        selectedXMLArea = null;
    }

    public static String getCurl() {
        if (CDBLogic.getKey() == null) {
            return "";
        }
        return CDBLogic.getKey().substring(rootPrefix.length());
    }

    public static void addNode() {
        if (wdal == null) {
            Browser.getInstance().display("==> ERROR MESSAGE: Unable to narrow writable DAL server ", true);
            return;
        }
        String string = CDBLogic.getCurl();
        CDBAddNodeDlg cDBAddNodeDlg = new CDBAddNodeDlg(Browser.getInstance());
        cDBAddNodeDlg.setCurl(string + "/");
        cDBAddNodeDlg.setXML("<?xml version='1.0' encoding='ISO-8859-1'?>\n<Node>\n</Node>");
        if (cDBAddNodeDlg.showModal() != 0) {
            return;
        }
        System.out.println("Dialog showed " + cDBAddNodeDlg.getCurl() + " -> " + cDBAddNodeDlg.getXML());
        try {
            wdal.add_node(cDBAddNodeDlg.getCurl(), cDBAddNodeDlg.getXML());
        }
        catch (Exception exception) {
            Browser.getInstance().display("==> ERROR MESSAGE: Error while trying to add node " + string + " : " + exception, true);
        }
    }

    public static void deleteNode() {
        if (wdal == null) {
            Browser.getInstance().display("==> ERROR MESSAGE: Unable to narrow writable DAL server ", true);
            return;
        }
        String string = CDBLogic.getCurl();
        int n = JOptionPane.showConfirmDialog(Browser.getInstance(), "Are you sure you want to delete node " + string + "?", "Delete node", 0, 3);
        if (n != 0) {
            return;
        }
        try {
            wdal.remove_node(string);
        }
        catch (Exception exception) {
            Browser.getInstance().display("==> ERROR MESSAGE: Error while trying to delete node " + string + " : " + exception, true);
        }
    }

    static {
        wdal = null;
        jdal = null;
        originalXMLString = null;
        XMLStringChanged = false;
        tableChanged = false;
        tableIndexEnabled = false;
        XMLIndexEnabled = false;
        tabbedPanes = new HashMap();
        tables = new HashMap();
        tableModels = new HashMap();
        xmls = new HashMap();
    }
}

