/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.spi;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import oracle.aurora.rdbms.DbmsJava;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.sql.OPAQUE;
import oracle.xdb.XDBError;
import oracle.xdb.XMLType;
import oracle.xdb.bean.XMLTypeBean;
import oracle.xdb.dom.XDBBinaryDocument;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBElement;
import oracle.xdb.dom.XDBNode;
import oracle.xdb.spi.XDBContextFactory;
import oracle.xdb.spi.XDBNameParser;
import oracle.xdb.spi.XDBNamingEnumeration;
import oracle.xdb.spi.XDBResource;

public class XDBResourceContext
extends XDBResource
implements Context {
    private static final String NAME_COMPONENT_SEPARATOR = "/";
    private static final char NAME_ABSOLUTE_PREFIX = '/';
    public static final long RES_OBJ = 1L;
    public static final int OBJ_CONTAINER = 0;
    public static final int OBJ_DOCUMENT = 1;
    public static final int OBJ_BINARY_DOC = 2;
    private static final int NO_ERROR = 0;
    private static final int NOT_CONTAINER_ERROR = 1;
    private static final int NOT_FOUND_ERROR = 2;
    private static final int NOT_DONE = 3;
    private static final int INVALID_HANDLE = 4;
    private static final int ENTRY_EXISTS_ERROR = 5;
    private static final int OTHER_ERROR = 6;
    private static final int INV_RESHDL_OR_PATH_ERR = 31001;
    private static final int NOT_CONT_ERR = 31002;
    private static final int ENTRY_EXISTS_ERR = 31003;
    private static final int DBBLKSIZE_TOO_SMALL_ERR = 31004;
    private static final int PATHNAME_TOO_LONG_ERR = 31005;
    private static final int PATH_SEGMENT_TOO_LONG_ERR = 31006;
    private static final int DEL_NONEMPTY_CONT_ERR = 31007;
    private static final int XDB_SPI_UNBIND_CONTEXT_ERR = 1;
    private static final int XDB_SPI_ENUM_EMPTY_ERR = 3;
    protected static XDBNameParser s_parser;
    protected String m_path;
    protected Hashtable m_env;
    private int m_conntype;
    protected XDBElement m_resElem;

    public XDBResourceContext(Hashtable hashtable) throws NamingException, OperationNotSupportedException, SQLException {
        super((Connection)hashtable.get(XDBContextFactory.ENV_CONNECTION), (String)hashtable.get("java.naming.provider.url"), 0L);
        Object object;
        Locale locale = null;
        Hashtable hashtable2 = this.m_env = hashtable != null ? (Hashtable)hashtable.clone() : null;
        if (hashtable != null) {
            object = (String)hashtable.get("Language");
            String string = (String)hashtable.get("Country");
            this.m_path = (String)hashtable.get("java.naming.provider.url");
            locale = object == null || string == null ? Locale.getDefault() : new Locale((String)object, string);
        } else {
            locale = Locale.getDefault();
        }
        this.m_conntype = XMLType.getConnType(this.m_conn);
        object = new long[2];
        long l = 0L;
        object[0] = this.m_env.get(XDBContextFactory.RETURN_OBJECT_TYPE) == XDBContextFactory.RETURN_TYPE_RESOURCE ? (Object)1L : (Object)0L;
        switch (this.m_conntype) {
            case 2: {
                l = this.lookupKprbNative(this.m_path, (long[])object);
                this.m_xobcstate = (long)object[1];
                break;
            }
            case 1: {
                l = this.lookupThickNative(XMLType.getServiceHandle(this.m_conn, this.m_conntype), XMLType.getErrorHandle(this.m_conn, this.m_conntype), this.m_path, (long[])object);
                this.m_xobcstate = (long)object[1];
                break;
            }
            case 0: {
                throw new OperationNotSupportedException(XDBError.getMsg("THIN_NOT_SUPPORTED"));
            }
        }
        if (l != 0L) {
            this.throwException(l, this.m_path);
        }
        if (this.m_xobcstate == 0L) {
            System.out.println("lookup is null");
        }
        this.m_resElem = (XDBElement)this.getDocumentElement();
    }

    public XDBResourceContext(Hashtable hashtable, String string, long l) throws NamingException, OperationNotSupportedException, SQLException {
        super((Connection)hashtable.get(XDBContextFactory.ENV_CONNECTION), string, l);
        Locale locale = null;
        this.m_env = hashtable != null ? (Hashtable)hashtable.clone() : null;
        this.addToEnvironment("java.naming.provider.url", string);
        if (hashtable != null) {
            String string2 = (String)hashtable.get("Language");
            String string3 = (String)hashtable.get("Country");
            locale = string2 == null || string3 == null ? Locale.getDefault() : new Locale(string2, string3);
        } else {
            locale = Locale.getDefault();
        }
        this.m_path = string;
        this.m_conntype = XMLType.getConnType(this.m_conn);
        this.m_xobcstate = l;
        this.m_resElem = (XDBElement)this.getDocumentElement();
    }

    public Object addToEnvironment(String string, Object object) {
        if (this.m_env == null) {
            this.m_env = new Hashtable();
        }
        return this.m_env.put(string, object);
    }

    public void bind(String string, Object object) throws NamingException {
        Object object2;
        long l = 0L;
        long l2 = 0L;
        boolean bl = false;
        if (string == null || string.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        if (object instanceof XMLTypeBean) {
            object2 = (XDBDocument)((XMLTypeBean)object).getOwnerDocument();
            l2 = ((XDBNode)object2).toCState();
        } else if (object instanceof XDBDocument) {
            l2 = ((XDBDocument)object).toCState();
        } else if (object instanceof XDBResource || object instanceof XDBResourceContext) {
            bl = true;
            l2 = ((XDBDocument)object).toCState();
        } else if (object instanceof String) {
            object2 = new ByteArrayInputStream(((String)object).getBytes());
            l2 = this.createBinaryDocFromInputStream((InputStream)object2);
        } else if (object instanceof InputStream) {
            l2 = this.createBinaryDocFromInputStream((InputStream)object);
        } else if (object instanceof File) {
            try {
                object2 = new FileInputStream((File)object);
                l2 = this.createBinaryDocFromInputStream((InputStream)object2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CannotProceedException(fileNotFoundException.toString());
            }
        } else {
            throw new OperationNotSupportedException(XDBError.getMsg("INVALID_OBJECT_ERROR"));
        }
        object2 = this.makeAbsoluteName(string, this.m_path);
        switch (this.m_conntype) {
            case 2: {
                l = this.bindKprbNative((String)object2, l2, bl);
                break;
            }
            case 1: {
                l = this.bindThick((String)object2, l2, bl);
                break;
            }
        }
        if (l != 0L) {
            this.throwException(l, string);
        }
    }

    public void bind(Name name, Object object) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        this.bind(name.toString(), object);
    }

    private native long bindKprbNative(String var1, long var2, boolean var4);

    private long bindThick(String string, long l, boolean bl) {
        String string2 = "declare retb boolean; begin retb := dbms_xdb.createResource(?, ?); end;";
        long l2 = 0L;
        try {
            OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)this.m_conn.prepareCall(string2);
            XDBDocument xDBDocument = new XDBDocument(this.m_conn, l);
            XMLType xMLType = new XMLType(this.m_conn, xDBDocument);
            oracleCallableStatement.setString(1, string);
            oracleCallableStatement.setOPAQUE(2, (OPAQUE)xMLType);
            oracleCallableStatement.execute();
            oracleCallableStatement.close();
        }
        catch (Exception exception) {
            l2 = 2L;
        }
        return l2;
    }

    public void close() {
        this.m_env = null;
        this.m_path = null;
    }

    public String composeName(String string, String string2) {
        return String.valueOf(string2) + NAME_COMPONENT_SEPARATOR + string;
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        name3.addAll(name);
        return name3;
    }

    /*
     * Unable to fully structure code
     */
    private long createBinaryDocFromInputStream(InputStream var1_1) throws NamingException {
        var2_2 = new byte[1024];
        var5_3 = 0L;
        var7_4 = 0;
        var8_5 = 0L;
        try {
            var11_6 = var1_1.available();
            switch (this.m_conntype) {
                case 2: {
                    var3_7 = XDBResource.getServerEnv();
                    if (true) ** GOTO lbl16
                }
                default: {
                    throw new OperationNotSupportedException(XDBError.getMsg("INVALID_OBJECT_ERROR"));
                }
            }
            do {
                var5_3 = this.writeToStreamNative(var3_7, var5_3, var11_6, var2_2, var7_4, var10_8);
                var7_4 += var2_2.length;
lbl16:
                // 2 sources

            } while ((var10_8 = var1_1.read(var2_2)) != -1);
            var8_5 = this.createBinaryFromStreamNative(var3_7, var5_3);
        }
        catch (Exception var10_9) {
            throw new CannotProceedException(var10_9.toString());
        }
        return var8_5;
    }

    private native long createBinaryFromStreamNative(long var1, long var3);

    private native long createSubKprbNative(String var1);

    private long createSubThick(String string, long[] lArray) {
        String string2 = "declare retb boolean; begin retb := dbms_xdb.createFolder(?); end;";
        long l = 0L;
        try {
            OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)this.m_conn.prepareCall(string2);
            oracleCallableStatement.setString(1, string);
            oracleCallableStatement.execute();
            oracleCallableStatement.close();
            l = 0L;
            long[] lArray2 = new long[2];
            lArray2[0] = 1L;
            l = this.lookupThickNative(XMLType.getServiceHandle(this.m_conn, this.m_conntype), XMLType.getErrorHandle(this.m_conn, this.m_conntype), string, lArray2);
            lArray[0] = lArray2[1];
        }
        catch (Exception exception) {
            l = exception instanceof SQLException ? (long)((SQLException)exception).getErrorCode() : 2L;
        }
        return l;
    }

    public Context createSubcontext(String string) throws NamingException {
        if (string == null || string.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        String string2 = this.makeAbsoluteName(string, this.m_path);
        long l = 0L;
        switch (this.m_conntype) {
            case 2: {
                long[] lArray = new long[1];
                l = this.createSubKprbNative(string2);
                if (l != 0L) {
                    this.throwException(l, string);
                }
                try {
                    return new XDBResourceContext(this.m_env, string2, lArray[0]);
                }
                catch (SQLException sQLException) {
                    return null;
                }
            }
            case 1: {
                long[] lArray = new long[1];
                l = this.createSubThick(string2, lArray);
                if (l != 0L) {
                    this.throwException(l, string);
                }
                try {
                    return new XDBResourceContext(this.m_env, string2, lArray[0]);
                }
                catch (SQLException sQLException) {
                    return null;
                }
            }
        }
        return null;
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        return this.createSubcontext(name.toString());
    }

    private native long destroySubKprbNative(String var1);

    private long destroySubThick(String string) {
        return this.unbindThick(string);
    }

    public void destroySubcontext(String string) throws NamingException {
        if (string == null || string.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        String string2 = this.makeAbsoluteName(string, this.m_path);
        long l = 0L;
        switch (this.m_conntype) {
            case 2: {
                l = this.destroySubKprbNative(string2);
                if (l == 0L) break;
                this.throwException(l, string);
                break;
            }
            case 1: {
                l = this.destroySubThick(string2);
                if (l == 0L) break;
                this.throwException(l, string);
                break;
            }
        }
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        this.destroySubcontext(name.toString());
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.m_env == null) {
            return new Hashtable();
        }
        return (Hashtable)this.m_env.clone();
    }

    public String getNameInNamespace() throws NamingException {
        return this.m_path;
    }

    public NameParser getNameParser(String string) throws NamingException {
        return s_parser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public static native String getSchemaNameNative(long var0, String[] var2);

    public NamingEnumeration list(String string) throws NamingException {
        if (string == null || string.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        String string2 = this.makeAbsoluteName(string, this.m_path);
        long l = 0L;
        long[] lArray = new long[1];
        switch (this.m_conntype) {
            case 2: {
                l = this.listKprbNative(string2, lArray);
                if (l != 0L) {
                    this.throwException(l, string);
                }
                try {
                    return new XDBNamingEnumeration(this.m_env, this.m_conn, lArray[0], string2, XDBNamingEnumeration.NAMING_TYPE_NAMECLASS);
                }
                catch (SQLException sQLException) {
                    return null;
                }
            }
            case 1: {
                try {
                    l = this.listThickNative(XMLType.getServiceHandle(this.m_conn, this.m_conntype), XMLType.getErrorHandle(this.m_conn, this.m_conntype), string2, lArray);
                    if (l != 0L) {
                        this.throwException(l, string);
                    }
                    return new XDBNamingEnumeration(this.m_env, this.m_conn, lArray[0], string2, XDBNamingEnumeration.NAMING_TYPE_NAMECLASS);
                }
                catch (SQLException sQLException) {
                    return null;
                }
            }
        }
        return null;
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        if (string == null || string.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        String string2 = this.makeAbsoluteName(string, this.m_path);
        long l = 0L;
        switch (this.m_conntype) {
            case 2: {
                long[] lArray = new long[1];
                l = this.listKprbNative(string2, lArray);
                if (l != 0L) {
                    this.throwException(l, string);
                }
                try {
                    return new XDBNamingEnumeration(this.m_env, this.m_conn, lArray[0], string2, XDBNamingEnumeration.NAMING_TYPE_NAMEBINDING);
                }
                catch (SQLException sQLException) {
                    return null;
                }
            }
            case 1: {
                long[] lArray = new long[1];
                try {
                    l = this.listThickNative(XMLType.getServiceHandle(this.m_conn, this.m_conntype), XMLType.getErrorHandle(this.m_conn, this.m_conntype), string2, lArray);
                    if (l != 0L) {
                        this.throwException(l, string);
                    }
                    return new XDBNamingEnumeration(this.m_env, this.m_conn, lArray[0], string2, XDBNamingEnumeration.NAMING_TYPE_NAMEBINDING);
                }
                catch (SQLException sQLException) {
                    break;
                }
            }
        }
        return null;
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        return this.listBindings(name.toString());
    }

    private native long listKprbNative(String var1, long[] var2);

    private native long listThickNative(long var1, long var3, String var5, long[] var6);

    public Object lookup(String string) throws NamingException {
        if (string == null || string.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        String string2 = this.makeAbsoluteName(string, this.m_path);
        switch (this.m_conntype) {
            case 1: 
            case 2: {
                long[] lArray = new long[2];
                long l = 0L;
                lArray[0] = this.m_env.get(XDBContextFactory.RETURN_OBJECT_TYPE) == XDBContextFactory.RETURN_TYPE_RESOURCE ? 1L : 0L;
                try {
                    l = this.m_conntype == 2 ? this.lookupKprbNative(string2, lArray) : this.lookupThickNative(XMLType.getServiceHandle(this.m_conn, this.m_conntype), XMLType.getErrorHandle(this.m_conn, this.m_conntype), string2, lArray);
                }
                catch (SQLException sQLException) {}
                if (l != 0L) {
                    this.throwException(l, string);
                }
                if (lArray[0] == 0L) {
                    try {
                        return new XDBResourceContext(this.m_env, string2, lArray[1]);
                    }
                    catch (SQLException sQLException) {
                        return null;
                    }
                }
                if (this.m_env.get(XDBContextFactory.RETURN_OBJECT_TYPE) == XDBContextFactory.RETURN_TYPE_RESOURCE) {
                    return new XDBResource(this.m_conn, string2, lArray[1]);
                }
                if (lArray[0] == 2L) {
                    XDBBinaryDocument xDBBinaryDocument = new XDBBinaryDocument(this.m_conn, lArray[1]);
                    return xDBBinaryDocument;
                }
                XDBDocument xDBDocument = new XDBDocument(this.m_conn, lArray[1]);
                String[] stringArray = new String[1];
                String string3 = XDBResourceContext.getSchemaNameNative(xDBDocument.toCState(), stringArray);
                if (string3 == null || this.m_conntype == 1) {
                    return xDBDocument;
                }
                try {
                    Object t = DbmsJava.classForNameAndSchema((String)string3, (String)stringArray[0].toUpperCase()).newInstance();
                    XMLTypeBean xMLTypeBean = (XMLTypeBean)t;
                    xMLTypeBean.setOwner(xDBDocument);
                    xMLTypeBean.setKidNum(0L);
                    xMLTypeBean.setXobCstate(((XDBNode)((Object)xDBDocument.getDocumentElement())).toCState());
                    return xMLTypeBean;
                }
                catch (Exception exception) {
                    return xDBDocument;
                }
            }
            case 0: {
                return null;
            }
        }
        return null;
    }

    public Object lookup(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException();
        }
        return this.lookup(name.toString());
    }

    private native long lookupKprbNative(String var1, long[] var2);

    public Object lookupLink(String string) throws NamingException {
        return this.lookup(string);
    }

    public Object lookupLink(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        return this.lookup(name.toString());
    }

    private native long lookupThickNative(long var1, long var3, String var5, long[] var6);

    private String makeAbsoluteName(String string, String string2) throws NamingException {
        if (string.charAt(0) == '/') {
            return string;
        }
        return this.composeName(string, string2);
    }

    public void rebind(String string, Object object) throws NamingException {
        try {
            this.unbind(string);
        }
        catch (Exception exception) {}
        this.bind(string, object);
    }

    public void rebind(Name name, Object object) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        this.rebind(name.toString(), object);
    }

    public Object removeFromEnvironment(String string) {
        if (this.m_env == null) {
            return null;
        }
        return this.m_env.remove(string);
    }

    public void rename(String string, String string2) throws NamingException {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        String string3 = this.makeAbsoluteName(string, this.m_path);
        String string4 = this.makeAbsoluteName(string2, this.m_path);
        long l = 0L;
        switch (this.m_conntype) {
            case 2: {
                l = this.renameKprbNative(string3, string4);
                break;
            }
            case 1: {
                l = this.renameThick(string3, string4);
                break;
            }
        }
        if (l != 0L) {
            this.throwException(l, string);
        }
    }

    public void rename(Name name, Name name2) throws NamingException {
        if (name == null || name2 == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        this.rename(name.toString(), name2.toString());
    }

    private native long renameKprbNative(String var1, String var2);

    private long renameThick(String string, String string2) {
        String string3 = "begin dbms_xdb.renameResource(?, ?, ?); end;";
        long l = 0L;
        try {
            OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)this.m_conn.prepareCall(string3);
            Name name = s_parser.parse(string2);
            String string4 = name.get(name.size() - 1);
            Name name2 = name.getPrefix(name.size() - 1);
            String string5 = name2.toString();
            oracleCallableStatement.setString(1, string);
            oracleCallableStatement.setString(2, string5);
            oracleCallableStatement.setString(3, string4);
            oracleCallableStatement.execute();
            oracleCallableStatement.close();
        }
        catch (Exception exception) {
            l = exception instanceof SQLException ? (long)((SQLException)exception).getErrorCode() : 2L;
        }
        return l;
    }

    private void throwException(long l, String string) throws NameNotFoundException, NotContextException, NameAlreadyBoundException, NamingException, ContextNotEmptyException, NoSuchElementException, RuntimeException {
        switch ((int)l) {
            case 2: 
            case 31001: {
                throw new NameNotFoundException(string);
            }
            case 31002: {
                throw new NotContextException(string);
            }
            case 31003: {
                throw new NameAlreadyBoundException(string);
            }
            case 31005: {
                throw new NamingException(String.valueOf(string) + " " + XDBError.getMsg("PATH_TOO_LONG"));
            }
            case 31006: {
                throw new NamingException(String.valueOf(string) + " " + XDBError.getMsg("PATH_ELEM_TOO_LONG"));
            }
            case 31007: {
                throw new ContextNotEmptyException(string);
            }
            case 1: {
                throw new NamingException(String.valueOf(string) + " " + XDBError.getMsg("CANT_UNBIND_SUBCONTEXT"));
            }
            case 3: {
                throw new NoSuchElementException(XDBError.getMsg("END_OF_ENUM"));
            }
        }
        throw new RuntimeException(string);
    }

    public void unbind(String string) throws NamingException {
        if (string == null || string.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        String string2 = this.makeAbsoluteName(string, this.m_path);
        long l = 0L;
        switch (this.m_conntype) {
            case 2: {
                l = this.unbindKprbNative(string2);
                break;
            }
            case 1: {
                l = this.unbindThick(string2);
                break;
            }
        }
        if (l != 0L) {
            this.throwException(l, string);
        }
    }

    public void unbind(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        this.unbind(name.toString());
    }

    private native long unbindKprbNative(String var1);

    private long unbindThick(String string) {
        String string2 = "begin dbms_xdb.deleteResource(?); end;";
        long l = 0L;
        try {
            OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)this.m_conn.prepareCall(string2);
            oracleCallableStatement.setString(1, string);
            oracleCallableStatement.execute();
            oracleCallableStatement.close();
        }
        catch (Exception exception) {
            l = exception instanceof SQLException ? (long)((SQLException)exception).getErrorCode() : 2L;
        }
        return l;
    }

    private native long writeToStreamNative(long var1, long var3, int var5, byte[] var6, int var7, int var8);
}

