/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.spi;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.InvalidAttributeValueException;
import oracle.xdb.RealInputStream;
import oracle.xdb.XMLType;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBElement;
import oracle.xdb.spi.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XDBResource
extends XDBDocument
implements Resource {
    private static String RES_OWNERID = "OwnerId";
    private static String RES_CHARSET = "CharSet";
    private static String RES_CREATEDATE = "CreationDate";
    private static String RES_MODDATE = "ModificationDate";
    private static String RES_AUTHOR = "Author";
    private static String RES_DISPLAYNAME = "DisplayName";
    private static String RES_COMMENT = "Comment";
    private static String RES_LANGUAGE = "Language";
    private static String RES_CONTENTTYPE = "ContentType";
    private static String RES_VERSIONID = "VersionId";
    private static String RES_FLAGS = "Flags";
    private static String RES_SCHEMA_ELEMENT = "SchemaElement";
    private static String RES_LAST_MOD = "LastModifier";
    private static String RES_CREATOR = "Creator";
    private static String RES_OWNER = "Owner";
    private static String RES_ACL = "acl";
    private static final int NO_ERROR = 0;
    private static final int NOT_CONTAINER_ERROR = 1;
    private static final int NOT_FOUND_ERROR = 2;
    private static final int NOT_DONE = 3;
    private static final int INVALID_HANDLE = 4;
    private static final int ENTRY_EXISTS_ERROR = 5;
    private static final int OTHER_ERROR = 6;
    private static final int INV_RESHDL_OR_PATH_ERR = 31001;
    private static final int NOT_CONT_ERR = 31002;
    private static final int ENTRY_EXISTS_ERR = 31003;
    private static final int DBBLKSIZE_TOO_SMALL_ERR = 31004;
    private static final int PATHNAME_TOO_LONG_ERR = 31005;
    private static final int PATH_SEGMENT_TOO_LONG_ERR = 31006;
    private static final int DEL_NONEMPTY_CONT_ERR = 31007;
    private static final int XDB_SPI_UNBIND_CONTEXT_ERR = 1;
    private static final int XDB_SPI_ENUM_EMPTY_ERR = 3;
    protected Element m_resElem;
    protected String m_path;
    private static int RES_FLAGS_CONTAINER = 8;
    private static int CONTENT_XML = 1;
    private static int CONTENT_BINARY = 2;

    public XDBResource(Connection connection, String string, long l) {
        super(connection, l);
        this.m_resElem = this.getDocumentElement();
        this.m_path = string;
    }

    public XDBResource(XMLType xMLType, Connection connection, String string) {
        super(xMLType, connection, 0L);
        this.m_path = string;
    }

    public String getACL() {
        if (this.m_resElem instanceof XDBElement) {
            return this.getACLNative(((XDBElement)this.m_resElem).toCState());
        }
        return null;
    }

    private native String getACLNative(long var1);

    public String getAuthor() {
        return this.getProperty(RES_AUTHOR);
    }

    public String getCharacterSet() {
        return this.getProperty(RES_CHARSET);
    }

    public String getComment() {
        return this.getProperty(RES_COMMENT);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getContentBinary() {
        long l = 0L;
        try {
            int n = XMLType.getConnType(this.m_conn);
            switch (n) {
                case 2: {
                    l = this.getContentKprb(((XDBElement)this.m_resElem).toCState(), CONTENT_BINARY);
                    if (l != 0L) return new RealInputStream(0L, l, 2, XDBDocument.getGP(this.m_conn));
                    return null;
                }
                case 1: {
                    l = this.getContentThick(XMLType.getServiceHandle(this.m_conn, n), XMLType.getErrorHandle(this.m_conn, n), this.m_path, CONTENT_BINARY);
                    if (l != 0L) return new RealInputStream(0L, l, 2, XDBDocument.getGP(this.m_conn));
                    return null;
                }
                case 0: {
                    return null;
                }
                default: {
                    return new RealInputStream(0L, l, 2, XDBDocument.getGP(this.m_conn));
                }
            }
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    private native long getContentKprb(long var1, int var3);

    private native long getContentThick(long var1, long var3, String var5, int var6);

    public String getContentType() {
        return this.getProperty(RES_CONTENTTYPE);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document getContentXML() {
        long l = 0L;
        try {
            int n = XMLType.getConnType(this.m_conn);
            switch (n) {
                case 2: {
                    l = this.getContentKprb(((XDBElement)this.m_resElem).toCState(), CONTENT_XML);
                    if (l != 0L) return new XDBDocument(this.m_conn, l);
                    return null;
                }
                case 1: {
                    l = this.getContentThick(XMLType.getServiceHandle(this.m_conn, n), XMLType.getErrorHandle(this.m_conn, n), this.m_path, CONTENT_XML);
                    if (l != 0L) return new XDBDocument(this.m_conn, l);
                    return null;
                }
                case 0: {
                    return null;
                }
                default: {
                    return new XDBDocument(this.m_conn, l);
                }
            }
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public Timestamp getCreationDate() {
        String string = this.getProperty(RES_CREATEDATE);
        return Timestamp.valueOf(string.replace('T', ' '));
    }

    public String getCreator() {
        return this.getProperty(RES_CREATOR);
    }

    public String getDisplayName() {
        return this.getProperty(RES_DISPLAYNAME);
    }

    public String getLanguage() {
        return this.getProperty(RES_LANGUAGE);
    }

    public String getLastModifier() {
        return this.getProperty(RES_LAST_MOD);
    }

    public Timestamp getModificationDate() {
        String string = this.getProperty(RES_MODDATE);
        return Timestamp.valueOf(string.replace('T', ' '));
    }

    public String getOwner() {
        return this.getProperty(RES_OWNER);
    }

    public long getOwnerId() {
        long l;
        String string = this.getProperty(RES_OWNERID);
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            l = 0L;
        }
        return l;
    }

    private String getProperty(String string) {
        NodeList nodeList = this.m_resElem.getElementsByTagName(string);
        if (nodeList == null) {
            return null;
        }
        Node node = nodeList.item(0);
        if (node == null) {
            return null;
        }
        if ((node = node.getFirstChild()) == null) {
            return null;
        }
        return node.getNodeValue();
    }

    public String getSchemaElement() {
        return this.getProperty(RES_SCHEMA_ELEMENT);
    }

    public static native long getServerEnv();

    public int getSize() {
        if (this.m_resElem instanceof XDBElement) {
            return this.getSizeNative(((XDBElement)this.m_resElem).toCState());
        }
        return 0;
    }

    private native int getSizeNative(long var1);

    public int getVersionId() {
        int n;
        String string = this.getProperty(RES_OWNERID);
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    public boolean isFolder() {
        long l;
        try {
            l = Long.parseLong(this.getProperty(RES_FLAGS));
        }
        catch (NumberFormatException numberFormatException) {
            l = 0L;
        }
        return (l & (long)RES_FLAGS_CONTAINER) == (long)RES_FLAGS_CONTAINER;
    }

    public void save() {
        if (this.m_resElem instanceof XDBElement) {
            this.saveNative(((XDBElement)this.m_resElem).toCState());
        }
    }

    private native void saveNative(long var1);

    public void setACL(String string) throws InvalidAttributeValueException {
        if (!(this.m_resElem instanceof XDBElement)) {
            throw new InvalidAttributeValueException();
        }
        this.setACLNative(((XDBElement)this.m_resElem).toCState(), string, true);
    }

    private native long setACLNative(long var1, String var3, boolean var4);

    public void setAuthor(String string) throws InvalidAttributeValueException {
        this.setProperty(RES_AUTHOR, string);
    }

    public void setCharacterSet(String string) throws InvalidAttributeValueException {
        this.setProperty(RES_CHARSET, string);
    }

    public void setComment(String string) throws InvalidAttributeValueException {
        this.setProperty(RES_COMMENT, string);
    }

    public void setContent(Object object) throws InvalidAttributeValueException, OperationNotSupportedException {
    }

    public void setContentType(String string) throws InvalidAttributeValueException {
        this.setProperty(RES_CONTENTTYPE, string);
    }

    public void setCreationDate(Timestamp timestamp) throws InvalidAttributeValueException {
        this.setProperty(RES_CREATEDATE, timestamp.toString());
    }

    public void setCreator(String string) throws InvalidAttributeValueException {
        this.setProperty(RES_CREATOR, string);
    }

    public void setDisplayName(String string) throws InvalidAttributeValueException {
        this.setProperty(RES_DISPLAYNAME, string);
    }

    public void setLanguage(String string) throws InvalidAttributeValueException {
        this.setProperty(RES_LANGUAGE, string);
    }

    public void setLastModifier(String string) throws InvalidAttributeValueException {
        this.setProperty(RES_LAST_MOD, string);
    }

    public void setModificationDate(Timestamp timestamp) throws InvalidAttributeValueException {
        this.setProperty(RES_MODDATE, timestamp.toString());
    }

    public void setOwner(String string) throws InvalidAttributeValueException {
        this.setProperty(RES_OWNER, string);
    }

    public void setOwnerId(long l) throws InvalidAttributeValueException {
        this.setProperty(RES_OWNERID, String.valueOf(l));
    }

    private void setProperty(String string, String string2) {
        Node node;
        NodeList nodeList = this.m_resElem.getElementsByTagName(string);
        if (nodeList != null && (node = nodeList.item(0)) != null) {
            if ((node = node.getFirstChild()) != null) {
                node.setNodeValue(string2);
                return;
            }
            try {
                Text text = this.createTextNode(string2);
                node.appendChild(text);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            node = this.createElementNS("http://xmlns.oracle.com/xdb/XDBResource.xsd", string);
            Text text = this.createTextNode(string2);
            node.appendChild(text);
            this.m_resElem.appendChild(node);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setSchemaElement(String string) throws InvalidAttributeValueException {
        this.setProperty(RES_SCHEMA_ELEMENT, string);
    }

    public void setVersionId(int n) throws InvalidAttributeValueException {
        this.setProperty(RES_VERSIONID, String.valueOf(n));
    }
}

