/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.spi;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import oracle.aurora.rdbms.DbmsJava;
import oracle.xdb.XDBError;
import oracle.xdb.XMLType;
import oracle.xdb.bean.XMLTypeBean;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBNode;
import oracle.xdb.spi.XDBContextFactory;
import oracle.xdb.spi.XDBResource;
import oracle.xdb.spi.XDBResourceContext;

public class XDBNamingEnumeration
implements NamingEnumeration {
    public static int NAMING_TYPE_NAMECLASS = 1;
    public static int NAMING_TYPE_NAMEBINDING = 2;
    private long m_enum;
    private Hashtable m_env;
    private int m_type;
    private boolean m_closed;
    private Connection m_conn;
    private int m_conntype;
    private String m_path;

    public XDBNamingEnumeration(Hashtable hashtable, Connection connection, long l, String string, int n) throws SQLException, OperationNotSupportedException {
        this.m_enum = l;
        this.m_closed = false;
        this.m_type = n;
        this.m_conn = connection;
        this.m_conntype = XMLType.getConnType(connection);
        this.m_path = string;
        if (this.m_conntype == 0) {
            throw new OperationNotSupportedException(XDBError.getMsg("THIN_NOT_SUPPORTED"));
        }
        this.m_env = hashtable != null ? (Hashtable)hashtable.clone() : null;
    }

    public void close() {
        if (!this.m_closed) {
            switch (this.m_conntype) {
                case 2: {
                    this.closeKprbNative(this.m_enum);
                    break;
                }
                case 1: {
                    try {
                        this.closeThickNative(XMLType.getServiceHandle(this.m_conn, this.m_conntype), XMLType.getErrorHandle(this.m_conn, this.m_conntype), this.m_enum);
                    }
                    catch (SQLException sQLException) {}
                    break;
                }
            }
            this.m_closed = true;
        }
    }

    private native void closeKprbNative(long var1);

    private native void closeThickNative(long var1, long var3, long var5);

    public void finalize() throws Throwable {
        this.close();
    }

    public boolean hasMore() throws NamingException {
        boolean bl = false;
        if (!this.m_closed) {
            switch (this.m_conntype) {
                case 2: {
                    bl = this.hasMoreKprbNative(this.m_enum);
                    break;
                }
                case 1: {
                    try {
                        bl = this.hasMoreThickNative(XMLType.getServiceHandle(this.m_conn, this.m_conntype), XMLType.getErrorHandle(this.m_conn, this.m_conntype), this.m_enum);
                    }
                    catch (SQLException sQLException) {}
                    break;
                }
            }
            if (!bl) {
                this.close();
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean hasMoreElements() {
        boolean bl = false;
        try {
            bl = this.hasMore();
        }
        catch (NamingException namingException) {
            bl = false;
        }
        return bl;
    }

    private native boolean hasMoreKprbNative(long var1);

    private native boolean hasMoreThickNative(long var1, long var3, long var5);

    public Object next() throws NamingException {
        NameClassPair nameClassPair;
        String string = null;
        boolean bl = false;
        try {
            if (this.m_env.get(XDBContextFactory.RETURN_OBJECT_TYPE) == XDBContextFactory.RETURN_TYPE_RESOURCE) {
                bl = true;
            }
            if (!this.hasMore()) {
                throw new NoSuchElementException();
            }
            long[] lArray = new long[2];
            String[] stringArray = new String[1];
            lArray[0] = bl ? 1L : 0L;
            lArray[1] = this.m_type == NAMING_TYPE_NAMECLASS ? 1L : 0L;
            switch (this.m_conntype) {
                case 2: {
                    string = this.nextKprbNative(this.m_enum, lArray, stringArray);
                    break;
                }
                case 1: {
                    string = this.nextThickNative(XMLType.getServiceHandle(this.m_conn, this.m_conntype), XMLType.getErrorHandle(this.m_conn, this.m_conntype), this.m_enum, lArray, stringArray);
                    break;
                }
            }
            if (this.m_type == NAMING_TYPE_NAMECLASS) {
                NameClassPair nameClassPair2;
                nameClassPair = nameClassPair2 = new NameClassPair(string, stringArray[0]);
            } else {
                XDBNode xDBNode = null;
                if (bl) {
                    xDBNode = new XDBResource(this.m_conn, String.valueOf(this.m_path) + "/" + string, lArray[1]);
                } else if (lArray[0] == 1L) {
                    xDBNode = new XDBDocument(this.m_conn, lArray[1]);
                    if (this.m_conntype == 2) {
                        String[] stringArray2 = new String[1];
                        stringArray[0] = XDBResourceContext.getSchemaNameNative(xDBNode.toCState(), stringArray2);
                        if (stringArray[0] != null) {
                            try {
                                XMLTypeBean xMLTypeBean = (XMLTypeBean)DbmsJava.classForNameAndSchema((String)stringArray[0], (String)stringArray2[0].toUpperCase()).newInstance();
                                xMLTypeBean.setOwner((XDBDocument)xDBNode);
                                xMLTypeBean.setKidNum(0L);
                                xMLTypeBean.setXobCstate(((XDBNode)((Object)xDBNode.getDocumentElement())).toCState());
                                xDBNode = xMLTypeBean;
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else {
                    xDBNode = new XDBResourceContext(this.m_env, string, lArray[1]);
                }
                nameClassPair = new Binding(string, xDBNode);
            }
        }
        catch (SQLException sQLException) {
            nameClassPair = null;
        }
        return nameClassPair;
    }

    public Object nextElement() throws NoSuchElementException {
        try {
            return this.next();
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException();
        }
    }

    private native String nextKprbNative(long var1, long[] var3, String[] var4);

    private native String nextThickNative(long var1, long var3, long var5, long[] var7, String[] var8);
}

