/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.dom;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import oracle.xdb.dom.XDBAttribute;
import oracle.xdb.dom.XDBCData;
import oracle.xdb.dom.XDBComment;
import oracle.xdb.dom.XDBDocFragment;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBDocumentType;
import oracle.xdb.dom.XDBElement;
import oracle.xdb.dom.XDBEntity;
import oracle.xdb.dom.XDBEntityReference;
import oracle.xdb.dom.XDBNamedNodeMap;
import oracle.xdb.dom.XDBNodeList;
import oracle.xdb.dom.XDBNotation;
import oracle.xdb.dom.XDBProcInst;
import oracle.xdb.dom.XDBText;
import oracle.xdb.servlet.XDBStream;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XDBNode
implements Node {
    protected XDBDocument m_owner;
    protected long m_xobcstate;
    short m_type;
    protected Connection m_conn;
    boolean m_closed = false;

    XDBNode(XDBDocument xDBDocument, long l) {
        this.m_owner = xDBDocument;
        this.m_xobcstate = l;
        this.m_type = 0;
        if (this.m_owner != null) {
            this.m_conn = this.m_owner.m_conn;
        }
    }

    XDBNode(XDBDocument xDBDocument, long l, short s) {
        this.m_owner = xDBDocument;
        this.m_xobcstate = l;
        this.m_type = s;
        if (this.m_owner != null) {
            this.m_conn = this.m_owner.m_conn;
        }
    }

    public Node appendChild(Node node) throws DOMException {
        long l;
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        if (node.getOwnerDocument() != this.m_owner) {
            throw new DOMException(4, "Invalid node");
        }
        try {
            l = this.appendChildNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, ((XDBNode)node).toCState());
        }
        catch (DOMException dOMException) {
            if (dOMException.code == 31195) {
                throw new DOMException(7, dOMException.getMessage());
            }
            throw dOMException;
        }
        ((XDBNode)node).setXobCstate(l);
        return XDBNode.getNodeFromCState(this.m_owner, l);
    }

    private synchronized native long appendChildNative(long var1, long var3, long var5);

    public Node cloneNode(boolean bl) {
        long l = this.cloneNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, bl);
        XDBNode xDBNode = null;
        if (l != 0L) {
            switch (this.m_type) {
                case 2: {
                    xDBNode = new XDBAttribute(this.m_owner, l);
                    break;
                }
                case 4: {
                    xDBNode = new XDBCData(this.m_owner, l);
                    break;
                }
                case 8: {
                    xDBNode = new XDBComment(this.m_owner, l);
                    break;
                }
                case 11: {
                    xDBNode = new XDBDocFragment(this.m_owner, l);
                    break;
                }
                case 9: {
                    xDBNode = new XDBDocument(this.m_conn, l);
                    break;
                }
                case 10: {
                    xDBNode = new XDBDocumentType(this.m_owner, l);
                    break;
                }
                case 1: {
                    xDBNode = new XDBElement(this.m_owner, l);
                    break;
                }
                case 6: {
                    xDBNode = new XDBEntity(this.m_owner, l);
                    break;
                }
                case 5: {
                    xDBNode = new XDBEntityReference(this.m_owner, l);
                    break;
                }
                case 12: {
                    xDBNode = new XDBNotation(this.m_owner, l);
                    break;
                }
                case 7: {
                    xDBNode = new XDBProcInst(this.m_owner, l);
                    break;
                }
                case 3: {
                    xDBNode = new XDBText(this.m_owner, l);
                    break;
                }
            }
        }
        return xDBNode;
    }

    private synchronized native long cloneNodeNative(long var1, long var3, boolean var5);

    public void close() {
        this.freeNode();
    }

    private synchronized native void closeNodeNative(long var1, long var3);

    private synchronized native long createSchemaElementNative(long var1, long var3, int var5);

    public boolean equals(Object object) {
        if (object instanceof XDBNode) {
            return this.m_xobcstate == ((XDBNode)object).m_xobcstate;
        }
        return false;
    }

    public void finalize() throws Throwable {
    }

    private void freeNode() {
        if (this.m_type == 9 || this.m_type == 11) {
            ((XDBDocument)this).close();
        } else {
            if (this.m_closed) {
                return;
            }
            this.closeNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
            this.m_closed = true;
        }
    }

    private synchronized native long getAttributeMapNative(long var1, long var3);

    public NamedNodeMap getAttributes() {
        if (this.isClosed()) {
            return null;
        }
        long l = this.getAttributeMapNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        if (l == 0L) {
            return null;
        }
        return new XDBNamedNodeMap(this.m_owner, l);
    }

    public NodeList getChildNodes() {
        if (this.isClosed()) {
            return null;
        }
        long l = this.getChildNodesNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        return new XDBNodeList(l, this.m_owner);
    }

    private synchronized native long getChildNodesNative(long var1, long var3);

    private static synchronized native long getChildTypeNative(long var0, long var2);

    public String getExpandedName() {
        if (this.isClosed()) {
            return null;
        }
        return this.getExpandedNameNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
    }

    private synchronized native String getExpandedNameNative(long var1, long var3);

    public Node getFirstChild() {
        if (this.isClosed()) {
            return null;
        }
        long l = this.getFirstChildNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        return XDBNode.getNodeFromCState(this.m_owner, l);
    }

    private synchronized native long getFirstChildNative(long var1, long var3);

    public Node getLastChild() {
        if (this.isClosed()) {
            return null;
        }
        long l = this.getLastChildNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        return XDBNode.getNodeFromCState(this.m_owner, l);
    }

    private synchronized native long getLastChildNative(long var1, long var3);

    public String getLocalName() {
        if (this.isClosed()) {
            return null;
        }
        if (this.m_type == 2 || this.m_type == 1) {
            return this.getLocalNameNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        }
        return null;
    }

    private synchronized native String getLocalNameNative(long var1, long var3);

    private synchronized native String getNSUriNative(long var1, long var3);

    public String getNamespaceURI() {
        if (this.isClosed()) {
            return null;
        }
        if (this.m_type == 2) {
            return this.getNSUriNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        }
        return null;
    }

    public Node getNextSibling() {
        if (this.isClosed()) {
            return null;
        }
        long l = this.getNextSiblingNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        return XDBNode.getNodeFromCState(this.m_owner, l);
    }

    private synchronized native long getNextSiblingNative(long var1, long var3);

    protected static Node getNodeFromCState(XDBDocument xDBDocument, long l) {
        XDBNode xDBNode;
        if (l == 0L) {
            return null;
        }
        long l2 = XDBNode.getChildTypeNative(XDBDocument.getGP(xDBDocument.m_conn), l);
        switch ((int)l2) {
            case 1: {
                xDBNode = new XDBElement(xDBDocument, l);
                break;
            }
            case 2: {
                xDBNode = new XDBAttribute(xDBDocument, l);
                break;
            }
            case 3: {
                xDBNode = new XDBText(xDBDocument, l);
                break;
            }
            case 7: {
                xDBNode = new XDBProcInst(xDBDocument, l);
                break;
            }
            case 8: {
                xDBNode = new XDBComment(xDBDocument, l);
                break;
            }
            case 6: {
                xDBNode = new XDBEntity(xDBDocument, l);
                break;
            }
            case 5: {
                xDBNode = new XDBEntityReference(xDBDocument, l);
                break;
            }
            case 4: {
                xDBNode = new XDBCData(xDBDocument, l);
                break;
            }
            case 11: {
                xDBNode = new XDBDocFragment(xDBDocument, l);
                break;
            }
            case 10: {
                xDBNode = new XDBDocumentType(xDBDocument, l);
                break;
            }
            case 12: {
                xDBNode = new XDBNotation(xDBDocument, l);
                break;
            }
            default: {
                xDBNode = null;
            }
        }
        return xDBNode;
    }

    public String getNodeName() {
        if (this.isClosed()) {
            return null;
        }
        return this.getNodeNameNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
    }

    private synchronized native String getNodeNameNative(long var1, long var3);

    public short getNodeType() {
        if (this.isClosed()) {
            return 0;
        }
        return this.m_type;
    }

    public String getNodeValue() {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        if (this.m_type == 2 || this.m_type == 8 || this.m_type == 3 || this.m_type == 7) {
            return this.getNodeValueNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        }
        return null;
    }

    private synchronized native String getNodeValueNative(long var1, long var3);

    private synchronized native long getOwnerDocNative(long var1, long var3);

    public Document getOwnerDocument() {
        return this.m_owner;
    }

    public Node getParentNode() {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        if (this.m_type == 2 || this.m_type == 9 || this.m_type == 11 || this.m_type == 12 || this.m_type == 6) {
            return null;
        }
        long l = this.getParentNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        if (l != 0L) {
            return new XDBElement(this.m_owner, l);
        }
        return null;
    }

    private synchronized native long getParentNodeNative(long var1, long var3);

    public String getPrefix() {
        if (this.isClosed()) {
            return null;
        }
        if (this.m_type == 2) {
            return this.getPrefixNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        }
        return null;
    }

    private synchronized native String getPrefixNative(long var1, long var3);

    public Node getPreviousSibling() {
        if (this.isClosed()) {
            return null;
        }
        long l = this.getPreviousSiblingNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        return XDBNode.getNodeFromCState(this.m_owner, l);
    }

    private synchronized native long getPreviousSiblingNative(long var1, long var3);

    public String getQualifiedName() {
        if (this.isClosed()) {
            return null;
        }
        return this.getQualifiedNameNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
    }

    private synchronized native String getQualifiedNameNative(long var1, long var3);

    public Node getSchemaNode() {
        if (this.isClosed()) {
            return null;
        }
        long l = this.getSchemaNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        if (l == 0L) {
            return null;
        }
        long l2 = this.getOwnerDocNative(XDBDocument.getGP(this.m_owner.m_conn), l);
        if (l2 == 0L) {
            return null;
        }
        return new XDBElement(new XDBDocument(this.m_owner.m_conn, l2), l);
    }

    private synchronized native long getSchemaNodeNative(long var1, long var3);

    public boolean hasAttributes() {
        if (this.isClosed()) {
            return false;
        }
        return this.hasAttributesNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
    }

    private synchronized native boolean hasAttributesNative(long var1, long var3);

    public boolean hasChildNodes() {
        if (this.isClosed()) {
            return false;
        }
        return this.hasChildNodesNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
    }

    private synchronized native boolean hasChildNodesNative(long var1, long var3);

    public int hashCode() {
        return (int)this.m_xobcstate;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        long l = this.insertBeforeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, ((XDBNode)node).toCState(), ((XDBNode)node2).toCState());
        ((XDBNode)node).setXobCstate(l);
        return XDBNode.getNodeFromCState(this.m_owner, l);
    }

    private synchronized native long insertBeforeNative(long var1, long var3, long var5, long var7);

    protected boolean isClosed() {
        return this.m_closed || this.m_owner.isClosed();
    }

    public boolean isSupported(String string, String string2) {
        return true;
    }

    public void normalize() {
    }

    public Node removeChild(Node node) throws DOMException {
        long l;
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        long l2 = this.getParentNodeNative(XDBDocument.getGP(this.m_owner.m_conn), ((XDBNode)node).toCState());
        if (l2 == 0L) {
            throw new DOMException(8, "child node not found");
        }
        try {
            l = this.removeChildNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, ((XDBNode)node).toCState());
        }
        catch (DOMException dOMException) {
            if (dOMException.code == 31195) {
                throw new DOMException(7, dOMException.getMessage());
            }
            throw dOMException;
        }
        ((XDBNode)node).setXobCstate(l);
        return XDBNode.getNodeFromCState(this.m_owner, l);
    }

    private synchronized native long removeChildNative(long var1, long var3, long var5);

    public Node replaceChild(Node node, Node node2) throws DOMException {
        long l;
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        try {
            l = this.replaceChildNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, ((XDBNode)node).toCState(), ((XDBNode)node2).toCState());
        }
        catch (DOMException dOMException) {
            if (dOMException.code == 31195) {
                throw new DOMException(7, dOMException.getMessage());
            }
            throw dOMException;
        }
        return XDBNode.getNodeFromCState(this.m_owner, l);
    }

    private synchronized native long replaceChildNative(long var1, long var3, long var5, long var7);

    public void setNodeValue(String string) throws DOMException {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        if (this.m_type == 2 || this.m_type == 8 || this.m_type == 3 || this.m_type == 7) {
            try {
                this.setNodeValueNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, string);
            }
            catch (DOMException dOMException) {
                if (dOMException.code == 31195) {
                    throw new DOMException(7, dOMException.getMessage());
                }
                throw dOMException;
            }
        }
    }

    private synchronized native void setNodeValueNative(long var1, long var3, String var5);

    public void setNodeXob(int n) {
        long l;
        this.m_xobcstate = l = this.createSchemaElementNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_owner.m_xobcstate, n);
    }

    public void setOwner(XDBDocument xDBDocument) {
        this.m_owner = xDBDocument;
    }

    public void setPrefix(String string) throws DOMException {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        if (this.m_type == 2) {
            this.setPrefixNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, string);
        }
    }

    private synchronized native void setPrefixNative(long var1, long var3, String var5);

    public void setXobCstate(long l) {
        this.m_xobcstate = l;
    }

    public long toCState() {
        return this.m_xobcstate;
    }

    public String toString() {
        if (this.isClosed()) {
            return null;
        }
        return this.toStringNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
    }

    private synchronized native String toStringNative(long var1, long var3);

    public void write(OutputStream outputStream, String string, short s) throws IOException {
        if (!(outputStream instanceof XDBStream)) {
            throw new RuntimeException("Stream type " + outputStream.getClass() + " not supported");
        }
        ((XDBStream)((Object)outputStream)).writeXMLNative(this.m_xobcstate, string, s);
    }
}

